/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.editor;

import junit.framework.TestCase;

import org.eclipse.swt.graphics.Point;

public class GlossaryAssistProcessorTest extends TestCase {

	private final GlossaryAssistProcessor target = new GlossaryAssistProcessor();

	public void testHasSelection() {
		try {
			target.hasSelection(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertFalse(target.hasSelection(new Point(0, 0)));
		assertTrue(target.hasSelection(new Point(0, 1)));
	}

	public void testGetTargetString() {
		try {
			target.getTargetString(null, 0);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		try {
			target.getTargetString("", Integer.MIN_VALUE);
			fail();
		} catch (final StringIndexOutOfBoundsException e) {
			assertTrue(true);
		}
		try {
			target.getTargetString("", Integer.MAX_VALUE);
			fail();
		} catch (final StringIndexOutOfBoundsException e) {
			assertTrue(true);
		}
		assertEquals("", "use", target.getTargetString(" use", 4));
		assertEquals("", "use", target.getTargetString("use", 3));
		assertEquals("", "use", target.getTargetString("aaa use", 7));
		assertEquals("", "u-e", target.getTargetString("u-e", 3));
		assertEquals("", "u.e", target.getTargetString("u.e", 3));
		assertEquals("", "use", target.getTargetString("use text document", 3));
		assertEquals("", "use ", target.getTargetString("use text document", 4));
		assertEquals("", "t", target.getTargetString("use text document", 5));
		assertEquals("", "text", target.getTargetString("use text document", 8));
		assertEquals("", "document", target.getTargetString("use text document", 17));
		assertEquals("", "use", target.getTargetString("abc プロ・use", 10));
		assertEquals("", "use", target.getTargetString("abc プロロuse", 10));
	}
}
