/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.glossary.ui.preference;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;
import benten.ui.UiPlugin;
import benten.ui.fields.AbstractBrowseTextField;

public class CatGlossaryUiPreferencePageTest extends TestCase {

	public void testUpdateTmxCheck() {
		final CatGlossaryUiPreferencePage page = new CatGlossaryUiPreferencePage();
		page.createContents(UiPlugin.getShell());

		page.useTsvLocationCheck.setSelection(true);
		page.updateTsvCheck();
		assertEquals(true, page.tsvLocationText.getEnabled());

		page.useTsvLocationCheck.setSelection(false);
		page.updateTsvCheck();
		assertEquals(false, page.tsvLocationText.getEnabled());
	}

	public void testPerformOk() throws IOException {
		final CatGlossaryUiPreferencePage page = new CatGlossaryUiPreferencePage();
		page.createContents(UiPlugin.getShell());

		assertEquals(true, page.performOk());

		page.useTsvLocationCheck.setSelection(true);

		AbstractBrowseTextField.clearPreviousInput();
		page.tsvLocationText.setText("");
		assertEquals(false, page.performOk());

		AbstractBrowseTextField.clearPreviousInput();
		page.tsvLocationText.setText("x");
		assertEquals(false, page.performOk());

		final File tempFile = File.createTempFile("benten", ".file");
		AbstractBrowseTextField.clearPreviousInput();
		page.tsvLocationText.setText(tempFile.getParent());
		assertEquals(true, page.performOk());
	}
}
