/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import benten.cat.stat.model.TmHitRateModel;
import blanco.xliff.valueobject.BlancoXliffAltTrans;

public class ShowTmHitRateHandlerTest extends TestCase {

	private final ShowTmHitRateHandler handler = new ShowTmHitRateHandler();

	private List<BlancoXliffAltTrans> createAltTransList(final String... matchQuality) {
		final List<BlancoXliffAltTrans> list = new LinkedList<BlancoXliffAltTrans>();
		for (final String s : matchQuality) {
			final BlancoXliffAltTrans altTrans = new BlancoXliffAltTrans();
			altTrans.setMatchQuality(s);
			list.add(altTrans);
		}
		return list;
	}

	public void testSetModel() {
		final TmHitRateModel model = new TmHitRateModel();
		try {
			handler.setModel(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		try {
			handler.setModel(null, model);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		handler.setModel(createAltTransList(), model);
		assertEquals(0, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(1, model.getMatchUnder75());

		handler.setModel(createAltTransList(new String[] { null }), model);
		assertEquals(0, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(2, model.getMatchUnder75());

		handler.setModel(createAltTransList("x"), model);
		assertEquals(0, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("100%"), model);
		assertEquals(1, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList(" 100%"), model);
		assertEquals(2, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("100"), model);
		assertEquals(3, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("100%", "10%"), model);
		assertEquals(4, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("10%", "100%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(0, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("95%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(0, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("94%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(1, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("85%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(2, model.getMatch85());
		assertEquals(0, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("84%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(2, model.getMatch85());
		assertEquals(1, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("75%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(2, model.getMatch85());
		assertEquals(2, model.getMatch75());
		assertEquals(3, model.getMatchUnder75());

		handler.setModel(createAltTransList("74%"), model);
		assertEquals(5, model.getMatch100());
		assertEquals(1, model.getMatch95());
		assertEquals(2, model.getMatch85());
		assertEquals(2, model.getMatch75());
		assertEquals(4, model.getMatchUnder75());
	}
}
