/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import benten.cat.stat.model.TranslationRateModel;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class ShowTranslationRateHandlerTest extends TestCase {

	private final ShowTranslationRateHandler handler = new ShowTranslationRateHandler();

	private List<BlancoXliffTransUnit> createTransUnitList(final boolean translate, final String state) {
		final List<BlancoXliffTransUnit> list = new LinkedList<BlancoXliffTransUnit>();
		final BlancoXliffTransUnit unit = new BlancoXliffTransUnit();
		if (translate) {
			final BlancoXliffTarget target = new BlancoXliffTarget();
			target.setState(state);
			unit.setTarget(target);
		}
		unit.setTranslate(translate);
		list.add(unit);
		return list;
	}

	public void testSetModel() {
		TranslationRateModel model = new TranslationRateModel();
		try {
			handler.setModel(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		try {
			handler.setModel(null, model);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		model = new TranslationRateModel();
		handler.setModel(new LinkedList<BlancoXliffTransUnit>(), model);
		assertEquals(0, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 翻訳対象外
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(false, null), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(1, model.getUntranslate());
		assertEquals(100, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 未翻訳
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, ""), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(1, model.getNottranslated());
		assertEquals(100, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 未翻訳
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "new"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(1, model.getNottranslated());
		assertEquals(100, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 未翻訳
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "needs-translation"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(1, model.getNottranslated());
		assertEquals(100, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 翻訳済
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "x-reviewed"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(1, model.getTranslated());
		assertEquals(100, model.getTranslatedRate());

		// 翻訳済
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "final"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(1, model.getTranslated());
		assertEquals(100, model.getTranslatedRate());

		// 翻訳済
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "signed-off"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(0, model.getWorking());
		assertEquals(0, model.getWorkingRate());
		assertEquals(1, model.getTranslated());
		assertEquals(100, model.getTranslatedRate());

		// 翻訳中
		model = new TranslationRateModel();
		handler.setModel(createTransUnitList(true, "その他のステータス"), model);
		assertEquals(1, model.getTransUnit());
		assertEquals(0, model.getUntranslate());
		assertEquals(0, model.getUntranslateRate());
		assertEquals(0, model.getNottranslated());
		assertEquals(0, model.getNottranslatedRate());
		assertEquals(1, model.getWorking());
		assertEquals(100, model.getWorkingRate());
		assertEquals(0, model.getTranslated());
		assertEquals(0, model.getTranslatedRate());

		// 複合パターン
		final List<BlancoXliffTransUnit> list = new LinkedList<BlancoXliffTransUnit>();
		list.addAll(new LinkedList<BlancoXliffTransUnit>());
		list.addAll(createTransUnitList(false, null));
		list.addAll(createTransUnitList(true, ""));
		list.addAll(createTransUnitList(true, "new"));
		list.addAll(createTransUnitList(true, "needs-translation"));
		list.addAll(createTransUnitList(true, "x-reviewed"));
		list.addAll(createTransUnitList(true, "final"));
		list.addAll(createTransUnitList(true, "signed-off"));
		list.addAll(createTransUnitList(true, "その他のステータス"));

		model = new TranslationRateModel();
		handler.setModel(list, model);
		assertEquals(8, model.getTransUnit());
		assertEquals(1, model.getUntranslate());
		assertEquals(13, model.getUntranslateRate());
		assertEquals(3, model.getNottranslated());
		assertEquals(38, model.getNottranslatedRate());
		assertEquals(1, model.getWorking());
		assertEquals(13, model.getWorkingRate());
		assertEquals(3, model.getTranslated());
		assertEquals(38, model.getTranslatedRate());
	}
}
