/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import benten.cat.stat.model.WordCountModel;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class ShowWordCountHandlerTest extends TestCase {

	private final ShowWordCountHandler handler = new ShowWordCountHandler();

	private List<BlancoXliffTransUnit> createTransUnitList(final String source) {
		final List<BlancoXliffTransUnit> list = new LinkedList<BlancoXliffTransUnit>();
		final BlancoXliffTransUnit unit = new BlancoXliffTransUnit();
		unit.setSource(source);
		list.add(unit);
		return list;
	}

	public void testSetModel() {
		WordCountModel model = new WordCountModel();
		try {
			handler.setModel(null, null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		try {
			handler.setModel(null, model);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		model = new WordCountModel();
		handler.setModel(new LinkedList<BlancoXliffTransUnit>(), model);
		assertEquals(0, model.getWordCount());

		handler.setModel(createTransUnitList(null), model);
		assertEquals(0, model.getWordCount());

		handler.setModel(createTransUnitList(""), model);
		assertEquals(0, model.getWordCount());

		handler.setModel(createTransUnitList("test"), model);
		assertEquals(1, model.getWordCount());

		handler.setModel(createTransUnitList("test test"), model);
		assertEquals(3, model.getWordCount());

		handler.setModel(createTransUnitList("test test\r\ntest"), model);
		assertEquals(6, model.getWordCount());
	}
}
