/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.core;

import junit.framework.TestCase;

public class BentenTmDriverManagerTest extends TestCase {

	public static class TestTmDriver1 implements BentenTmDriver {
		public String getName() {
			return "test1";
		}
		public BentenTmEngine getEngineInstance() {
			return null;
		}
	}

	public static class TestTmDriver2 implements BentenTmDriver {
		public String getName() {
			return "test2";
		}
		public BentenTmEngine getEngineInstance() {
			return null;
		}
	}

	public void testRegisterDriver() {
		try {
			BentenTmDriverManager.registerDriver(null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(true);
		}
		try {
			BentenTmDriverManager.getDriver(null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(true);
		}
		assertNull(BentenTmDriverManager.getDriver("regex"));
		try {
			BentenTmDriverManager.deregisterDriver(null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(true);
		}

		final int base = BentenTmDriverManager.getDrivers().length;

		BentenTmDriverManager.registerDriver(new TestTmDriver2());
		assertEquals(base + 1, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.registerDriver(new TestTmDriver2());
		assertEquals(base + 1, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.registerDriver(new TestTmDriver1());
		assertNotNull(BentenTmDriverManager.getDriver("test1"));
		assertEquals(base + 2, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.deregisterDriver(new TestTmDriver1());
		assertEquals(base + 1, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.deregisterDriver(new TestTmDriver1());
		assertEquals(base + 1, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.deregisterDriver(new TestTmDriver2());
		assertEquals(base + 0, BentenTmDriverManager.getDrivers().length);

		BentenTmDriverManager.deregisterDriver(new TestTmDriver2());
		assertEquals(base + 0, BentenTmDriverManager.getDrivers().length);
	}
}
