/*
 *  benten.cat.tm.engine.omegat - Benten default TM
 *                                (Translation Memory) engine.
 *  Copyright (C) 2009 Information-technology Promotion Agency, Japan.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package benten.cat.tm.engine.omegat.ui.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten デフォルト・エンジンのためのメッセージ。
 *
 * リソースバンドル定義: [BentenTmPluginMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenTmPluginMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenTmPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmPluginMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenTmPluginMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/ui/messages/BentenTmPluginMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTmPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmPluginMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenTmPluginMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/ui/messages/BentenTmPluginMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenTmPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenTmPluginMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenTmPluginMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/engine/omegat/ui/messages/BentenTmPluginMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenTmPluginMessages], key[getDriver_ClassNotFoundException]
     *
     * [Failed to read the default TM engine.] (en)<br>
     * [デフォルトの TM エンジンの読み込みに失敗しました。] (ja)<br>
     *
     * @return key[getDriver_ClassNotFoundException]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetDriverClassNotFoundException() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to read the default TM engine.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getDriver_ClassNotFoundException");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmPluginMessages], key[load_I001]
     *
     * [OmegaT TM Engine Plug-in: Load the TM refreshingly.] (en)<br>
     * [OmegaT TM エンジン・プラグイン: TM をリフレッシュ・ロードします。] (ja)<br>
     *
     * @return key[load_I001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLoadI001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "OmegaT TM Engine Plug-in: Load the TM refreshingly.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("load_I001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmPluginMessages], key[getTmxDir_I001]
     *
     * [Set the directory where TMX is saved: {0}] (en)<br>
     * [TMX を格納するディレクトリーを確定しました。: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTmxDir_I001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmxDirI001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Set the directory where TMX is saved: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmxDir_I001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTmPluginMessages], key[getTmxDir_E001]
     *
     * [TM data directory &quot;{0}&quot; does not exist.] (en)<br>
     * [TM データ・ディレクトリー ''{0}'' は存在しません。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTmxDir_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmxDirE001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TM data directory \"{0}\" does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmxDir_E001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTmPluginMessages], key[getTmxDir_E002]
     *
     * [TM data directory &quot;{0}&quot; is actually not a directory.] (en)<br>
     * [TM データ・ディレクトリー ''{0}'' は、実際にはディレクトリーではありませんでした。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[getTmxDir_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmxDirE002(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TM data directory \"{0}\" is actually not a directory.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmxDir_E002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenTmPluginMessages], key[getTmxDataPlugin_E001]
     *
     * [It was unable to get the extension point.] (en)<br>
     * [拡張ポイントを取得することができませんでした。] (ja)<br>
     *
     * @return key[getTmxDataPlugin_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmxDataPluginE001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmxDataPlugin_E001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenTmPluginMessages], key[getTmxDataPlugin_E002]
     *
     * [It was unable to get the TM data TMX plug-in from the extension point.] (en)<br>
     * [拡張ポイントから TM データ TMX プラグインを取得することができませんでした。] (ja)<br>
     *
     * @return key[getTmxDataPlugin_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmxDataPluginE002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the TM data TMX plug-in from the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmxDataPlugin_E002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
