/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.ui.preference;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;
import benten.ui.UiPlugin;
import benten.ui.fields.AbstractBrowseTextField;

public class CatTmUiPreferencePageTest extends TestCase {

	public void testUpdateTmxCheck() {
		final CatTmUiPreferencePage page = new CatTmUiPreferencePage();
		page.createContents(UiPlugin.getShell());

		page.useTmxLocationCheck.setSelection(true);
		page.updateTmxCheck();
		assertEquals(true, page.tmxLocationText.getEnabled());

		page.useTmxLocationCheck.setSelection(false);
		page.updateTmxCheck();
		assertEquals(false, page.tmxLocationText.getEnabled());
	}

	public void testPerformOk() throws IOException {
		final CatTmUiPreferencePage page = new CatTmUiPreferencePage();
		page.createContents(UiPlugin.getShell());

		assertEquals(true, page.performOk());

		page.useTmxLocationCheck.setSelection(true);

		AbstractBrowseTextField.clearPreviousInput();
		page.tmxLocationText.setText("");
		assertEquals(false, page.performOk());

		AbstractBrowseTextField.clearPreviousInput();
		page.tmxLocationText.setText("x");
		assertEquals(false, page.performOk());

		final File tempFile = File.createTempFile("benten", ".file");
		AbstractBrowseTextField.clearPreviousInput();
		page.tmxLocationText.setText(tempFile.getParent());
		assertEquals(true, page.performOk());
	}
}
