/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.dialogs;

import junit.framework.TestCase;

import org.eclipse.jface.window.Window;

import benten.cat.ui.dialogs.NoteDialog.NoteDialogEntry;
import benten.ui.UiPlugin;

public class NoteDialogTest extends TestCase {

	private NoteDialog dialog;
	private NoteDialogEntry entry;

	private void createNoteDialog(final boolean modify) {
		entry = new NoteDialogEntry("", "");
		entry.modify = modify;
		dialog = new NoteDialog(UiPlugin.getShell(), "", entry);
		dialog.createDialogArea(UiPlugin.getShell());
	}

	public void testModifyText() {
		createNoteDialog(false);
		assertTrue(dialog.getStatus().isOK());
		dialog.modifyText(null);
		assertFalse(dialog.getStatus().isOK());
	}

	public void testOkPressed() {
		createNoteDialog(false);
		dialog.okPressed();
		assertEquals(Window.OK, dialog.getReturnCode());

		createNoteDialog(true);
		dialog.okPressed();
		assertEquals(Window.CANCEL, dialog.getReturnCode());

		createNoteDialog(true);
		entry.from = "変更";
		dialog.okPressed();
		assertEquals(Window.OK, dialog.getReturnCode());
	}
}
