/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ResourceFileTest extends TestCase {

	private IProject createProject() throws CoreException {
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		if (!project.exists()) {
			project.create(null);
		}
		return project;
	}

	public void testAcceptSelection() throws CoreException {
		final IProject project = createProject();
		project.open(null);

		final ResourceFile file = new ResourceFile(project.getFile(new Path("test.file")));
		assertNull(file.listFiles());

		final ResourceFile folder = new ResourceFile(project.getFolder(new Path("test.folder")));
		if (!folder.getResource().exists()) {
			final IFolder f = (IFolder) folder.getResource();
			f.create(true, true, null);
		}
		assertNotNull(folder.listFiles());
	}
}
