/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.model;

import junit.framework.TestCase;

public class HelpTransUnitIdTest extends TestCase {

	public void testToString() {
		try {
			new HelpTransUnitId(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		final HelpTransUnitId target = new HelpTransUnitId("org.eclipse" + "/aaa/bbb.html");
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=1", target.toString());
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=2", target.incrementSeq().toString());
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=3-1", target.incrementSeq().incrementSubSeq(3).toString());
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=3-2", target.incrementSubSeq(3).toString());
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=3-END", target.incrementSubSeq(3).toString());
		assertEquals("benten://org.eclipse/aaa/bbb.html?seq=4", target.incrementSeq().toString());
	}

	public void testHasContinue() {
		try {
			HelpTransUnitId.hasContinue(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals(false, HelpTransUnitId.hasContinue("test"));
		assertEquals(false, HelpTransUnitId.hasContinue("babel://org.eclipse/aaa"));

		assertEquals(false, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=1"));
		assertEquals(false, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=2"));
		assertEquals(true, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=3-1"));
		assertEquals(true, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=3-2"));
		assertEquals(false, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=3-END"));
		assertEquals(false, HelpTransUnitId.hasContinue("benten://org.eclipse/aaa/bbb.html?seq=4"));
	}
}
