/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.text;

import junit.framework.TestCase;

public class StringsTest extends TestCase {

	public void testRemoveRedundantWhitespace() {
		assertEquals(null, Strings.removeRedundantWhitespace(null));
		assertEquals("", Strings.removeRedundantWhitespace(""));
		assertEquals("text", Strings.removeRedundantWhitespace(" text "));
		assertEquals("test", Strings.removeRedundantWhitespace(" test \n"));
		assertEquals("test text", Strings.removeRedundantWhitespace(" test text"));
		assertEquals("test text", Strings.removeRedundantWhitespace(" test  text"));
		assertEquals("test text", Strings.removeRedundantWhitespace(" test \r\n \n text"));
		assertEquals("test text", Strings.removeRedundantWhitespace(" test \t text"));

		// &nbsp; ホワイトスペースとして扱わない
		assertEquals("test &nbsp;text", Strings.removeRedundantWhitespace(" test &nbsp;text"));
	}

	public void testSplitByWhitespace() {
		assertEquals(0, Strings.splitByWhitespace(null).length);
		assertEquals(1, Strings.splitByWhitespace("").length);
		assertEquals(1, Strings.splitByWhitespace(" ").length);
		assertEquals(1, Strings.splitByWhitespace("  ").length);
		assertEquals(1, Strings.splitByWhitespace("\n").length);
		assertEquals(1, Strings.splitByWhitespace("\r\n\t").length);
		assertEquals(1, Strings.splitByWhitespace("&nbsp;").length);
		assertEquals(1, Strings.splitByWhitespace(" &nbsp; ").length);
		assertEquals(1, Strings.splitByWhitespace("\r\n\t&nbsp; ").length);
		assertEquals(1, Strings.splitByWhitespace("text").length);
		assertEquals(1, Strings.splitByWhitespace(" text ").length);
		assertEquals(2, Strings.splitByWhitespace("test text").length);
		assertEquals(2, Strings.splitByWhitespace("test\r\n\t&nbsp;text").length);
		assertEquals(3, Strings.splitByWhitespace("test text abc").length);

		// &nbsp; ホワイトスペースとして扱わない
		assertEquals(2, Strings.splitByWhitespace("\r\n\t&nbsp; text").length);
	}
}
