/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/**
 * ini ファイル。
 *
 * @author KASHIHARA Shinji
 */
public class IniFile {

	/** INI ファイルの内容。 */
	private final List<String> list = new LinkedList<String>();

	/**
	 * コンストラクター。
	 */
	protected IniFile() {
	}

	/**
	 * コンストラクター。
	 * @param obj クラスローダー取得オブジェクト
	 * @param path パス
	 */
	public IniFile(final Object obj, final String path) {
		final InputStream is = obj.getClass().getClassLoader().getResourceAsStream(path);
		try {
			final String s = Files.toString(is, "UTF-8"); //$NON-NLS-1$
			createList(s);
		} catch (final IOException e) {
			throw new IllegalArgumentException(e);
		} finally {
			Files.closeQuietly(is);
		}
	}

	/**
	 * リストの作成。
	 * @param s INI ファイル内容文字列
	 * @return リスト
	 */
	protected List<String> createList(final String s) {
		// 改行区切りでリストを作成
		for (final String line : s.split("\\s*(\r\n|\n)\\s*")) { //$NON-NLS-1$

			// 行頭が # の場合は無視
			if (!line.startsWith("#") && line.length() > 0) { //$NON-NLS-1$
				list.add(line);
			}
		}
		return list;
	}

	/**
	 * ファイルの行をリストで取得。
	 * @return 行リスト
	 */
	public List<String> getList() {
		return list;
	}

	/**
	 * ファイルの行をリストで取得。
	 * @param obj クラスローダー取得オブジェクト
	 * @param path パス
	 * @return 行リスト
	 */
	public static List<String> asList(final Object obj, final String path) {
		return new IniFile(obj, path).getList();
	}
}
