/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.cat.messages.BentenApplyFuzzyMatchMessages;
import benten.twa.cat.status.BentenApplyFuzzyMatchStatus;
import benten.twa.ui.dialogs.AbstractTmWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFolderTextField;
import benten.ui.preference.BentenPreference;
import benten.ui.preference.BentenPreference.Preference;
import benten.ui.views.UiToolkit;

/**
 * 類似訳の適用
 *
 * <pre>
 * このウィザードは、TMX の類似訳を XLIFF に適用します。
 *   1.  翻訳単位と類似する TMX を探し、翻訳単位の代替翻訳に適用します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 類似訳適用機能」に対応します。
 *
 * @author IGA Tosiki
 */
public class ApplyFuzzyMatchDialog extends AbstractTmWorkflowDialog {

	/**
	 * 類似訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyFuzzyMatchMessages fMsg = new BentenApplyFuzzyMatchMessages();

	/**
	 * Benten が提供する基本的なウィジェットを生成する UI ツールキットのインスタンス。
	 */
	protected final UiToolkit toolkit = new UiToolkit();

	/** コントロール・コンテナー */
	private final ApplyFuzzyMatchControls controls = new ApplyFuzzyMatchControls();

	/** コントロール・コンテナー・クラス */
	public static class ApplyFuzzyMatchControls {

		/** XLIFF ディレクトリー・テキスト */
		public ResourceFolderTextField xliffDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public ApplyFuzzyMatchDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.xliffDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelXliffDir());
		controls.xliffDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.xliffDirText.setText(getSelectionResource().getProject().getName()
					+ "/" + BentenTwaConstants.DEFAULT_XLIFF_DIR); //$NON-NLS-1$
		}
		createTmPreferenceArea(composite);
	}

	@Override
	public IStatus getResultStatus() {
		final BentenApplyFuzzyMatchStatus status = new BentenApplyFuzzyMatchStatus();
		status.setXliffDir(controls.xliffDirText.getFile());
		status.setProject(controls.xliffDirText.getResource());

		// benten.cat.tm.ui.CatTmUiPlugin#fuzzyMatch のプリファランス処理内容と関連性があります。
		final IPreferenceStore store = BentenPreference.getStore();
		status.setIgnoreWhitespaceTmReference(store.getBoolean(Preference.IGNORE_WHITESPACE_TM_REFERENCE.name()));
		status.setIgnoreMnemonicKeyTmReference(store.getBoolean(Preference.IGNORE_MNEMONIC_KEY_TM_REFERENCE.name()));
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.xliffDirText);
		return UiStatus.OK_STATUS;
	}
}
