/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.handler;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

import benten.twa.cat.core.BentenApplyExistentTranslationBatchProcess;
import benten.twa.cat.core.BentenApplyExistentTranslationProcessImpl;
import benten.twa.cat.core.valueobject.BentenApplyExistentTranslationProcessInput;
import benten.twa.cat.dialogs.ApplyExistentTranslationDialog;
import benten.twa.cat.messages.BentenApplyExistentTranslationMessages;
import benten.twa.cat.status.BentenApplyExistentTranslationStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.ui.preference.BentenProjectProperty;

/**
 * 過去訳の適用
 *
 * <pre>
 * 過去訳を XLIFF に適用します。
 *  1.  翻訳単位の id をもとに過去訳を適用します。
 *  2.  翻訳後の XLIFF にある過去訳を、XLIFF に適用します。
 *  3.  この処理では TMX を利用しません。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 過去訳適用機能」に対応します。
 * 
 * @author IGA Tosiki
 */
public class ApplyExistentTranslationHandler extends AbstractWorkflowHandler {
	/**
	 * 過去訳適用機能のためのメッセージ。
	 */
	protected static final BentenApplyExistentTranslationMessages fMsg = new BentenApplyExistentTranslationMessages();

	@Override
	protected StatusDialog createDialog(final Shell shell, final IStructuredSelection selection) {
		setJobMessage(fMsg.getJobName());
		return new ApplyExistentTranslationDialog(shell, selection);
	}

	@Override
	protected void processFile(final IStatus iStatus) throws IOException, SAXException {
		final BentenApplyExistentTranslationStatus status = (BentenApplyExistentTranslationStatus) iStatus;

		final BentenApplyExistentTranslationProcessInput input = new BentenApplyExistentTranslationProcessInput();
		input.setSourcedir(status.getFromDir().getAbsolutePath());
		input.setTargetdir(status.getToDir().getAbsolutePath());
		input.setTmpdir(status.getTmpDir().getAbsolutePath());

		// ホワイトスペースを無視して TMX を検索するかどうかのフラグ。
		input.setIgnorewhitespacetmreference(status.getIgnoreWhitespaceTmReference());

		// ニーモニック・キーを無視して TMX を検索するかどうかのフラグ。
		input.setIgnoremnemonickeytmreference(status.getIgnoreMnemonicKeyTmReference());

		// プロジェクトの設定をもちいて翻訳を実施。
		final IPreferenceStore projectStore = BentenProjectProperty.getStore(status.getProject());
		input
				.setTranssourcelang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_SOURCE_LANG
						.name()));
		input
				.setTranstargetlang(projectStore.getString(BentenProjectProperty.ProjectProperty.TRANS_TARGET_LANG
						.name()));

		new BentenApplyExistentTranslationBatchProcess().validateInput(input);
		final BentenApplyExistentTranslationProcessImpl process = new BentenApplyExistentTranslationProcessImpl() {
			@Override
			protected void beginTask(final int totalWork) {
				monitor.beginTask(null, totalWork);
			}

			@Override
			public boolean progress(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				monitor.worked(1);
				Thread.yield();
				return monitor.isCanceled();
			}

			@Override
			public boolean progressInner(final String argProgressMessage) {
				monitor.subTask(argProgressMessage);
				Thread.yield();
				return monitor.isCanceled();
			}
		};
		process.execute(input);
		resultInfo = process.getResultInfo();
	}
}
