/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.engine.html;

import java.io.IOException;

import benten.twa.filter.engine.html.BentenTwaFilterHtmlEngine;

import junit.framework.TestCase;

public class BentenExportHtmlProcessImplTest extends TestCase {

	private int countContentType(final String html) {
		return html.split("text/html;\\s+charset=").length - 1;
	}

	public void testResolveContentType() throws IOException {
		// Content-Type 指定なし - 追加されること
		String html = "<html lang=\"en-us\" xml:lang=\"en-us\" xmlns=\"http://www.w3.org/1999/xhtml\"><head>"
				+ "<meta name=\"copyright\" content=\"Copyright (c) 2000, 2008 IBM\" />";
		String result = new String(new BentenTwaFilterHtmlEngine().resolveContentType(html.getBytes()));
		assertEquals(0, countContentType(html));
		assertEquals(1, countContentType(result));

		// Content-Type 指定あり 1 - 追加されないこと (2 個にならないこと)
		html = "<html lang=\"en-us\" xml:lang=\"en-us\" xmlns=\"http://www.w3.org/1999/xhtml\"><head>"
				+ "<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\" />"
				+ "<meta name=\"copyright\" content=\"Copyright (c) 2000, 2008 IBM\" />";
		result = new String(new BentenTwaFilterHtmlEngine().resolveContentType(html.getBytes()));
		assertEquals(1, countContentType(html));
		assertEquals(1, countContentType(result));

		// Content-Type 指定あり 2 - 追加されないこと (2 個にならないこと)
		html = "<html lang=\"en-us\" xml:lang=\"en-us\" xmlns=\"http://www.w3.org/1999/xhtml\"><head>"
				+ "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />"
				+ "<meta name=\"copyright\" content=\"Copyright (c) 2000, 2008 IBM\" />";
		result = new String(new BentenTwaFilterHtmlEngine().resolveContentType(html.getBytes()));
		assertEquals(1, countContentType(html));
		assertEquals(1, countContentType(result));
	}
}
