/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.handler;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import junit.framework.TestCase;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.SAXException;

import benten.core.io.Files;
import benten.twa.filter.status.BentenConvertToXliffStatus;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.ui.preference.BentenProjectProperty;
import benten.ui.preference.BentenProjectProperty.ProjectProperty;

public class ConvertToXliffHandlerTest extends TestCase {

	private final AbstractWorkflowHandler target = new ConvertToXliffHandler();
	private String dataPath;

	private void setDataPath(final String caseId) throws IOException {
		final String dataDir = "/src/" + getClass().getName().replace('.', '/') + "Data/" + caseId + "/";
		final URL dataUrl = getClass().getClassLoader().getResource(dataDir);
		dataPath = FileLocator.resolve(dataUrl).getPath();
	}

	private String read(final String path) throws IOException {
		final File file = new File(dataPath + path);
		return Files.readFileToString(file);
	}

	//-------------------------------------------------------------------------

	public void testRun() throws IOException, SAXException {
		try {
			target.run(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
	}

	public void testRun0001() throws IOException, SAXException, CoreException {
		setDataPath("0001");

		final BentenConvertToXliffStatus status = new BentenConvertToXliffStatus();
		status.setFromDir(new File(dataPath + "in"));
		status.setToDir(new File(dataPath + "out"));
		status.setTransTargetId("org.eclipse.mylyn.help");

		// ワークスペースにテスト用のプロジェクトを作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");

		// 循環参照を回避するために、benten.twa.ui への依存をコメントアウトし、直接言語指定します。
		//	new NewProjectCreationWizard().createProject(project);
		final IPreferenceStore projectStore = BentenProjectProperty.getStore(project);
		projectStore.setValue(ProjectProperty.TRANS_SOURCE_LANG.name(), "en-US");
		projectStore.setValue(ProjectProperty.TRANS_TARGET_LANG.name(), "ja-JP");

		status.setProject(project);

		target.run(status);

		assertEquals(read("out/test.html.xlf"), read("out/expected.html.xlf"));
	}
}
