/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.model;

import junit.framework.TestCase;

public class HtmlBlockTest extends TestCase {

	public void testGetInlinetext() {
		try {
			new HtmlBlock(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
		assertEquals("", new HtmlBlock("").getInlineText());
		assertEquals("", new HtmlBlock("text").getInlineText());

		assertEquals("text", new HtmlBlock("<body>text</body>").getInlineText());

		assertEquals("text", new HtmlBlock("<body><a>text</a></body>").getInlineText());

		// title、alt 属性あり
		assertEquals("<a title=\"test\">text</a>", new HtmlBlock("<body><a title=\"test\">text</a></body>")
				.getInlineText());
		assertEquals("<a alt=\"test\">text</a>", new HtmlBlock("<body><a alt=\"test\">text</a></body>").getInlineText());
		assertEquals("<a href=\"test\">text</a>", new HtmlBlock("<body><a href=\"test\">text</a></body>")
				.getInlineText());
		assertEquals("text", new HtmlBlock("<body><a name=\"test\">text</a></body>").getInlineText());

		// HTML コメント（インライン内で完結）
		assertEquals("text<!-- test -->", new HtmlBlock("<body>text<!-- test --></body>").getInlineText());

		// HTML コメント（ブロック・タグまたがり）
		assertEquals("test", new HtmlBlock("<div>test<!--</div>").getInlineText());
		assertEquals("test", new HtmlBlock("<div>-->test</div>").getInlineText());

		// 片側のタグのみ存在
		assertEquals("<a>text", new HtmlBlock("<body><a>text</body>").getInlineText());

		// 空タグ
		assertEquals("text", new HtmlBlock("<body><a></a>text</body>").getInlineText());

		// 1 文字
		assertEquals("", new HtmlBlock("<body>t</body>").getInlineText());
	}
}
