/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.core;

import java.util.LinkedList;

import junit.framework.TestCase;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

public class BentenTmxTuUtilTest extends TestCase {

	private BlancoTmxTuv createBlancoTmxTuv(String seg) {
		final BlancoTmxTuv tmxTuv = new BlancoTmxTuv();
		tmxTuv.setSeg(seg);
		return tmxTuv;
	}

	private BlancoTmxTu createBlancoTmxTu(String... segs) {
		final BlancoTmxTu tmxTu = new BlancoTmxTu();
		final LinkedList<BlancoTmxTuv> tmxTuvList = new LinkedList<BlancoTmxTuv>();
		for (final String seg : segs) {
			tmxTuvList.add(createBlancoTmxTuv(seg));
		}
		tmxTu.setTuvList(tmxTuvList);
		return tmxTu;
	}

	//-------------------------------------------------------------------------

	public void testRemoveDuplicatedTuv() {
		try {
			BentenTmxTuUtil.removeDuplicatedTuv(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}

		// tu が 1 個 - 何もしない
		LinkedList<BlancoTmxTu> tmxTuList = new LinkedList<BlancoTmxTu>();
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		assertEquals(1, tmxTuList.size());
		BentenTmxTuUtil.removeDuplicatedTuv(tmxTuList);
		assertEquals(1, tmxTuList.size());

		// seg が同じ (tu 2 個) - 重複除去
		tmxTuList = new LinkedList<BlancoTmxTu>();
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		assertEquals(2, tmxTuList.size());
		BentenTmxTuUtil.removeDuplicatedTuv(tmxTuList);
		assertEquals(1, tmxTuList.size());

		// seg が同じ (tu 3 個) - 重複除去
		tmxTuList = new LinkedList<BlancoTmxTu>();
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		assertEquals(3, tmxTuList.size());
		BentenTmxTuUtil.removeDuplicatedTuv(tmxTuList);
		assertEquals(1, tmxTuList.size());

		// seg が異なる場合 - 何もしない
		tmxTuList = new LinkedList<BlancoTmxTu>();
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		tmxTuList.add(createBlancoTmxTu("seg1", "seg3"));
		assertEquals(2, tmxTuList.size());
		BentenTmxTuUtil.removeDuplicatedTuv(tmxTuList);
		assertEquals(2, tmxTuList.size());

		// seg が同じだが、tuv が 2 個でない - 何もしない
		tmxTuList = new LinkedList<BlancoTmxTu>();
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2", "seg3"));
		tmxTuList.add(createBlancoTmxTu("seg1", "seg2"));
		assertEquals(2, tmxTuList.size());
		BentenTmxTuUtil.removeDuplicatedTuv(tmxTuList);
		assertEquals(2, tmxTuList.size());
	}
}
