package benten.twa.tmx.dialogs;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.tmx.dialogs.MergeTmxDialog.MergeTmxControls;
import benten.twa.ui.wizards.NewProjectCreationWizard;
import benten.ui.UiStatusException;
import benten.ui.fields.AbstractBrowseTextField;
import benten.ui.fields.TextField;

public class MergeTmxDialogTest extends TestCase {

	private final MergeTmxDialog target = new MergeTmxDialog(null, new StructuredSelection());

	private String getValidateMessage() {
		try {
			target.validate();
			return null;
		} catch (final UiStatusException e) {
			return e.getMessage();
		}
	}

	private boolean validate(final TextField field, final String value) {
		AbstractBrowseTextField.clearPreviousInput();
		field.setText(value);
		final String message = getValidateMessage();
		if (message == null) {
			return true;
		}
		return !message.contains(field.getLabelText());
	}

	private boolean validateFromTo(final TextField field1, final TextField field2, final String value1,
			final String value2) {
		AbstractBrowseTextField.clearPreviousInput();
		field1.setText(value1);
		field2.setText(value2);
		final String message = getValidateMessage();
		if (message == null) {
			return true;
		}
		return !(message.contains(field1.getLabelText()) && message.contains(field2.getLabelText()));
	}

	public void testValidate() throws Exception {

		// テスト対象のダイアログからコントロール・コンテナーの取得
		target.createControls(new Composite(new Shell(), SWT.NONE));
		final Field field = target.getClass().getDeclaredField("controls");
		field.setAccessible(true);
		final MergeTmxControls controls = (MergeTmxControls) field.get(target);

		// ワークスペースにテスト用のプロジェクトを作成
		final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		final IProject project = root.getProject("test.project");
		new NewProjectCreationWizard().createProject(project);
		final IFile file = project.getFile(new Path("test.file"));
		if (!file.exists()) {
			file.create(new ByteArrayInputStream("".getBytes()), true, null);
		}
		final IFile inTmx = project.getFile(new Path("in.tmx"));
		if (!inTmx.exists()) {
			inTmx.create(new ByteArrayInputStream("".getBytes()), true, null);
		}
		final IFile outTmx = project.getFile(new Path("out.tmx"));
		if (!outTmx.exists()) {
			outTmx.create(new ByteArrayInputStream("".getBytes()), true, null);
		}

		assertFalse(validate(controls.targetFileText, null));
		assertFalse(validate(controls.targetFileText, ""));
		assertFalse(validate(controls.targetFileText, ".先頭ピリオド"));
		assertFalse(validate(controls.targetFileText, "末尾ピリオド."));
		assertFalse(validate(controls.targetFileText, "存在しないリソース"));
		assertFalse(validate(controls.targetFileText, "test.project"));
		assertFalse(validate(controls.targetFileText, "test.project/test.file"));
		assertTrue(validate(controls.targetFileText, "test.project/in.tmx"));

		assertFalse(validate(controls.toFileText, null));
		assertFalse(validate(controls.toFileText, ""));
		assertFalse(validate(controls.toFileText, ".先頭ピリオド"));
		assertFalse(validate(controls.toFileText, "末尾ピリオド."));
		assertFalse(validate(controls.toFileText, "存在しないリソース"));
		assertFalse(validate(controls.toFileText, "test.project"));
		assertFalse(validate(controls.toFileText, "test.project/test.file"));
		assertFalse(validate(controls.toFileText, "test.project/in.tmx"));
		assertTrue(validate(controls.toFileText, "test.project/out.tmx"));

		assertNull(getValidateMessage());

		assertFalse(validateFromTo(controls.targetFileText, controls.toFileText, "test.project/in.tmx",
				"test.project/in.tmx"));
	}
}
