/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.tmx.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenMergeTmxStatus extends UiStatus {
    /**
     * フィールド: [targetFile]。
     */
    private File fTargetFile;

    /**
     * フィールド: [toFile]。
     */
    private File fToFile;

    /**
     * フィールド [targetFile] の値を設定します。
     *
     * @param argTargetFile フィールド[targetFile]に設定する値。
     */
    public void setTargetFile(final File argTargetFile) {
        fTargetFile = argTargetFile;
    }

    /**
     * フィールド [targetFile] の値を取得します。
     *
     * @return フィールド[targetFile]から取得した値。
     */
    public File getTargetFile() {
        return fTargetFile;
    }

    /**
     * フィールド [toFile] の値を設定します。
     *
     * @param argToFile フィールド[toFile]に設定する値。
     */
    public void setToFile(final File argToFile) {
        fToFile = argToFile;
    }

    /**
     * フィールド [toFile] の値を取得します。
     *
     * @return フィールド[toFile]から取得した値。
     */
    public File getToFile() {
        return fToFile;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.tmx.status.BentenMergeTmxStatus[");
        buf.append("targetFile=" + fTargetFile);
        buf.append(",toFile=" + fToFile);
        buf.append("]");
        return buf.toString();
    }
}
