/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.handler;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import junit.framework.TestCase;

import org.eclipse.core.runtime.FileLocator;
import org.xml.sax.SAXException;

import benten.core.io.Files;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.twa.xliff.status.BentenExtractXliffFragmentStatus;

public class ExtractXliffFragmentHandlerTest extends TestCase {

	private final AbstractWorkflowHandler target = new ExtractXliffFragmentHandler();
	private String dataPath;

	private void setDataPath(final String caseId) throws IOException {
		final String dataDir = "/src/" + getClass().getName().replace('.', '/') + "Data/" + caseId + "/";
		final URL dataUrl = getClass().getClassLoader().getResource(dataDir);
		dataPath = FileLocator.resolve(dataUrl).getPath();
	}

	private String read(final String path) throws IOException {
		final File file = new File(dataPath + path);
		return Files.readFileToString(file);
	}

	//-------------------------------------------------------------------------

	public void testRun() throws IOException, SAXException {
		try {
			target.run(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
	}

	public void testRun0001() throws IOException, SAXException {
		setDataPath("0001");

		final BentenExtractXliffFragmentStatus status = new BentenExtractXliffFragmentStatus();
		status.setFromXliffFile(new File(dataPath + "in/test.html.xlf"));
		status.setToDir(new File(dataPath + "out"));
		status.setIncludeDate(false);
		status.setSizeLimit(10);
		status.setState("x-reviewed");

		target.run(status);

		assertEquals(read("out/test.html-1.xlf"), read("out/expected.html-1.xlf"));
		assertEquals(read("out/test.html-2.xlf"), read("out/expected.html-2.xlf"));
	}
}
