/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.handler;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import junit.framework.TestCase;

import org.eclipse.core.runtime.FileLocator;
import org.xml.sax.SAXException;

import benten.core.io.Files;
import benten.twa.ui.jobs.AbstractWorkflowHandler;
import benten.twa.xliff.status.BentenMergeXliffStatus;

public class MergeXliffHandlerTest extends TestCase {

	private final AbstractWorkflowHandler target = new MergeXliffHandler();
	private String dataPath;

	private void setDataPath(final String caseId) throws IOException {
		final String dataDir = "/src/" + getClass().getName().replace('.', '/') + "Data/" + caseId + "/";
		final URL dataUrl = getClass().getClassLoader().getResource(dataDir);
		dataPath = FileLocator.resolve(dataUrl).getPath();
	}

	private String read(final String path) throws IOException {
		final File file = new File(dataPath + path);
		return Files.readFileToString(file);
	}

	//-------------------------------------------------------------------------

	public void testRun() throws IOException, SAXException {
		try {
			target.run(null);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(true);
		}
	}

	public void testRun0001() throws IOException, SAXException {
		setDataPath("0001");

		final BentenMergeXliffStatus status = new BentenMergeXliffStatus();
		status.setFromDir(new File(dataPath + "in"));
		status.setToDir(new File(dataPath + "out"));
		Files.copyFile(new File(dataPath + "test.html.xlf"), new File(dataPath + "out/test.html.xlf"));

		target.run(status);

		assertEquals(read("out/test.html.xlf"), read("expected.html.xlf"));
	}
}
