/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.xliff.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenExtractXliffFragmentStatus extends UiStatus {
    /**
     * フィールド: [fromXliffFile]。
     */
    private File fFromXliffFile;

    /**
     * フィールド: [toDir]。
     */
    private File fToDir;

    /**
     * フィールド: [state]。
     */
    private String fState;

    /**
     * フィールド: [sizeLimit]。
     */
    private int fSizeLimit;

    /**
     * フィールド: [includeDate]。
     */
    private boolean fIncludeDate;

    /**
     * フィールド [fromXliffFile] の値を設定します。
     *
     * @param argFromXliffFile フィールド[fromXliffFile]に設定する値。
     */
    public void setFromXliffFile(final File argFromXliffFile) {
        fFromXliffFile = argFromXliffFile;
    }

    /**
     * フィールド [fromXliffFile] の値を取得します。
     *
     * @return フィールド[fromXliffFile]から取得した値。
     */
    public File getFromXliffFile() {
        return fFromXliffFile;
    }

    /**
     * フィールド [toDir] の値を設定します。
     *
     * @param argToDir フィールド[toDir]に設定する値。
     */
    public void setToDir(final File argToDir) {
        fToDir = argToDir;
    }

    /**
     * フィールド [toDir] の値を取得します。
     *
     * @return フィールド[toDir]から取得した値。
     */
    public File getToDir() {
        return fToDir;
    }

    /**
     * フィールド [state] の値を設定します。
     *
     * @param argState フィールド[state]に設定する値。
     */
    public void setState(final String argState) {
        fState = argState;
    }

    /**
     * フィールド [state] の値を取得します。
     *
     * @return フィールド[state]から取得した値。
     */
    public String getState() {
        return fState;
    }

    /**
     * フィールド [sizeLimit] の値を設定します。
     *
     * @param argSizeLimit フィールド[sizeLimit]に設定する値。
     */
    public void setSizeLimit(final int argSizeLimit) {
        fSizeLimit = argSizeLimit;
    }

    /**
     * フィールド [sizeLimit] の値を取得します。
     *
     * @return フィールド[sizeLimit]から取得した値。
     */
    public int getSizeLimit() {
        return fSizeLimit;
    }

    /**
     * フィールド [includeDate] の値を設定します。
     *
     * @param argIncludeDate フィールド[includeDate]に設定する値。
     */
    public void setIncludeDate(final boolean argIncludeDate) {
        fIncludeDate = argIncludeDate;
    }

    /**
     * フィールド [includeDate] の値を取得します。
     *
     * @return フィールド[includeDate]から取得した値。
     */
    public boolean getIncludeDate() {
        return fIncludeDate;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.xliff.status.BentenExtractXliffFragmentStatus[");
        buf.append("fromXliffFile=" + fFromXliffFile);
        buf.append(",toDir=" + fToDir);
        buf.append(",state=" + fState);
        buf.append(",sizeLimit=" + fSizeLimit);
        buf.append(",includeDate=" + fIncludeDate);
        buf.append("]");
        return buf.toString();
    }
}
