/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;
import benten.twa.xliff.dialogs.MergeXliffDialog;
import benten.twa.xliff.messages.BentenMergeXliffMessages;

/**
 * XLIFF フラグメントのマージ
 *
 * <pre>
 * XLIFF フラグメントを、もとになった XLIFF にマージします。
 *   1.  翻訳単位の id をもとに、XLIFF をマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント・マージ機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MergeXliffWizardPage2 extends AbstractWorkflowDialogWizardPage {
	/**
	 * XLIFF マージ機能のためのメッセージ。
	 */
	protected static final BentenMergeXliffMessages fMsg = new BentenMergeXliffMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected MergeXliffWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new MergeXliffDialog(parent.getShell(), selection);
	}
}
