/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

import benten.ui.UiPlugin;

public class FileTextFieldTest extends TestCase {

	public void testGetDefaultPath() throws IOException {
		final FileTextField field = new FileTextField(UiPlugin.getShell(), String.valueOf(System.nanoTime()));
		assertEquals(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), field.getDefaultPath());

		final File file = File.createTempFile("benten", "test.file");
		file.deleteOnExit();
		final String path = file.getCanonicalPath();
		field.setText(path);
		assertEquals(new Path(path).toOSString(), field.getDefaultPath());
	}
}
