/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.ui.preference.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳プロジェクトのプロパティー・ページのためのメッセージ。
 *
 * リソースバンドル定義: [BentenProjectPropertyPageMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenProjectPropertyPageMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenProjectPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenProjectPropertyPageMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenProjectPropertyPageMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenProjectPropertyPageMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenProjectPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenProjectPropertyPageMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenProjectPropertyPageMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenProjectPropertyPageMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenProjectPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenProjectPropertyPageMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenProjectPropertyPageMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/preference/messages/BentenProjectPropertyPageMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenProjectPropertyPageMessages], key[Label.GroupTransLang]
     *
     * [Translation Language Settings] (en)<br>
     * [翻訳言語の設定] (ja)<br>
     *
     * @return key[Label.GroupTransLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelGroupTransLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Language Settings";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.GroupTransLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenProjectPropertyPageMessages], key[Label.SourceLang]
     *
     * [Translation Source Language:] (en)<br>
     * [翻訳元の言語:] (ja)<br>
     *
     * @return key[Label.SourceLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSourceLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Source Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.SourceLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[BentenProjectPropertyPageMessages], key[Label.TargetLang]
     *
     * [Translation Target Language:] (en)<br>
     * [翻訳先の言語:] (ja)<br>
     *
     * @return key[Label.TargetLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTargetLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Target Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.TargetLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
