/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;

/**
 * 非同期選択変更アダプター。
 *
 * <UL>
 * <LI>選択が変更されたときの処理を非同期で行うアダプターの基底クラスです。
 * <LI>非同期処理により、UI レスポンスを向上が期待できます。
 * ただし、場合によって非同期による UI 更新の遅延に注意する必要があります。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
abstract public class AsyncSelectionChangeAdapter implements ISelectionChangedListener {

	/**
	 * {@inheritDoc}
	 */
	final public void selectionChanged(final SelectionChangedEvent event) {
		Display.getCurrent().asyncExec(new Runnable() {
			public void run() {
				final IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				selectionChanged(selection);
			}
		});
	}

	/**
	 * 選択が変更されたときに非同期で呼び出されるテンプレート・メソッド。
	 * @param selection 選択
	 */
	abstract public void selectionChanged(final IStructuredSelection selection);
}
