/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* task.c $Revision: 1.1 $
 *
 * Ԥ
 *
 *
 * ؿꥹ
 *
 *	init_task ()		--- ǡν
 *	init_task1 ()		--- ƥȵư
 *	cre_tsk ()		--- 
 *	new_task ()		--- ǤդΥ ID ǤΥ
 *
 * ѿ
 *	run_task		--- Υ
 *
 * ؿ (static)
 *
 *	make_task_context ()	--- 롣
 *
 * ѿ (static)
 *
 *	task
 *	task_buffer
 *	ready_task
 *	dispatch_flag		ǥѥå뤫ɤΥե饰
 */

/*
 * $Log: task.c,v $
 * Revision 1.1  2011/12/27 17:13:36  liu1
 * Initial Version.
 *
 * Revision 1.13  1995-10-01 12:58:37  night
 * ؿ wup_tsk()  wakeup 륿ξΥɥ쥹Υå
 * á
 *
 * Revision 1.12  1995/09/21  15:51:12  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.11  1995/09/17  16:57:07  night
 * task_switch() ƤӽФνѹ
 * ȥ̤ͥ⤤ʤ祿åԤ
 * ʤä̤ͥ㤤ؤڤ꤫褦ѹ
 *
 * Revision 1.10  1995/09/14  04:32:05  night
 * ֤ɽؿ (print_list()) ѹ
 * ɽƤ˥٥ɲá
 *
 * Revision 1.9  1995/08/26  02:15:23  night
 * RCS  Log ޥɲá
 *
 *
 */

#include "itron.h"
#include "errno.h"
#include "task.h"
#include "misc.h"
#include "func.h"
#include "interrupt.h"

/***************************************************************************
 *	Ѥѿ
 *
 *
 */
T_TCB		*run_task;			/* ߡΥ */

static T_TCB	*task;
static T_TCB	task_buffer[MAX_TSKID - MIN_TSKID + 1];
static T_TCB	*ready_task[MAX_PRIORITY - MIN_PRIORITY + 1];
static BOOL	dispatch_flag = TRUE;

static ER 	make_task_stack (T_TCB *task, W size, VP *sp);
static void	print_list (void);


void
print_task_list (void)
{
  dis_int ();
  print_list ();
  ena_int ();
}

static void
print_list (void)
{
  int	i;

  for (i = 1; i < MAX_TSKID; i++)
    {
      switch (task[i].tskstat)
	{
	case TTS_RUN:
	  printf ("%d (%d)  <RUN>           0x%x\n", i, task[i].tsklevel, task[i].context.eip);
	  break;
	case TTS_RDY:
	  printf ("%d (%d)  <RDY>           0x%x\n", i, task[i].tsklevel, task[i].context.eip);
	  break;
	case TTS_WAI:
	  printf ("%d (%d)  <WAIT>          0x%x\n", i, task[i].tsklevel, task[i].context.eip);
	  break;
	case TTS_SUS:
	  printf ("%d (%d)  <SUSPEND>       0x%x\n", i, task[i].tsklevel, task[i].context.eip);
	  break;
	case TTS_WAS:
	  printf ("%d (%d)  <WAIT-SUSPEND>  0x%x\n", i, task[i].tsklevel, task[i].context.eip);
	  break;
	}
    }
}

W
list_counter (T_TCB *list)
{
  W		i;
  T_TCB	*p, *q;

  q = NULL;
  for (i = 0, p = list;
       (q != list) && (list != NULL);
       p = q, i++)
    {	
      q = p->next;
    }
  return (i);
}


#ifdef TASK_DEBUG_PRORAM
main ()
{
  T_TCB a, b, c;
  T_TCB *list = NULL;

  a.tsklevel = 0;
  b.tsklevel = 1;
  c.tsklevel = 2;
  print_list (list);
  list = ins_tcb_list (list, &a);
  print_list (list);
  list = ins_tcb_list (list, &b);
  print_list (list);
  list = ins_tcb_list (list, &c);
  print_list (list);
}  
#endif /* TASK_DEBUG_PROGRAM */



/* init_task --- ν
 *
 * TCB ơ֥Ƥ롣ơȥ򥿥ֹ -1 
 * ΥȤ롣
 *
 */
void
init_task (void)
{
  W	i;

  /* TCB ơ֥κ GDT ؤϿ
   */
  for (i = 0; i < NTASK; i++)
    {
      task_buffer[i].tskstat = TTS_NON;
    }
/*  bzero (kernel_tss, sizeof (TASK_STATE_SEG_T) * MAX_TASK); */
  task = &task_buffer[-1];
}


/* init_task1 --- 1 ξ롣
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	 1 ξ롣
 *		 1 ξϡproc_table[0] ˼롣
 *		ʲξ롣
 *		  cr3		ߤ cr3 Ƥ롣
 *		  state		ץ֤ TTS_RUN (Υϼ¹)
 *				ͥ٤ 0 
 *				ƥΥ id  0 ꡣ
 *		쥸ͤ task[1]  context Υɥ쥹
 *		ꡣ
 *		쥸ͤϡˤϡʤˤƶʤ
 *		ڤ괹ȤߤΥ쥸λؤTSS
 *		ΰ˺ߤΥ򤹤롣
 *		Τᡢ˥쥸ͤꤷƤɬפ롣
 */
void
init_task1 (void)
{
  /* 1ξ롣*/
  task[KERNEL_TASK].tskstat = TTS_RUN;		/* ֡Ծ֤˥å */
  task[KERNEL_TASK].tsklevel = MAX_PRIORITY;	/* ٥ϡ31()˥å */
  task[KERNEL_TASK].tskid = KERNEL_TASK;	/*  ID ϡKERNEL_TASK(1)˥å */

#ifdef I386
  /*  1 ΥƥȾ			*/
  /* ξϡ˥1ȥˤʤä	*/
  /* Ѥ 							*/
  task[KERNEL_TASK].context.cr3 = (UW)PAGE_DIR_ADDR;
  task[KERNEL_TASK].context.cs  = KERNEL_ESEG;
  task[KERNEL_TASK].context.ds  = KERNEL_DSEG;
  task[KERNEL_TASK].context.es  = KERNEL_ESEG;
  task[KERNEL_TASK].context.fs  = KERNEL_ESEG;
  task[KERNEL_TASK].context.gs  = KERNEL_ESEG;
  task[KERNEL_TASK].context.ss  = KERNEL_DSEG;
  task[KERNEL_TASK].context.ss0  = KERNEL_DSEG;
  task[KERNEL_TASK].context.zero = 0;
  task[KERNEL_TASK].context.ldtr = 0;
  task[KERNEL_TASK].context.backlink = 0;
  task[KERNEL_TASK].context.iobitmap = 0;
  
#endif /* I386 */

  /* ϥ1Ǥ롣*/
  run_task = &(task[KERNEL_TASK]);
  
  /* 쥯򥻥å */
  task[KERNEL_TASK].tss_selector = ((KERNEL_TASK + TSS_BASE) << 3) & 0xfff8;
  create_context (&task[KERNEL_TASK]);

  /* 쥸ͤꤹ.*/
#ifdef I386
  load_task_register ((KERNEL_TASK + TSS_BASE) << 3);
#endif I386
/*  run_task = &(task[KERNEL_TASK]); */
}


/* :
 *
 *	
 *		task		TCBΰؤΥݥ
 *		stack_size	Υå
 *
 */
static ER
make_task_context (T_TCB *task, T_CTSK *pk_ctsk)
{
  VP	sp;
  ER	err;

  err = make_task_stack (task, pk_ctsk->stksz, &sp);
  if (err != E_OK)
    {
      return (err);
    }

#ifdef I386
  /* 쥸򤹤٤ƽ:
   * reset_registers()  ϡʲΰɬפȤ롧
   *   1) TCB ΰؤΥݥ
   *   2) Υȥɥ쥹
   *   3) ͥ륹åΥɥ쥹
   */
/*  task->context.cr3 = (UW)PAGE_DIR_ADDR; */
  task->context.cs  = KERNEL_ESEG;
  task->context.ds  = KERNEL_DSEG;
  task->context.es  = KERNEL_ESEG;
  task->context.fs  = KERNEL_ESEG;
  task->context.gs  = KERNEL_ESEG;
  task->context.ss  = KERNEL_DSEG;
  task->context.ss0  = KERNEL_DSEG;
  task->context.esp = (UW)((sp + pk_ctsk->stksz) - sizeof (W));
  task->context.ebp = (UW)((sp + pk_ctsk->stksz) - sizeof (W));
  task->context.ldtr = 0;
  task->context.iobitmap = 0;
  task->context.eip = (UW)pk_ctsk->startaddr;
#ifdef TSKSW_DEBUG
  printf ("(UW)pk_ctsk->startaddr = 0x%x\n", (UW)pk_ctsk->startaddr);
#endif
  task->context.eflags = 0;
  task->context.eax = 0;
  task->context.ebx = 0;
  task->context.ecx = 0;
  task->context.esi = 0;
  task->context.edi = 0;
  task->context.zero = 0;
  task->context.iobitmap = 0;
  task->tss_selector = ((TSS_BASE + task->tskid) << 3) & 0xfff8;
#endif /* I386 */
  create_context (task);	/* ƥΰ(TSS)Υɥ쥹GDT˥å */
  return (E_OK); /* set_task_registers (task, pk_ctsk->startaddr, sp)); */
}

/* make_task_stack --- å롣
 *
 * ͥ⡼ɤǻѤ륿ѥå롣
 *
 */
static ER 
make_task_stack (T_TCB *task, W size, VP *sp)
{
  INT	err;

/*  err = pget_blk (&sp, TMPL_SYS, ROUNDUP (size, PAGE_SIZE)); */
  /* åݥ󥿤 0x80000000 βۥɥ쥹ǥɬפ롣*/
  (*sp) = palloc (ROUNDUP (size, PAGE_SIZE) / PAGE_SIZE);
  (UW)(*sp) |= 0x80000000;
#ifdef TSKSW_DEBUG
  printf ("sp = 0x%x\n", *sp);
#endif
  if (*sp == (VP)NULL)
    {
#ifdef TSKSW_DEBUG
      printf ("make_task_stack: palloc fail.\n");
#endif
      return (E_NOMEM);
    }
  
  return (E_OK);
}

/*****************************************************************************
 * ꥹȤ뤿δؿ
 *
 * 
******************************************************************************/
 
/* add_tcb_list ---  list ǻꤵ줿ꥹȤΰֺǸ˥ɲä롣
 *
 * :
 *	list
 *	new
 *
 * ֤:
 *	ꥹȤؤΥݥ
 *
 * .
 *	δؿ¹ԤƤ⡢ꥹȤƬݥ󥿤 *ѹʤ*
 *	ꥹȤǤʤäˤ㳰ǡξˤ
 *	 new ǤĥꥹȤ֤
 *
 */
T_TCB *
add_tcb_list (T_TCB *list, T_TCB *new)
{
  dis_int ();
  if (list == NULL)
    {
      new->before = new;
      new->next = new;
      list = new;
      ena_int();
      return list;
    }

  new->before = list;
  new->next = list->next;
  list->next = new;
  new->next->before = new;
  ena_int();
  return (list);
}

/* ins_tcb_list ---  list ǻꤵ줿ꥹȤΰֺǽ˥롣
 *
 * :
 *	list
 *	new
 *
 * ֤:
 *	ꥹȤؤΥݥ
 *
 * .
 *	δؿ¹Ԥ̡ꥹȤƬݥ󥿤ѹ롣
 *	äơδؿ֤ꥹȤؤΥݥ󥿤ꥹȥݥ󥿤
 *	ɬפ롣
 */
T_TCB *
ins_tcb_list (T_TCB *list, T_TCB *new)
{
  dis_int ();
  if (list == NULL)
    {
      new->before = new;
      new->next = new;
      list = new;
      ena_int ();
      return (list);
    }

  new->next = list;
  new->before = list->before;
  list->before = new;
  new->before->next = new;
  list = new;
  ena_int ();
  return (list);
}


/* del_tcb_list ---  list ǻꤵ줿ꥹȤ顢 del 롣
 *
 * :
 *	list
 *	del
 *
 * ֤:
 *	ꥹȤؤΥݥ
 *
 * 㳰:
 *	1) ⤷ del ꥹȤƬǤξ硢ꥹȤƬݥ󥿤ϡ
 *	   del μǤˤʤ롣
 *	2) ⤷ del ꥹȤͣǤξ硢֤ͤȤ NULL 
 *	   ֤
 *
 * .
 *	δؿ¹Ԥ̡ꥹȤƬݥ󥿤ѹ롣
 *	äơδؿ֤ꥹȤؤΥݥ󥿤ꥹȥݥ󥿤
 *	ɬפ롣
 *
 */
T_TCB *
del_tcb_list (T_TCB *list, T_TCB *del) 
{
  dis_int ();
  if (del->next == del)	/* ꥹȤǤĤʤä */
    {
      ena_int ();
      return (NULL);
    }

  if (list == del)	/* ꥹȤƬǤä */
    {
      list = del->next;
      if (list->next == del)	/* Ǥ2Ĥʤ硢delete ǤμǤϡ
				   delete Ǥ򤵤Ƥ롣ʬȤؤ褦
				   ѹ롣*/
	{
	  list->next = list;
	}
    }

  del->next->before = del->before;
  del->before->next = del->next;
  ena_int ();
  return (list);
}

/* task_switch --- ڤ괹
 *
 * 	save_nowtask	TRUE ΤȤ ready 塼¸
 *				FALSE ΤȤ ready 塼¸ʤ
 *
 * ͡	顼ֹ
 *
 * 	ready_task ǡ̤ͥι⤤򥫥
 *		ˤ롣
 *		ºݤΥڤ괹ϡresume () ˤäƤʤ
 *		ΤᡢδؿǤνϡrun_tsk ѿ
 *		ready_task[] ιԤΤȤʤ롣
 *		
 */
ER
task_switch (BOOL save_nowtask)
{
  T_TCB	*tcb;
  ID	tskid;
  T_TCB *old;		/* */

#ifdef TSKSW_DEBUG
  printf ("task_switch(): start\n");
#endif

  if (on_interrupt)
    {
      delayed_dispatch = TRUE;
      return (E_OK);
    }
  dis_int ();
  if (dispatch_flag == FALSE)
    {
      ena_int ();
      return (E_CTX);
    }

  for (tskid = MIN_PRIORITY; tskid <= MAX_PRIORITY; tskid++)
    {
      if (ready_task[tskid] != NULL)
	break;
    }
  if (tskid > MAX_PRIORITY)
    {
#if defined (TSKSW_DEBUG)
      printf ("task_switch(): error = E_NOEXS\n");	/* */
#endif
      ena_int ();
      return (E_NOEXS);
    }

  if (save_nowtask)	/*  ready 塼¸ */
    {
      run_task->tskstat = TTS_RDY;
      ready_task[run_task->tsklevel] = add_tcb_list (ready_task[run_task->tsklevel],
						     run_task);
    }

#ifdef notdef
  /* 򤷤ʤС⤷ʤ */
  if (run_task == ready_task[tskid])
    {
      ready_task[tskid] = del_tcb_list (ready_task[tskid], run_task);
      ena_int ();
      return (E_OK);
    }
#endif /* notdef */

  /* 򤷤ready_task 塼Ϥ */
  tcb = ready_task[tskid];
  if (tcb->tskstat != TTS_RDY)
    {
      ena_int ();
      return (E_SYS);
    }
  old = run_task;	/* */
  run_task = tcb;
  run_task->tskstat = TTS_RUN;
  ready_task[run_task->tsklevel] = del_tcb_list (ready_task[run_task->tsklevel], run_task);

#ifdef TSKSW_DEBUG
  printf ("task_switch(): new task (ID = %d)\n", tcb->tskid);
#endif
  if (run_task->context.eip == 0)
    {
      printf ("ERROR!!!! context data is invalid.\n");
      printf ("OLD TASK ID = %d\n", old->tskid);
      printf ("NEW TASK ID = %d\n", run_task->tskid);
      falldown ("SYSTEM DOWN.\n");
    }
/* resume ƤӽФresume ΰϡTSS ؤΥ쥯 */
#ifdef TSKSW_DEBUG
  printf ("resume (0x%x)\n", ((tcb->tskid + TSS_BASE) << 3) & 0xfff8);
#endif
  delayed_dispatch = FALSE;
  resume ((UW)(tcb->tskid + TSS_BASE) << 3);
/*  print_context (((tcb->tskid + TSS_BASE) << 3) & 0xfff8); */
  ena_int ();
  return (E_OK);	/* ˽λΥåλˤ */
}


/* task_switch2 --- ڤ괹
 *
 * 	save_nowtask	TRUE ΤȤ ready 塼¸
 *				FALSE ΤȤ ready 塼¸ʤ
 *
 * ͡	顼ֹ
 *
 * 	ready_task ǡ̤ͥι⤤򥫥
 *		ˤ롣
 *		ºݤΥڤ괹ϡresume () ˤäƤʤ
 *		ΤᡢδؿǤνϡrun_tsk ѿ
 *		ready_task[] ιԤΤȤʤ롣
 *		
 */
ER
task_switch2 (BOOL save_nowtask)
{
  T_TCB	*tcb;
  ID	tskid;

#ifdef TSKSW_DEBUG
  printf ("task_switch(): start\n");
#endif

  if (on_interrupt)
    {
      delayed_dispatch = TRUE;
      return (E_OK);
    }
  dis_int ();
  if (dispatch_flag == FALSE)
    {
      ena_int ();
      return (E_CTX);
    }
  ena_int ();

  if (save_nowtask)	/*  ready 塼¸ */
    {
      run_task->tskstat = TTS_RDY;
      ready_task[run_task->tsklevel] = add_tcb_list (ready_task[run_task->tsklevel],
						     run_task);
    }

  for (tskid = MIN_PRIORITY; tskid <= MAX_PRIORITY; tskid++)
    {
      if (ready_task[tskid] != NULL)
	break;
    }
  if (tskid > MAX_PRIORITY)
    {
#if defined (TSKSW_DEBUG)
      printf ("task_switch(): error = E_NOEXS\n");	/* */
#endif
      ena_int ();
      return (E_NOEXS);
    }

  /* 򤷤ʤС⤷ʤ */
  if (run_task == ready_task[tskid])
    {
/*      printf ("task is non new.\n");	/* */
      ready_task[tskid] = del_tcb_list (ready_task[tskid], run_task);
      ena_int ();
      return (E_OK);
    }

  printf ("new task is %d\n", tskid);	/* */

  /* 򤷤ready_task 塼Ϥ */
  tcb = ready_task[tskid];
  if (tcb->tskstat != TTS_RDY)
    {
      ena_int ();
      return (E_SYS);
    }
  run_task = tcb;
  run_task->tskstat = TTS_RUN;
  ready_task[run_task->tsklevel] = del_tcb_list (ready_task[run_task->tsklevel], run_task);

/* #ifdef TSKSW_DEBUG */
  printf ("task_switch(): new task (ID = %d)\n", tcb->tskid);
/* #endif */
/* resume ƤӽФresume ΰϡTSS ؤΥ쥯 */
#ifdef TSKSW_DEBUG
  printf ("resume (0x%x)\n", ((tcb->tskid + TSS_BASE) << 3) & 0xfff8);
#endif
  delayed_dispatch = FALSE;
  ena_int ();
  resume ((UW)(tcb->tskid + TSS_BASE) << 3);
/*  print_context (((tcb->tskid + TSS_BASE) << 3) & 0xfff8); */
  return (E_OK);	/* ˽λΥåλˤ */
}


print_context (UW selector)
{
  TASK_DESC		*desc;
  T_I386_CONTEXT	*tcb;

  desc = (TASK_DESC *)get_gdt ((selector >> 3) - TSS_BASE & 0xffff);
  tcb = (T_I386_CONTEXT *)GET_TSS_ADDR (*desc);
#ifdef TSKSW_DEBUG
  printf ("task ID = %d\n", (selector >> 3) - TSS_BASE);
  printf ("TSS addr = 0x%x\n", tcb);
  printf ("EIP = 0x%x\n", tcb->eip);
#endif
}


/*****************************************************************************
 *
 *		S Y S T E M   C A L L  
 *				  for  T A S K.
 *
 *
 */

/* cre_tsk --- create task.
 *
 * 1롣
 * ϡTTS_DMT ֤Ȥʤꡢsta_tsk()¹ԤޤǤ
 * ºݤưȤϤʤ
 *
 *
 * : tskid 		륿ID
 *	 pk_ctsk	륿°
 *			tskatr		°
 *			startaddr	ưɥ쥹
 *			itskpri		ưͥ
 *			stksz		å
 *			addrmap		ɥ쥹ޥå
 *
 * ֤͡	顼ֹ
 *		E_OK	ｪλ
 *		E_ID	 ID ֹ椬
 *		E_OBJ	ƱΥ¸ߤƤ
 *
 */
ER
cre_tsk (ID tskid, T_CTSK *pk_ctsk)
{
  T_TCB	*newtask;
  W	i;

/*  ID ϰϥå */
  if ((tskid < MIN_TSKID) || (tskid > MAX_TSKID))
    {
      return (E_ID);
    }
/* Ʊ ID Υ¸ߤƤ뤫ɤΥå */
  if (task[tskid].tskstat != TTS_NON)
    {
      return (E_OBJ);
    }

  newtask = &task[tskid];
  bzero (newtask, sizeof (*newtask));
/*  */
  
  newtask->tskid     = tskid;
  newtask->tskstat   = TTS_DMT;
  newtask->tsklevel  = pk_ctsk->itskpri;
  newtask->tsklevel0 = pk_ctsk->itskpri;
  if (make_task_context (newtask, pk_ctsk) != E_OK)
    {
      return (E_NOMEM);
    }

  /* ۥΥޥåԥ󥰥ơ֥ pk_ctsk λꤷޥåפ
   * ѹ롣
   * ꤬ʤȤˤϡȥץƱޥåפȤʤ롣
   */
  if (pk_ctsk->addrmap != NULL)
    {
      newtask->context.cr3 = (UW)(pk_ctsk->addrmap);
    }
  else
    {
      newtask->context.cr3 = (UW)dup_vmap_table (run_task->context.cr3) & 0x7fffffff;
/*
      newtask->context.cr3 = run_task->context.cr3;
*/
    }

  /* Υ꡼ơ֥
   */
  for (i = 0; i < MAX_REGION; i++)
    {
      newtask->regions[i].permission = 0;
    }
  newtask->regions[0].start_addr = (VP)0x80000000;
  newtask->regions[0].min_size   = 0x7fffffff;
  newtask->regions[0].max_size   = 0x7fffffff;
  newtask->regions[0].permission = VPROT_READ | VPROT_WRITE | VPROT_KERNEL;

  return (E_OK);
}

ER
del_tsk (ID tskid)
{
}

/* sta_tsk --- εư
 * 
 * tskidǻꤷư롣
 * ꤷϡcre_tsk Ƥɬפ롣
 *
 * 
 *	tskid	ư륿 ID
 *	stacd	ư
 *
 * ͡
 *	E_OK	ｪλ
 *
 */
ER
sta_tsk (ID tskid, INT stacd)
{
  register int	index;

#ifdef TSKSW_DEBUG
  printf ("sta_tsk: start\n");
#endif
  if ((tskid < MIN_TSKID) || (tskid > MAX_TSKID))
    {
      return (E_ID);
    }
  if (task[tskid].tskstat != TTS_DMT)
    {
      return (E_NOEXS);
    }

  index = task[tskid].tsklevel;
  task[tskid].tskstat = TTS_RDY;
  task[tskid].wakeup_count = 0;
  task[tskid].suspend_count = 0;
  task[tskid].total = 0;
  ready_task[index] = add_tcb_list (ready_task[index], &task[tskid]);
#ifdef TSKSW_DEBUG
  printf ("sta_tsk: task level = %d\n", index);
#endif
  return (E_OK);
}

/******************************************************************************
 * ext_tsk --- λ
 *
 * run_task ˤĤʤƤ륿 TTS_DMT ֤ذư롣
 * 񸻤ʤɤֵѤʤ
 * 
 * 	ʤ
 *
 * ֤͡	ʤ
 *
 * 		Υƥॳ¹ԤȤϡȤΥƥ
 *		ˤʤ
 *
 * ơ
 *	δؿǤϡready 塼ˤĤʤƤ륿Τ
 *	Ǥͥ٤ι⤤Τ򤷡˼¹Ԥ륿Ȥ롣
 *	(򤹤륿ʤȤȤϤʤ--- ɬԤƤ 
 *	idle 뤿)
 *	switch_task() ǤϡԤƤ륿ready塼
 *	롣ext_tsk() ǤϡΥϽλ뤿ᡢready
 *	塼ˤ줺֤TTS_DMTˤ롣
 */
void
ext_tsk (void)
{
  T_TCB	*tcb;
  ID	tskid;

  /* ߤΥ TTS_DMT ֤ˤ򤷤򼡤餻褦 */
  /* ˤ롣							       */
  run_task->tskstat = TTS_DMT;
  task_switch (FALSE);
}

/******************************************************************************
 * exd_tsk --- λȺ
 *
 * run_task ˤĤʤƤ륿 TTS_NON ֤ذư롣
 * 񸻤ʤɤֵѤʤޥåԥ󥰤줿ˤĤƤϡ
 * 롣
 * 
 * 	ʤ
 *
 * ֤͡	ʤ
 *
 * 		Υƥॳ¹ԤȤϡȤΥƥ
 *		ˤʤ
 *
 * ơ
 *	δؿǤϡready 塼ˤĤʤƤ륿Τ
 *	Ǥͥ٤ι⤤Τ򤷡˼¹Ԥ륿Ȥ롣
 *	(򤹤륿ʤȤȤϤʤ--- ɬԤƤ 
 *	idle 뤿)
 *	switch_task() ǤϡԤƤ륿ready塼
 *	롣ext_tsk() ǤϡΥϽλ뤿ᡢready
 *	塼ˤ줺֤TTS_DMTˤ롣
 */
void
exd_tsk (void)
{
  T_TCB	*tcb;
  ID	tskid;

  /* ߤΥ TTS_NON ֤ˤ򤷤򼡤餻褦ˤ롣*/
  run_task->tskstat = TTS_NON;
  release_vmap ((ADDR_MAP)run_task->context.cr3);	/* ޥåԥ󥰥ơ֥ */
  task_switch (FALSE);
}

/*************************************************************************
 * ter_tsk --- ¾λ
 *
 * ǽ
 *	ǻꤷŪ˽λ롣
 *	λ륿ΤäƤ񸻤ϲʤ
 *	ΥƥॳˤäƽλϡTTS_DMT 
 *	֤ˤʤäʤΤǡsta_tsk ƥॳˤäƺƳ
 *	ȤǤ롣
 */
ER
ter_tsk (ID tskid)
{
  switch (task[tskid].tskstat)
    {
    default:
    case TTS_RUN:	/* ξ */
      return (E_OBJ);
      /* NOT REACHED */
   
      /* ready ֤ˤ륿ξ硧λ */
    case TTS_RDY:
      task[tskid].tskstat = TTS_DMT;
      break;

      /* Ԥ֤ˤ륿ξ硧Ԥ֤Ƥ鶯λ롣*/
    case TTS_WAI:
      /* relase_wait();		/* ޤץȤƤʤ*/
      task[tskid].tskstat = TTS_DMT;
      break;
    }
  return (E_OK);
}

ER
dis_dsp ()
{
  dispatch_flag = FALSE;
  return (E_OK);
}

ER
ena_dsp ()
{
  dispatch_flag = TRUE;
  return (E_OK);
}

/* chg_pri --- ץ饤ƥѹ
 *
 */
ER
chg_pri (ID tskid, PRI tskpri)
{
  T_TCB	*p;

  if ((tskid < MIN_TSKID) || (tskid > MAX_TSKID))
    {
      return (E_ID);
    }
  switch (task[tskid].tskstat)
    {
    default:
      return (E_OBJ);

    case TTS_NON:
      return (E_NOEXS);

    case TTS_RDY:
      ready_task[task[tskid].tsklevel] = del_tcb_list (ready_task[task[tskid].tsklevel], &task[tskid]);
      task[tskid].tsklevel = tskpri;
      ready_task[task[tskid].tsklevel] = add_tcb_list (ready_task[task[tskid].tsklevel], &task[tskid]);
      break;

    case TTS_RUN:
      task[tskid].tsklevel = tskpri;
      break;
    }
  return (E_OK);
}

/* rot_rdq --- Ʊץ饤ƥǤΥνѹ
 *
 */
ER
rot_rdq (PRI tskpri)
{
  T_TCB	*first;

  if ((tskpri < MIN_PRIORITY) || (tskpri > MAX_PRIORITY))
    {
      return (E_PAR);
    }
  first = ready_task[tskpri];
  ready_task[tskpri] = del_tcb_list (ready_task[tskpri], first);
  ready_task[tskpri] = add_tcb_list (ready_task[tskpri], first);
  return (E_OK);
}

ER
rel_wai (ID tskid)
{
}

/***********************************************************************************
 * get_tid --- Υ ID 
 *
 *
 */
ER
get_tid (ID *p_tskid)
{
  *p_tskid = run_task->tskid;
  return (E_OK);
}

/***********************************************************************************
 * ref_tsk --- ֤λ
 *
 * ֤֤
 *
 */
ER
ref_tsk (T_RTSK *pk_rtsk, ID tskid)
{
  if ((tskid < MIN_TSKID) || (tskid > MAX_TSKID))
    {
      return (E_ID);
    }
  switch (task[tskid].tskstat)
    {
    default:
      pk_rtsk->tskpri = task[tskid].tsklevel;
      pk_rtsk->tskstat = task[tskid].tskstat;
      pk_rtsk->total_time = task[tskid].total;
      break;

    case TTS_NON:
      return (E_NOEXS);
    }
  return (E_OK);
}

/*********************************************************************************
 * slp_tsk --- Ԥ֤ˤ
 *
 *	ʬȤԤ֤ˤơ¾ΥϤ
 *	ԤװϡδؿǤϥåȤʤ
 *
 */
ER
slp_tsk (VOID)
{
/*  printf ("slp_tsk: start\n");	/* */
  dis_int ();
  if (run_task->wakeup_count > 0)
    {
      run_task->wakeup_count--;
/*      printf ("sleep task: wakeup count = %d\n", run_task->wakeup_count--); */
      ena_int ();
      return (E_OK);
    }
  
  run_task->slp_err = E_OK;
  run_task->tskstat = TTS_WAI;
  ena_int ();
  task_switch (FALSE);	/* run_task  ready_task 塼¸ʤ */
/*  task_switch2 (FALSE);	/* run_task  ready_task 塼¸ʤ */
  return (run_task->slp_err);
}

/*********************************************************************************
 * wup_tsk --- ꤵ줿򵯾롣
 *
 * ǽ
 * 	Ԥ֥ե饰(tskwai)ϡδؿƤӽФ˥ꥻåȤƤʤ
 *	ʤ
 * 	⤷Ԥ֥ե饰åȤƤʤСE_OBJ Υ顼Ȥʤ롣
 * 
 */
ER
wup_tsk (ID taskid)
{
  T_TCB	*p;

  if ((taskid < MIN_TSKID) || (taskid > MAX_TSKID))
    {
      return (E_ID);
    }

  dis_int ();
  p = &(task[taskid]);
  if ((p == run_task) || (p->tskstat == TTS_DMT))
    {
      ena_int ();
      return (E_OBJ);
    }

  /* ٤ƤԤ֤ƤʤСˤϿʤޤʤ */
  if ((p->tskwait.time_wait) || (p->tskwait.semaph_wait) || (p->tskwait.event_wait) || (p->tskwait.msg_wait))
    {
      printf ("task %d is waiting. abort wakeup.\n", p->tskid);
      printf ("(p->tskwait.time_wait) = %d\n", (p->tskwait.time_wait));
      printf ("(p->tskwait.semaph_wait) = %d\n", (p->tskwait.semaph_wait));
      printf ("(p->tskwait.event_wait) = %d\n", (p->tskwait.event_wait));
      printf ("(p->tskwait.msg_wait) = %d\n", (p->tskwait.msg_wait));
      ena_int ();
      return (E_OBJ);
    }

  if (p->tskstat == TTS_WAS)
    {
      p->tskstat = TTS_SUS;
    }
  else if (p->tskstat == TTS_WAI)
    {
      p->tskstat = TTS_RDY;
      if ((p < 0x7fffffff) || (UW)(p >= 0x81000000))
	{
	  printf ("wup_tsk: error on tasklist\n");
	  print_task_list ();
	  falldown ("kernel: task.\n");
	}
      else
	{
	  ready_task[p->tsklevel] = ins_tcb_list (ready_task[p->tsklevel], p);
	}
    }
  else if (p->tskstat == TTS_SUS)
    {
      p->wakeup_count++;
    }

  ena_int ();
  return (E_OK);
}

/*****************************************************************************
 * sus_tsk --- ꤷԤ֤˰ܹ
 *
 * 
 *	taskid --- suspend 륿 ID
 *
 * ֤͡
 *
 *
 * ǽ
 *
 */
ER
sus_tsk (ID taskid)
{
  T_TCB	*taskp;

  if ((taskid < MIN_TSKID) || (taskid > MAX_TSKID))
    {
      return (E_ID);
    }

  if (&task[taskid] == run_task)
    {
      return (E_OBJ);
    }

  dis_int ();
  taskp = &task[taskid];
  taskp->suspend_count++;
  switch (taskp->tskstat)
    {
    case TTS_RDY:
      ready_task[taskp->tsklevel] = del_tcb_list (ready_task[taskp->tsklevel], taskp);
      taskp->tskstat = TTS_SUS;
      break;

    case TTS_SUS:
      if (taskp->suspend_count > MAX_SUSPEND_NEST)
	{
	  taskp->suspend_count = MAX_SUSPEND_NEST;
	  ena_int ();
	  return (E_QOVR);
	}
      break;

    case TTS_WAI:
      taskp->tskstat = TTS_WAS;
      break;

    case TTS_NON:
      ena_int ();
      return (E_NOEXS);
      /* DO NOT REACHED */

    default:
      ena_int ();
      return (E_OBJ);
      /* DO NOT REACHED */
    }
  ena_int ();
  return (E_OK);
}

/******************************************************************************************
 * rsm_tsk --- Ԥ֤ΥԤ֤
 *
 * 
 *	taskid --- suspend Ƥ륿 ID
 *
 *
 * ֤͡
 *	Υ顼ֹ椬֤
 *	
 * E_OK     ƥॳ˽λ
 * E_ID      ID 
 * E_NOEXS  ¸ߤʤ(TTS_NON )
 * E_OBJ    ξ֤(TTS_SUS, TTS_WAS, TTS_NON ʳ)
 *
 *
 * ǽ
 *	Ԥ֤ˤ륿Ԥ֤鶯Ū˲롣
 *
 *	Ԥ֤¿Ťˤʤ뤳Ȥ뤬ΥƥॳϡҤȤĤԤ
 *	롣
 */
ER
rsm_tsk (ID taskid)
{
  T_TCB	*taskp;

  if ((taskid < MIN_TSKID) || (taskid > MAX_TSKID))
    {
      return (E_ID);
    }

  dis_int ();
  taskp = &task[taskid];
  switch (taskp->tskstat)
    {
    case TTS_SUS:
      taskp->suspend_count--;
      if (taskp->suspend_count <= 0)
	{
	  taskp->tskstat = TTS_RDY;
	  ready_task[taskp->tsklevel] = ins_tcb_list (ready_task[taskp->tsklevel], taskp);
	}
      break;

    case TTS_WAS:
      taskp->suspend_count--;
      if (taskp->suspend_count <= 0)
	{
	  taskp->tskstat = TTS_WAI;
	}
      break;

    case TTS_NON:
      ena_int ();
      return (E_NOEXS);

    default:
      ena_int ();
      return (E_OBJ);
    }
  ena_int ();
  return (E_OK);
}

/******************************************************************************
 * frsm_tsk --- Ԥ֤ΥԤ֤(¿ŤԤ)
 *
 * 
 *	taskid --- suspend 륿 ID
 *
 * ֤͡
 *	顼ֹ
 *
 * ǽ
 *
 */
ER
frsm_tsk (ID taskid)
{
  T_TCB	*taskp;

  if ((taskid < MIN_TSKID) || (taskid > MAX_TSKID))
    {
      return (E_ID);
    }

  dis_int ();
  taskp = &task[taskid];
  switch (taskp->tskstat)
    {
    case TTS_SUS:
      taskp->tskstat = TTS_RDY;
      ready_task[taskp->tsklevel] = ins_tcb_list (ready_task[taskp->tsklevel], taskp);
      break;

    case TTS_WAS:
      taskp->tskstat = TTS_WAI;
      break;

    case TTS_NON:
      ena_int ();
      return (E_NOEXS);

    default:
      ena_int ();
      return (E_OBJ);
    }
  ena_int ();
  return (E_OK);
}

/******************************************************************************************
 * can_wup --- ε׵̵
 *
 * 
 *	taskid ---  ID
 *
 * ֤͡
 *	顼ֹ
 *
 * ǽ
 *
 */
ER
can_wup (INT *p_wupcnt, ID taskid)
{
  T_TCB	*taskp;

  if ((taskid < MIN_TSKID) || (taskid > MAX_TSKID))
    {
      return (E_ID);
    }

  dis_int ();
  taskp = &task[taskid];
  switch (taskp->tskstat)
    {
    case TTS_WAS:
    case TTS_WAI:
      *p_wupcnt = taskp->wakeup_count;
      taskp->wakeup_count = 0;
      break;

    case TTS_NON:
      ena_int ();
      return (E_NOEXS);
      /* DO NOT REACHED */

    default:
      ena_int ();
      return (E_OBJ);
      }
  ena_int ();
  return (E_OK);
}


/***********************************************************************
 * new_task --- ǤդΥ ID ǤΥ
 *
 * 
 *	pk_ctsk	륿°
 *		tskatr		°
 *		startaddr	ưɥ쥹 (run_flag == TRUE ΤȤ)
 *		itskpri		ưͥ
 *		stksz		å
 *		addrmap		ɥ쥹ޥå
 *	rid	 ID (֤)
 *	run_flag  ¹Ԥ
 *
 * ֤͡
 *	顼ֹ
 *	E_OK	ｪλ
 *
 * ǽ
 *	new_task ϡȤ cre_tsk ȤۤȤ
 *	Ʊǽġcre_tsk  ID ɬפȤΤ
 *	new_task ϡ ID ưŪ˳ꤢƤ롣
 *
 */
ER
new_task (T_CTSK *pk_ctsk, ID *rid, BOOL run_flag)
{
  ID	i;
  ER	err;

  for (i = MIN_USERTASKID; i <= MAX_USERTASKID; i++)
    {
      err = cre_tsk (i, pk_ctsk);
      if (err == E_OK)
	{
	  *rid = i;
	  if (run_flag == TRUE)
	    sta_tsk (i, 0);
	  return (E_OK);
	}
    }
  return (E_NOMEM);
}


T_TCB *
get_tskp (ID tskid)
{
  if ((tskid < MIN_TSKID) || (tskid > MAX_TSKID))
    {
      return ((T_TCB *)NULL);
    }
  return (&task[tskid]);
}

