/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/*************************************************************************
 *
 *		2nd BOOT memory allocate/deallocate routine.
 *
 * $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/boot/2nd/memory.c,v 1.2 2011/12/30 00:57:06 liu1 Exp $
 *
 * $Log: memory.c,v $
 * Revision 1.2  2011/12/30 00:57:06  liu1
 * コンパイルエラーの修正。
 *
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.6  1999-03-15 01:35:30  monaka
 * Minor modify. Function printf was renamed to boot_printf. Some cast was added. and so on.
 *
 * Revision 1.5  1998/11/20 08:02:36  monaka
 * *** empty log message ***
 *
 * Revision 1.4  1996/08/12 19:34:42  night
 * ʪꥵåȤκ祵 16MB  256 MB ѹ
 *
 * Revision 1.3  1996/07/24  14:02:13  night
 * ;ʬ print ʸ
 *
 * Revision 1.2  1996/07/22  13:35:08  night
 * A20 򥤥֥͡ˤɲá
 *
 * Revision 1.1  1996/05/11  10:45:05  night
 * 2nd boot (IBM-PC  B-FREE OS) Υ
 *
 * Revision 1.5  1995/09/21  15:50:41  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.4  1995/09/20  15:32:20  night
 * malloc ѤΥ 640K - 100K ʬѹ
 *
 * Revision 1.3  1995/06/28  14:11:07  night
 * ꥢȤδΰ (640K - 100K)  640K  (2M - 100K) 
 * 2M ѹ
 *
 * Revision 1.2  1995/06/26  15:06:12  night
 * malloc ؿɲá
 *
 * Revision 1.1  1993/10/11  21:29:33  btron
 * btron/386
 *
 * Revision 1.1.1.1  93/01/14  12:30:24  btron
 * BTRON SYSTEM 1.0
 * 
 * Revision 1.1.1.1  93/01/13  16:50:27  btron
 * BTRON SYSTEM 1.0
 * 
 */

static char	rcsid[] = "$Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/boot/2nd/memory.c,v 1.2 2011/12/30 00:57:06 liu1 Exp $";

#include "types.h"
#include "location.h"
#include "config.h"
#include "memory.h"
#include "asm.h"

struct alloc_entry
{
  struct alloc_entry	*next;
  int size;
  BYTE body[0];
};

static struct alloc_entry	*alloc_reg;


extern int	end;

static void	init_malloc (void *last, int size);
void		*last_addr;
UWORD32	base_mem, ext_mem, real_mem;

#define TRUE_SIZE(size)	(size + sizeof (struct alloc_entry))

static void
enable_A20 ()
{
  for (;;)
    {
      if ((inb (0x64) & 0x02) == 0)
	break;
    }
  outb (0x64, 0xD1);
  for (;;)
    {
      if ((inb (0x64) & 0x02) == 0)
	break;
    }
  outb (0x60, 0xdf);
}


/**************************************************************************
 * init_memory
 *
 *
 */
void
init_memory (void)
{
  volatile int	*p;

  last_addr = (void *)&end;
#ifdef	PC9801
  outb (0x00f2, 0);	/* 1M ʾΰѤǤ褦ˤ롣*/
#elif IBMPC
  /* IBMPC (ߴ)  A20 򥤥֥͡ˤ롣
   * 0xD1 -> out (0x64)
   * 0xDF -> out (0x60)
   */
  enable_A20 ();
#endif
  for (p = (int *)0x100000; (int)p < 0xf000000; p = (int *)((int)p + 0x100000))
    {
      *p = 0;
      *p = 0xAA;
      if (*p != 0xAA)
	break;
    }
  boot_printf ("Extended Memory = %d K bytes\n", ((int)p - 0x100000) / 1000);
  boot_printf ("USE Memory      = %d bytes\n", last_addr);

  ext_mem = ((int)p - 0x100000);
  base_mem = BASE_MEM;
  real_mem = ext_mem + BASE_MEM;

#ifdef nodef
  /* malloc ν */
  init_malloc ((void *)(2 * 1024 * 1024), MALLOC_SIZE);
#endif
  /* 640K ХȤ鲼 100 K ХȤΰ malloc Ѥ˻Ѥ */
  init_malloc ((void *)(640 * 1024), MALLOC_SIZE);
}

/*
 * boot ǥѤ뵡ν
 *
 * 裱ǻꤷκǸ夫顢裲ǻꤷʬ 
 * malloc ǻѤ롣
 *
 */
static void
init_malloc (void *last, int size)
{
  alloc_reg = (struct alloc_entry *)(last - size);
  alloc_reg->size = size;
  alloc_reg->next = alloc_reg;
#ifdef nodef
  boot_printf ("init_malloc: last = 0x%x\n", last);
  boot_printf ("init_malloc: alloc_reg = 0x%x\n", alloc_reg);
  boot_printf ("init_malloc: alloc_reg->size = %d\n", alloc_reg->size);
  boot_printf ("init_malloc: alloc_reg->next = 0x%x\n", alloc_reg->next);
#endif
}

/*
 * malloc --- ꤷΥ
 *
 * alloc_reg ˤϡȤǤե꡼Υȥ꤬Ĥʤä
 * 롣椫ǽ˥ȤǤ륵äΤ
 * 
 */
void *
malloc (int size)
{
  int			true_size;	/* ΰޤ"" */
					/*  */
  struct alloc_entry	*p, *prev;
  struct alloc_entry	*alloced;


  if (alloc_reg == NULL)	/* ٤ե꡼꤬ʤ */
    {
      return (NULL);
    }

  true_size = TRUE_SIZE (size);

/*  boot_printf ("alloc_reg = 0x%x, alloc_reg->next = 0x%x\n", alloc_reg, */
/*  alloc_reg->next); */

  for (prev = alloc_reg, p = alloc_reg->next;
       p->size < true_size;
       prev = p, p = p->next)
    {
      if (p == alloc_reg)	/* Ǥ륨ȥ꤬ʤä */
	{
	  return (NULL);
	}
    }

  if (p->size == true_size)	/* ٤Υä */
    {
      if (p->next == p)	/* ĤʤäƤ륨ȥϤҤȤĤä */
	{
	  alloc_reg = NULL;
	  p->next = NULL;
	}
      else
	{
	  /* ե꡼ꥹȤ p ǻꤵƤ륨ȥ򳰤 */
	  prev->next = p->next;
	}
      
      return ((void *)(p->body));	/* ؤΥݥ */
					/* ֤ΰϡ */
					/* alloc_reg ¤Τ body  */
					/* ǤǤ뤳Ȥ */
    }

  alloced = (struct alloc_entry *)(((char *)p) + (p->size - true_size));
  p->size -= true_size;
  alloced->size = true_size;
  return (alloced->body);
}

/*
 * Ϥ줿ݥ󥿤ؤΰե꡼ꥹȤ롣
 * ⤷ΰ褬ե꡼ꥹȤˤʤΤä顢ʤˤ⤷ʤ
 */
void
free (void *ptr)
{
  struct alloc_entry	*current, *prev;
  struct alloc_entry	*new_entry;

  new_entry = (struct alloc_entry *)((char *)ptr - sizeof (struct alloc_entry));

  /* ꤵ줿ΰ malloc ǴƤΰǤϤʤ. */
  if (((char *)new_entry < (char *)(void *)ext_mem 
                            + (1024 * 1024) - MALLOC_SIZE) 
      || ((char *)new_entry > (char *)(void *)ext_mem + (1024 * 1024)))
    {
      return;
    }

  /* ե꡼ꥹȤ˥ȥϤҤȤĤʤ */
  if (alloc_reg == alloc_reg->next)
    {
      if (((char *)new_entry + new_entry->size) == (char *)alloc_reg)
	{
	  new_entry->size += alloc_reg->size;
	  new_entry->next = new_entry;
	  alloc_reg = new_entry;
	}
      else if (((char *)alloc_reg + alloc_reg->size) == (char *)new_entry)
	{
	  alloc_reg->size += new_entry->size;
	}
      else
	{
	  alloc_reg->next = new_entry;
	  new_entry->next = alloc_reg;
	}
      return;
    }

  /* ե꡼ꥹȤƬéꡢꥹȤݥȤ */
  /* ե꡼ꥹȤϥɥ쥹ˤʤäƤꡢcurrent Υɥ쥹ɲä */
  /* ΰκǸ礭ʤä顢롣*/
  for (prev = alloc_reg, current = alloc_reg->next;
       current != alloc_reg;
       prev = current, current = current->next)
    {
      /* current ܤƤ롣current ΰĤʤ */
      if ((char *)current == ((char *)new_entry + new_entry->size))
	{
	  new_entry->size += current->size;
	  new_entry->next = current->next;
	  current = new_entry;
	  prev->next = current;
	}
      else
	{
	  /* current ˤܤƤʤꥹȤ */
	  new_entry->next = current;
	  prev->next = new_entry;
	}
      
      /* prev ܤƤ硣prev Υ䤹*/
      /* ΤȤcurrent ʻ礷Ƥ褦ñƤ褦 */
      /* ɤˤƤ prev->next ϡnew_entryؤƤ뤳Ȥ */
      if ((char *)new_entry == ((char *)prev + prev->size))
	{
	  prev->size += new_entry->size;
	  prev->next = new_entry->next;
	}
    }
}
