/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* 
  This file is part of BTRON/386

  $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/ITRON/h/config.h,v 1.1 2011/12/27 17:13:35 liu1 Exp $

  

*/

#ifndef _ITRON_CONFIG_H_
#define _ITRON_CONFIG_H_	1

#define CALL_HANDLER_IN_TASK	/* ޡΥϥɥ顼μ¹Ԥ task 1 ǹԤ */

#include "../i386/i386.h"

#define GDT_ADDR	(0x80001000)
#define IDT_ADDR	(0x80002000)
#define MAX_GDT		(255)		/* GDT κΥǥå */
#define MAX_IDT		(255)		/* IDT κΥǥå */

#define TASK_DESC_MIN	TSS_BASE
#define KERNEL_ESEG	(0x0008)	/* ͥΥɥ */
#define KERNEL_DSEG	(0x0010)	/* ͥΥǡ */
#define USER_ESEG	(0x0018)	/* 桼Υɥ */
#define USER_DSEG	(0x0020)	/* 桼Υǡ */

#define PAGE_DIR_ADDR	(0x3000)	/* ۥڡǥ쥯ȥơ֥ */
#define PAGE_ENTRY_ADDR	(0x4000)	/* ۥڡơ֥ */

/* ط */ 
#define MAX_TSKID	(128)		/* Υ ID 	*/
#define MIN_TSKID	(1)		/* ǾΥ ID 	*/
#define NTASK		(MAX_TSKID - MIN_TSKID + 1)	/* 	*/

#define MIN_PRIORITY	(0)		/* ǾΥץ饤ƥ	*/
#define MAX_PRIORITY	(31)		/* Υץ饤ƥ	*/

#define MIN_USERTASKID	(21)
#define MAX_USERTASKID	MAX_TSKID

#define MAX_SUSPEND_NEST	(10)	/* ڥɤΥͥȤΥСե */

#define KERNEL_LEVEL	(2)


/* ޥեط */
#define MIN_SEMAID		(1)
#define MAX_SEMAID		(256)
#define NSEMAPHORE		(MAX_SEMAID - MIN_SEMAID + 1)
#define MIN_USERSEMAID		(10)
#define MAX_USERSEMAID		MAX_SEMAID


/* ٥ȥե饰ط */
#define MIN_EVENTFLAG		(1)
#define MAX_EVENTFLAG		(256)
#define NEVENTFLAG		(MAX_SEMAID - MIN_SEMAID + 1)
#define MIN_USEREVENTID		(10)
#define MAX_USEREVENTID		MAX_EVENTFLAG


/* åХåեط */
#define MIN_MSGBUF		(1)
#define MAX_MSGBUF		(256)
#define NMSGBUF			(MAX_MSGBUF - MIN_MSGBUF + 1)
#define MAX_MSGENTRY		(1000)
/*
 * ͳ˻ȤåХåեκǾ ID Ⱥ ID
 */
#define MIN_USERMBFID		(100)
#define MAX_USERMBFID		MAX_MSGBUF


/* ط */
#define MAX_MEMPOOL	(100)
#ifndef PAGE_SIZE
#define PAGE_SIZE	I386_PAGESIZE
#endif
#define PAGE_SHIFT	(12)
#define DIR_SHIFT	(22)
#define	MIN_KERNEL	(0x80000000)
#define MAX_KERNEL	(0xffffffff)

#define MEM_SIZE		(0x100000)	/* ĥ 1M Х */
#define MAX_FREEMEM_ENTRY	(1000)	/* ե꡼뤿Υơ֥ */
#define MAX_MEMORY_POOL		(100)
#define SYSTEM_MEMORY_SIZE	(8 * 1024 * 1024)	/* ƥ 8 M */
#define MEMORY_POOL_BASE	(0x80010000U)		/* ƥȤƴΰΥ١ */

#define SYSTEM_MEMORY_POOL	(0)	/* ƥס ID */

#define MAX_REGION		(5)	/* ƥ¸ߤǤ REGION ο */

/* IO ط */
#define MAX_DEVICE_NAME		(16)	/* ǥХ̾κĹ (16 Х) */
#define MIN_DEVID		(0)
#define MAX_DEVID		(19)
#define MAX_DEVICE		(MAX_DEVID - MIN_DEVID + 1)	/* ǥХκ */


/* 󥿡Х륿 */
#define MAX_TIMER	(500)


/* ƥॿΥꥹ */
#define NSYSTEM_TASK	(20)		/* ƥॿο */

#define ITRON_IDLE	(1)
#define ITRON_RS232C	(2)	/* ITRON  RS232C ɥ饤Х */
#define ITRON_KEYBOARD	(3)
#define ITRON_CONSOLE	(4)	/* 󥽡ǥХɥ饤 */
#define ITRON_DEBUG	(5)	/* ǥХåѥץ: ޥɥ󥿥ץ꥿ */

/*
 * ݡȥޥ͡㤬׵ĤѤ˻ꤹåХåե ID 
 */
#define PORT_MANAGER_PORT	(11)


/* ƥॻޥեΥꥹ */
#define ITRON_KEYBOARD_SEM	(3)	/* ܡѤΥޥե	 */

/* ִ */
#define MAX_CYCLIC		(50)	/* ưϥɥκ */
#define MAX_ALARM		(50)	/* 顼ϥɥκ */

/* ƥåХåեΥꥹ */
#define ITRON_DEBUG_MBF		(1)	/* ǥХåѥץ: ޥɥ󥿥ץ꥿ǻ */
#define ITRON_RS232C_MBF	(2)	/* ITRON  RS232C ɥ饤Хǻ */
#define ITRON_KEYBOARD_MBF	(3)	/* ܡѤΥåХåե */


extern W	ndevice;
extern ER	(*devices[])(void);


#endif /* _ITRON_CONFIG_H_ */
