/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/*
 *
 */

#ifndef __ITRON_TASK_H__
#define __ITRON_TASK_H__	1

#include "itron.h"
#include "i386.h"

#define KERNEL_TASK	(1)

struct t_task_wait
{
  W	time_wait:1;
  W	semaph_wait:1;
  W	event_wait:1;
  W	msg_wait:1;
};

typedef struct t_task_wait  T_TASK_WAIT;


/* task_spec_interrupt - ߽ͭؿ
 *
 *	ι¤Τˤϡͭγ߽ؿϿ롣
 *	(LOWLIB ΥեȥϿ˻Ѥ)
 */
typedef struct task_spec_interrupt
{
  W		intr_no;
  ER		(*intr_func)(W, VP);
} T_TSI;


/* t_tcb --- ¤
 *
 *	ι¤Τˤϡθͭ󤬴ޤޤ롣
 *	ITRON ٥ʤΤǡեξʤɤϴޤޤƤʤ
 *
 */
typedef struct t_tcb
{
  struct t_tcb		*next;		/* TCB			*/
  struct t_tcb		*before;	/* TCB			*/

  W			tskid;		/*  ID			*/
  W			tsklevel;	/* ͥ		*/
  W			tsklevel0;	/* ͥ() */
  					/* λٵư */
					/* ˤϤͤȤ롣       */
  ATR			tskatr;		/* °			*/
  H			tskstat;	/* ξ			*/

  /* ԤѤ */
  T_TASK_WAIT		tskwait;	/* Ԥ֤򼨤ե饰 */
  W			wakeup_count;	/* Ⱦ֤Υ       */
  W			suspend_count;	/* ڥɾ֤Υ     */

  ER			slp_err;	/* Ԥ֤˴ؤƤΥ顼	*/
					/* ٤ƤƱǶ̤˻ */
					/* 				*/

/* Ʊǽ */
  /* ޥե */
  struct t_tcb	 	*sem_next;	/* ΥޥեԤ	*/
  ID			sem_id;		/* ԤäƤ륻ޥե ID */

  /* ٥ȥե饰 */
  struct t_tcb	 	*event_next;	/* Υ٥ȥե饰Ԥ	*/
  UINT			flag_pattern;	/* ٥ȥե饰Ԥѥ	*/
  UINT			wfmode;		/* Ԥλ		*/
  ID			event_id;	/* ԤäƤ륤٥ȥե饰 ID */
  UINT			rflgptn;	/* ؿͤȤ֤ե饰ѥq */

  /* å */
  struct t_tcb	 	*msg_next;	/* ΥåԤ	*/
  ID			msg_id;		/* ԤäƤå ID */


/* å */
  W			stksz;		/* λĥåΥ	*/
  					/* ϡͥ륹åΥ	*/
					/* Ȥʤ			*/

  B			*stackptr;	/* ͥ륹åΰؤΥ	*/
					/* 			*/


/* ׾ */
  W			total;		/* ¹Ի			*/

#ifdef I386
  T_I386_CONTEXT	context;	/* ƥȾ (CPU¸)	*/
  UW			tss_selector;	/* Υ쥯 (CPU¸)	*/
#endif

/* ۵ */
  T_REGION		regions[MAX_REGION];	/* ˷ӤĤ */
						/*  REGION Υơ */
						/* ֥ */ 


  T_TSI			interrupt[MAX_MODULE];	/* ͭγ */
						/* ߽ؿơ֥ */
  W			n_interrupt;

  W			(*page_fault_handler)(W, W);	/* ڡեȻνѴؿ */

  UW			initial_stack;
} T_TCB;


extern T_TCB		*run_task;		/* ߡΥ */

#define GET_TSKWAIT(tcb)	(tcb.tskwait)


#endif /* __ITRON_TASK_H__ */
