/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/ITRON/servers/port-manager.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */

static char rcs[] = "@(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/ITRON/servers/port-manager.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";

/*
 * $Log: port-manager.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.1  1999-04-18 17:48:36  monaka
 * Port-manager and libkernel.a is moved to ITRON. I guess it is reasonable. At least they should not be in BTRON/.
 *
 * Revision 1.3  1999/04/13 04:14:58  monaka
 * MAJOR FIXcvs commit -m 'MAJOR FIX!!! There are so many changes, modifys, fixes. Sorry but I can't remember all of those. For example, all the manager and driver programmer have got power to access all ITRON systemcall. (My works is just making access route to ITRON. I don't know what happens in the nuclus.'! There are so many changes, modifys, fixes. Sorry but I can't remember all of those. For example, all the manager and driver programmer have got power to access all ITRON systemcall. (My works is just making access route to ITRON. I don't know what happens in the nuclus.
 *
 * Revision 1.2  1999/02/17 14:56:35  night
 * åХåե°νɲ
 *
 * +  msg_pk.mbfatr = TA_TFIFO;
 *
 * Revision 1.1  1996/07/23 00:03:04  night
 * IBM PC ѤκǽϿ
 *
 * Revision 1.3  1995/09/21  15:51:48  night
 * եƬ Copyright notice ɲá
 *
 * Revision 1.2  1995/06/26  15:19:15  night
 * Ĥ printf  DEBUG ޥǰϤ
 *
 * Revision 1.1  1995/03/18  14:12:45  night
 * ǽϿ
 *
 *
 */

/*
 * ݡȥޥ͡
 *
 * <ΥФϡץĶ (BTRON or POSIX) ˴طʤư>
 *
 *
 * ճˤץꥱ̿뤿˻ѤåХåե
 *  ID 롣
 * ITRON (濴) ϥåХåեˤ̿Ǥ롣
 * ΤޤޤǤϡճˤɤΥåХåեȤäƤ뤫狼
 * 
 * ݡȥޥ͡ϡХ̾ȥåХåե ID 
 * 롣ϡݡȥޥ͡ФϿ뤳Ȥˤäơ
 * ¾ΥåХåե򥢥Ǥ褦ˤ롣
 *
 * ⤷ʤƤݡȥޥ͡ФƥǤ褦ˡݡ
 * ޥ͡㼫ȤϡΥåХåե ID (11) Ȥ
 * 
 * ݡȥޥ͡ϡ(ճˤƱͤ) ФȤư (桼⡼
 * (CPU ø٥ 3)ư)
 *
 * ݡȥޥ͡ΥåϼηѰդƤ롣
 *
 * regist_port_t	{ PORT_NAME name; ID port; ID task; }
 * unregist_port_t	{ PORT_NAME name; ID task; }
 * find_port_t		{ PORT_NAME name; }
 *
 * ˡ˼إåääåݡȥޥ͡
 * 뤳Ȥˤʤ롣
 *
 * msg_header { W msg_type; W size };
 *
 *
 * ݡȥޥ͡Ф׵ά뤿ˡ饤֥ 
 * (libport.a) ѰդƤ롣Υ饤֥ϡݡȥޥ͡
 * åԤؿ¾˥å򰷤
 * ؿäƤ롣
 * ǡΥ饤֥ˤĤƤϡݡȥޥ͡˴ؤؿȤƤϡ
 * ΤΤ롣
 *
 * regist_port (PORT_NAME name, ID port);   åХåե ID Ͽ
 * unregist_port (PORT_NAME name);	    åХåե ID 
 * find_port (PORT_NAME name, ID &port);    åХåե ID θ
 * 
 */


#include <itron.h>
#include <errno.h>
#include <types.h>
#include "port-manager.h"


/*
 * Хѿ
 */
ID	request_port;


/*
 * ݡȥޥ͡ǻȤؿΥץȥ
 *
 */
extern void	_main (void);
extern void	regist_port (struct port_manager_msg_t *msgp);
extern void	unregist_port (struct port_manager_msg_t *msgp);
extern void	find_port (struct port_manager_msg_t *msgp);


/*
 * ΥեǤѤʤƥåؿ
 */
static void	recv_port_manager (ID rport, PORT_MANAGER_ERROR errno, ID port);


/*
 *	ݡȥޥ͡ main 
 *	åԤθå - 
 *	롼פ롣
 */
void
_main (void)
{
  T_CMBF				msg_pk;
  ER					error;
  struct port_manager_msg_t		msg_buf;
  INT					size;


  /*
   * ץν
   * åХåե롣
   * åХåե ID ϡPORT_MANAGER_PORT ޥǻꤷ
   * ΤѤ롣
   *
   *
   * <γĥؤΥǥ>
   *
   * ϡåХåե˥Ǥ褦ˤ롣
   * ꤹ뤳ȤˤäơåХåե
   * ʳϡåɤ߼ʤʤɤǽȤ롣
   *
   */
  msg_pk.bufsz = sizeof (struct port_manager_msg_t);
  msg_pk.maxmsz = sizeof (struct port_manager_msg_t) * MAX_MSG_ENTRY;
  msg_pk.mbfatr = TA_TFIFO;
  error = cre_mbf (PORT_MANAGER_PORT, &msg_pk);
  if (error != E_OK)
    {
      exd_tsk ();
      /* NOT REACHED */
    }

  /* 
   * Ͽơ֥ν
   */
  init_regist_table ();

  dbg_puts ("port manager start.\n");
  /*
   *	åȽ
   *	ݡȥޥ͡ϡ󥰥륿ư롣
   *	ΤᡢåμνλޤǤϡ¾׵ϼ
   *	Ĥʤ
   */
  for (;;)
    {
      /* 
       * å롣
       * Ȥ˻ѤåХåեϡPORT_MANAGER_PORT
       * ޥǻꤷΤѤ롣
       */
      error = rcv_mbf (&msg_buf, &size, PORT_MANAGER_PORT);
      if (error == E_OK)
	{
	  /*
	   * åȤɽ롣
	   * ϡǥХåΤ줿
	   */
#ifdef DEBUG
	  dbg_puts ("port-manager: message read.\n");
#endif /* DEBUG */

	  /*
	   * åν
	   * åΥإåμफŬڤʽԤ
	   */
	  switch (msg_buf.hdr.type)
	    {
	    case REGIST_PORT:	
	      /*
	       * åХåե ID Ͽ
	       */
	      dbg_printf ("port-manager: (regist) <%s>\n", msg_buf.body.regist.name);
	      regist_port (&msg_buf);
	      break;

	    case UNREGIST_PORT:
	      /*
	       * åХåե ID 
	       */
	      unregist_port (&msg_buf);
	      break;

	    case FIND_PORT:
	      /*
	       * åХåե ID θ
	       */
	      find_port (&msg_buf);
	      break;
	    }
	}
      /* NOT REACHED */
    }
}

/*
 * åХåե ID ϿԤ
 *
 */
void
regist_port (struct port_manager_msg_t *msgp)
{
  PORT_MANAGER_ERROR errno;

  /*
   * ǡ١Ͽ
   */
  errno = regist_database (msgp->body.regist.name,
			   msgp->body.regist.port,
			   msgp->body.regist.task);

#ifdef DEBUG  
  dbg_printf ("port-server: regist_port: <%s>\n", msgp->body.regist.name);
#endif /* DEBUG */

  /*
   * ׵긵Фå롣
   * ˽λȤåäƤΤǡ
   * 2̤¸ߤ롣
   */
  if (errno == E_PORT_OK)
    {
      /*
       * ˽λå
       */
      recv_port_manager (msgp->hdr.rport,
			 errno, 
			 msgp->body.regist.port);
    }
  else
    {
      /*
       * ˽ʤäå
       * åΤåХåե ID ˤĤƤ
       * ǤʤäΤǡ0 ֤
       */
      recv_port_manager (msgp->hdr.rport, errno, 0);
    }
}



/*
 * åХåե ID ϿýԤ
 *
 */
void
unregist_port (struct port_manager_msg_t *msgp)
{
  PORT_MANAGER_ERROR	errno;
  ID		     	port;

  /*
   * ǡ١롣
   */
  errno = unregist_database (msgp->body.unregist.name,
			     &port,
			     msgp->body.unregist.task);

  /*
   * Ͽä׵ᤷå֤
   */
  if (errno != E_PORT_OK)
    {
      /*
       * ˽λå
       */
      recv_port_manager (msgp->hdr.rport,
			 errno, 
			 port);
    }
  else
    {
      /*
       * ǡ١饨ȥǤʤä
       * 顼å롣
       * 顼ֹʳƤϤ٤ 0 ֤
       */
      recv_port_manager (msgp->hdr.rport, errno, 0);
    }
}

/*
 * åХåե ID θ
 * 
 *
 */
void
find_port (struct port_manager_msg_t *msgp)
{
  PORT_MANAGER_ERROR	errno;
  ID		     	port;

  /*
   * ǡ١򸡺롣
   */
  errno = find_database (msgp->body.find.name, &port);

  /*
   * ǥХåʸǡ١θ
   */
#ifdef DEBUG
  dbg_printf ("port-manager: find_port: errno = %d, port = %d\n", errno, port);
#endif /* DEBUG */

  /*
   * åХåե ID ׵ᤷå֤
   */
  if (errno == E_PORT_OK)
    {
      /*
       * ˽λå
       * ݡֹȤơfind_database() ȯåХåե 
       * ID ֤
       */
      recv_port_manager (msgp->hdr.rport,
			 errno, 
			 port);
    }
  else
    {
      /*
       * ǡ١饨ȥǤʤä
       * 顼å롣
       * 顼ֹʳƤϤ٤ 0 ֤
       */
      recv_port_manager (msgp->hdr.rport, errno, 0);
    }
}


/*
 * ݡȥޥ͡Ф׵äФå֤
 */
static void
recv_port_manager (ID rport, PORT_MANAGER_ERROR errno, ID port)
{
  /*
   * åƤΰ衣
   * ¤ port_recv_port_message_t ˤäƹ¤ꤹ롣
   */
  struct recv_port_message_t	recv_msg;

  /*
   * åȤΩ
   */
  recv_msg.error = errno;	/* 顼ֹ */
  recv_msg.port  = port;	/* åХåե ID  */

  /*
   * å׵ḵ롣
   * ΤȤsnd_mbf() ƥॳΥ顼̵뤷Ƥ롣
   */
  snd_mbf (rport, sizeof (recv_msg), &recv_msg);
}

