/*
**  bif3_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3/A, as mechanically as possible.
*/


#if !defined BIF3_A_H
#define BIF3_A_H


#include "bifu_i.h"


extern definition_header_s hLATEST;

extern definition_header_s hLFA;	/* Convert header address to LFA. */
extern void LFA(void);

extern definition_header_s hIMFA;	/* Convert header address to IMFA. */
extern void IMFA(void);

extern definition_header_s hLMFA;	/* Convert header address to LMFA. */
extern void LMFA(void);

extern definition_header_s hCFA;	/* Convert header address to CFA. */
extern void CFA(void);

extern definition_header_s hGFA;	/* Convert header address to GFA. */
extern void GFA(void);

extern definition_header_s hPFA;	/* Convert header address to PFA. */
extern void PFA(void);

extern definition_header_s hNFA;	/* Convert PFA to header address. */
extern void NFA(void);

extern definition_header_s hSTOCSP;
extern void STOCSP(void);

extern definition_header_s hHEX;
extern void HEX(void);

extern definition_header_s hDEC;
extern void DEC(void);

extern definition_header_s hOCT;
extern void OCT(void);

extern definition_header_s hFILL;
extern void FILL(void);

extern definition_header_s hERASE;
extern void ERASE(void);

extern definition_header_s hBLANKS;
extern void BLANKS(void);

extern definition_header_s hHOLD;
extern void HOLD(void);

extern definition_header_s hPAD;

extern definition_header_s hSTOD;
extern void STOD(void);

extern definition_header_s hDTOS;
extern void DTOS(void);

extern definition_header_s hCHS;
extern void CHS(void);

extern definition_header_s hDCHS;
extern void DCHS(void);

extern definition_header_s hABS;
extern void ABS(void);

extern definition_header_s hDABS;
extern void DABS(void);

extern definition_header_s hMIN;
extern void MIN(void);

extern definition_header_s hMAX;
extern void MAX(void);

extern definition_header_s hLBRAK;
extern void LBRAK(void);

extern definition_header_s hRBRAK;
extern void RBRAK(void);


#define toggleDefinitionState( bit )	( UP.task->lastDefined.integer ^= (bit) )
extern definition_header_s hIMMED;
extern void IMMED(void);

extern definition_header_s hSMUDGE;
extern void SMUDGE(void);

extern definition_header_s hCOMPO;
extern void COMPO(void);

extern definition_header_s hCOUNT;
extern void COUNT(void);

extern definition_header_s hDTRAIL;
extern void DTRAIL(void);

extern definition_header_s hXMACH;
extern void XMACH(void);


#endif /* !defined BIF3_A_H */
