/* Convert Color Computer 32 column screens to terminated lines.
// Written by Joel Rees, Takino, Hyogo, Japan, May 1997.
// Assigned to the public domain.
// Since it is in the public domain, it can't be copyrighted. 
// If you borrow this code directly, 
// please note the source and the fact that it is public domain in your source code comments.
//
// Current e-mail (January 2000): joel_rees@sannet.ne.jp, reiisi@nettaxi.com
*/

#include <stdio.h>
#include <stdlib.h>	/* for EXIT_SUCCESS */
#include <ctype.h>
#include <string.h>
/* It's Mac OS X, now.
#include <console.h>
*/


#define ScreenWidth 32
#define ScreenHeight 32
#define BufferWidth ( ScreenWidth + 1 )	/* room for NUL */


#if defined NOT_USED
typedef char * errorMessage_t;
char * newErrorMessage( char * text )
{	size_t length = strlen( text ) + 1;
	char * temp = malloc( length );
	if ( temp != NULL )
		memcpy( temp, text, length );
	return temp;
}

typedef errorMessage_t errorMessageSet_t[ ScreenHeight ];
typedef struct errorMessageList_s
{	struct errorMessageList_s * next;
	errorMessageSet_t list;
} errorMessageList_s;

errorMessageList_s * emptyMessageList( void )
{	errorMessageList_s * temp = malloc( sizeof (errorMessageList_s) );
	int i;
	temp->next = NULL;
	for ( i = 0; i < ScreenHeight; ++i )
	{	temp->list[ i ] = NULL;
	}
	return temp;
}

void freeErrorMessageList( errorMessageList_s * list )
{	int i;
	for ( i = 0; i < ScreenHeight; ++i )
	{	if ( list->list != NULL )
		{	free( list->list[ i ] );
		}
	}
	free( list );
}
#endif /* defined NOT_USED */


#define MessageScreenCount 2
char messages[ ScreenHeight * MessageScreenCount ][ BufferWidth ] = { NULL };


int main(int argc, char * argv[] )
{
	char buffer[ ScreenHeight ][ BufferWidth ];
	FILE * input = stdin;
	int lineNumberFlag = 0;
	int errorMessageFlag = 0;
	int errorMessageBase = -1;

	/* Use the pseudo-command-line as simple file interface
	// argc = ccommand( &argv ); 
	*/
	if ( argc > 1 )
	{	int arg;
		for ( arg = 1; arg < argc; ++arg )
		{	if ( ( argc == 2 ) || ( ( strcmp( argv[ arg ], "-f" ) == 0 ) && ( ++arg < argc ) ) )
			{	input = fopen( argv[ arg ], "rb" );
				if ( input == NULL )
				{	fprintf( stderr, "Failed to open %s\n", argv[ arg ] );
					return EXIT_FAILURE;
				}
			}
			else if ( strcmp( argv[ arg ], "-n" ) == 0 )
			{	lineNumberFlag = 1;
			}
			/* else if ( ( strcmp( argv[ arg ], "-e" ) == 0 ) && ( ++arg < argc ) )
			{
			} 
			*/
			else
			{	fprintf( stderr, "Unknown option #%d: %s\n", arg, argv[ arg ] );
			}
		}
	}

	while ( !feof( input ) )
	{	int lineCount;
		for ( lineCount = 0; lineCount < ScreenHeight && !feof( input ); ++lineCount )
		{	int length = fread( buffer[ lineCount ], sizeof (char), ScreenWidth, input );
			while ( --length >= 0 
					&& ( isspace( buffer[ lineCount ][ length ] ) 
						 || !isprint( buffer[ lineCount ][ length ] ) ) )
				/* "empty" loop */;
			buffer[ lineCount ][ ++length ] = '\0';
		}
		if ( lineCount > 1 
			 || ( lineCount == 1 && buffer[ 0 ][ 0 ] != '\0' ) )
		{	int line;
			while ( --lineCount > 0 && buffer[ lineCount ][ 0 ] == '\0' )
				/* "empty" loop */;
			errorMessageFlag = ( strstr( buffer[ 0 ], " ERROR MESSAGES )" ) != NULL );
			if ( errorMessageFlag ) 
			{	++errorMessageBase;
				/* printf( "error message base now %d\n", errorMessageBase ); */
			}
			for ( line = 0; line <= lineCount; ++line )
			{	if ( lineNumberFlag )
					printf( "%2d: ", line );
				puts( buffer[ line ] );
				if ( errorMessageFlag && ( line > 0 ) )
				{	if ( errorMessageBase >= MessageScreenCount )
					{	printf( "failed to record: %s\n", buffer[ line ] );
					}
					else
					{	memcpy( messages[ errorMessageBase * ScreenHeight + line ], buffer[ line ], BufferWidth );
					}
					/* printf( "#define MSG%02x\t\"%s\"\n", errorMessageBase * ScreenHeight + line, buffer[ line ] ); */
				}
			}
			putchar( '\f' );
		}
	}
	if ( errorMessageBase > -1 )
	{	int i;
		fputs( "char * errorMessages[] = \n{", stdout );
		for ( i = 0; i < MessageScreenCount * ScreenHeight; ++i )
		{	if ( i > 0 )
			{	putchar( ',' );	putchar( '\n' );
			}
			printf( "\t\"%s\"", messages[ i ] );
		}
		fputs( "\n};\n", stdout );
	}
	if ( errorMessageBase > -1 )
	{	int i;
		for ( i = 0; i < MessageScreenCount * ScreenHeight; ++i )
		{	int j;
			if ( !isalnum( messages[ i ][ 0 ] ) )
				continue;
			for ( j = 0; j < ScreenWidth; ++j )
			{	if ( messages[ i ][ j ] == '\0' )
					break;
				if ( !isalnum( messages[ i ][ j ] ) )
				{	messages[ i ][ j ] = '_';
				}
			}
			printf( "#define\t%s\t0x%x\n", messages[ i ], i );
		}
		fputs( "\n};\n", stdout );
	}

	return EXIT_SUCCESS;
}

