/*
**  bif2_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/25.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF2/A, as mechanically as possible.
*/


#if !defined BIF2_A_H
#define BIF2_A_H


#include "bifu_i.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC '1+'
01010 	FCB 2
01020 	FCB MFORE
01030 	FDB SWAN-CFAOFF
01040 	FDB BIF+2
01050 	FDB ZLESS-CFAOFF
01060 	FDB ADD2-CFAOFF
*/
extern definition_header_s hADD1;
extern void ADD1(void);
/*
01070 ADD1	LDD #1
01080 	ADDTOP
01110 *
01120 	FCC '1-'
01130 	FCB 2
01140 	FCB MFORE
01150 	FDB ADD1-CFAOFF
01160 	FDB BIF+2
01170 	FDB 0
01180 	FDB 0
*/
extern definition_header_s hSUB1;
extern void SUB1(void);
/*
01190 SUB1	LDD #-1
01200 	ADDTOP
01230 *
01240 	FCC '2+'
01250 	FCB 2
01260 	FCB MFORE
01270 	FDB SUB1-CFAOFF
01280 	FDB BIF+2
01290 	FDB TWO-CFAOFF
01300 	FDB RSHIFT-CFAOFF
*/
extern definition_header_s hADD2;
extern void ADD2(void);
/*
01310 ADD2	LDD #2
01320 	ADDTOP
01330 *
01340 	FCC '2-'
01350 	FCB 2
01360 	FCB MFORE
01370 	FDB ADD2-CFAOFF
01380 	FDB BIF+2
01390 	FDB 0
01400 	FDB 0
*/
extern definition_header_s hSUB2;
extern void SUB2(void);
/*
01410 SUB2	LDD #-2
01420 	ADDTOP
01430 *
01440 	FCC '0'
01450 	FCB 1
01460 	FCB MFORE
01470 	FDB SUB2-CFAOFF
01480 	FDB BIF+2
01490 	FDB SLAMOD-CFAOFF
01500 	FDB INULL-CFAOFF
*/
extern definition_header_s hZERO;
/*
01510 ZERO	LDD #0
01520 	PSHU D
01530 	NEXT
01540 *
01550 	FCC '1'
01560 	FCB 1
01570 	FCB MFORE
01580 	FDB ZERO-CFAOFF
01590 	FDB BIF+2
01600 	FDB ZBR-CFAOFF
01610 	FDB 0
*/
extern definition_header_s hONE;
/*
01620 ONE	LDD #1
01630 	PSHU D
01640 	NEXT
01650 *
01660 	FCC '-1'
01670 	FCB 2
01680 	FCB MFORE
01690 	FDB ONE-CFAOFF
01700 	FDB BIF+2
01710 	FDB 0
01720 	FDB DDFIND-CFAOFF
*/
extern definition_header_s hMONE;
/*
01730 MONE	LDD #-1
01740 	PSHU D
01750 	NEXT
01760 *
01770 	FCC '2'
01780 	FCB 1
01790 	FCB MFORE
01800 	FDB MONE-CFAOFF
01810 	FDB BIF+2
01820 	FDB ONEARR-CFAOFF
01830 	FDB LSHIFT-CFAOFF
*/
extern definition_header_s hTWO;
/*
01840 TWO	DOCON
01850 	FDB 2
01860 *
01870 	FCC '3'
01880 	FCB 1
01890 	FCB MFORE
01895 	FDB TWO-CFAOFF
01900 	FDB BIF+2
01910 	FDB 0
01920 	FDB 0
*/
extern definition_header_s hTHREE;
/*
01930 THREE	DOCON
01940 	FDB 3
01950 *
01960 	FCC 'BL'
01970 	FCB 2
01980 	FCB MFORE
01990 	FDB THREE-CFAOFF
02000 	FDB BIF+2
02010 	FDB 0
02020 	FDB 0
*/
extern definition_header_s hDBLSZ;

extern definition_header_s hCELLSZ;

extern definition_header_s hBL;
/*
02030 BL	DOCON
02040 	FDB $20 ascii SP
02050 *
02060 	FCC 'C/L'
02070 	FCB 3
02080 	FCB MFORE
02090 	FDB BL-CFAOFF
02100 	FDB BIF+2
02110 	FDB 0
02120 	FDB 0
*/
extern definition_header_s hCPERL;
/*
02130 CPERL	DOUCON
02140 	FCB UCOLUM
02170 *
02180 	FCC 'FIRST'
02190 	FCB 5
02200 	FCB MFORE
02210 	FDB CPERL-CFAOFF
02220 	FDB BIF+2
02230 	FDB 0
02240 	FDB FLD-CFAOFF
*/
extern definition_header_s hFIRST;
/*
02250 FIRST	DOUCON
02260 	FCB UFIRST
02290 *
02300 	FCC 'LIMIT'
02310 	FCB 5
02320 	FCB MFORE
02330 	FDB FIRST-CFAOFF
02340 	FDB BIF+2
02350 	FDB LEAVE-CFAOFF
02360 	FDB LITER-CFAOFF
*/
extern definition_header_s hLIMIT;
/*
02370 LIMIT	DOUCON
02380 	FCB ULIMIT
02400 *
*/
#define BWID 256	/* Must be a multiple of sizeof (cell_u): 2^n bytes, n > 2. */
/*
02410 BWID	EQU 256 bytes
02420 	FCC 'B/BUF'
02430 	FCB 5
02440 	FCB MFORE
02450 	FDB LIMIT-CFAOFF
02460 	FDB BIF+2
02470 	FDB ASMBLR-CFAOFF
02480 	FDB BPSCR-CFAOFF
*/
extern definition_header_s hBPBUF;
/*
02490 BPBUF	DOCON
02500 	FDB BWID
02510 *
*/
#define BCT 4
/*
02520 BCT	EQU 4 buffers
02520 	FCC 'B/SCR'
02530 	FCB 5
02540 	FCB MFORE
02550 	FDB BPBUF-CFAOFF
02560 	FDB BIF+2
02570 	FDB 0
02580 	FDB 0
*/
extern definition_header_s hBPSCR;
/*
02590 BPSCR	DOCON
02600 	FDB BCT
02610 *
02620 	FCC '+ORIGIN'
02630 	FCB 7
02640 	FCB MFORE
02650 	FDB BPSCR-CFAOFF
02660 	FDB BIF+2
02670 	FDB 0
02680 	FDB 0
*/
extern definition_header_s hPORIG;
extern void PORIG(void);
/*
02690 PORIG	LDD #ORIG
02700 	LBRA ADD+2
02710 *
02715 * some USER vars hidden
02720 * fig-FORTH USER vars not present:
02722 * WIDTH VOC-LINK CONTEXT CURRENT
02724 *
02730 	FCC 'TIB'
02740 	FCB 3
02750 	FCB MFORE
02760 	FDB PORIG-CFAOFF
02770 	FDB BIF+2
02780 	FDB 0
02790 	FDB 0
*/
extern definition_header_s hTIB;
/*
02800 TIB	DOUSER
02810 	FCB UTIB
02820 *
02930 	FCC 'WARNING'
02940 	FCB 7
02950 	FCB MFORE
02960 	FDB TIB-CFAOFF
02970 	FDB BIF+2
02980 	FDB 0
02990 	FDB 0
*/
extern definition_header_s hWARN;
/*
03000 WARN	DOUSER
03010 	FCB UWARN
03020 *
03030 	FCC 'FENCE'
03040 	FCB 5
03050 	FCB MFORE
03060 	FDB WARN-CFAOFF
03070 	FDB BIF+2
03080 	FDB 0
03090 	FDB 0
*/
extern definition_header_s hFENCE;
/*
03100 FENCE	DOUSER
03110 	FCB UFENCE
03120 *
03130 	FCC 'DP'
03140 	FCB 2
03150 	FCB MFORE
03160 	FDB FENCE-CFAOFF
03170 	FDB BIF+2
03180 	FDB DOES-CFAOFF
03190 	FDB 0
*/
extern definition_header_s hDPC;
/*
03200 DPC	DOUSER
03210 	FCB UDP
03220 *
03230 	FCC 'ROOT'
03240 	FCB 4
03250 	FCB MFORE
03260 	FDB DPC-CFAOFF
03270 	FDB BIF+2
03280 	FDB 0
03290 	FDB 0
*/
extern definition_header_s hROOT;
/*
03300 ROOT	DOUSER	not fig
03310 	FCB UROOT
03320 *
03330 	FCC 'BLK'
03340 	FCB 3
03350 	FCB MFORE
03360 	FDB ROOT-CFAOFF
03370 	FDB BIF+2
03380 	FDB BLANKS-CFAOFF
03390 	FDB BLOCK-CFAOFF
*/
extern definition_header_s hBLK;
/*
03400 BLK	DOUSER
03410 	FCB UBLK
03420 *
03430 	FCC 'IN'
03440 	FCB 2
03450 	FCB MFORE
03460 	FDB BLK-CFAOFF
03470 	FDB BIF+2
03480 	FDB IMMED-CFAOFF
03490 	FDB INTERP-CFAOFF
*/
extern definition_header_s hIN;
/*
03500 IN	DOUSER
03510 	FCB UIN
03520 *
03530 	FCC 'OUT'
03540 	FCB 3
03550 	FCB MFORE
03560 	FDB IN-CFAOFF
03570 	FDB BIF+2
03580 	FDB 0
03590 	FDB 0
*/
extern definition_header_s hOUT;
/*
03600 OUT	DOUSER
03610 	FCB UOUT
03620 *
03630 	FCC 'SCR'
03640 	FCB 3
03650 	FCB MFORE
03660 	FDB OUT-CFAOFF
03670 	FDB BIF+2
03680 	FDB 0
03690 	FDB 0
*/
extern definition_header_s hSCR;
/*
03700 SCR	DOUSER
03710 	FCB USCR
03720 *
03730 	FCC 'OFFSET'
03740 	FCB 6
03750 	FCB MFORE
03760 	FDB SCR-CFAOFF
03770 	FDB BIF+2
03780 	FDB 0
03790 	FDB 0
*/
extern definition_header_s hOFFSET;
/*
03800 OFFSET	DOUSER
03810 	FCB UOFFS
03820 *
03830 	FCC 'STATE'
03840 	FCB 5
03850 	FCB MFORE
03860 	FDB OFFSET-CFAOFF
03870 	FDB BIF+2
03880 	FDB SPACES-CFAOFF
03890 	FDB SWAB-CFAOFF
*/
extern definition_header_s hSTATE;
/*
03900 STATE	DOUSER
03910 	FCB USTATE
03920 *
03930 	FCC 'BASE'
03940 	FCB 4
03950 	FCB MFORE
03960 	FDB STATE-CFAOFF
03970 	FDB BIF+2
03980 	FDB 0
03990 	FDB 0
*/
extern definition_header_s hBASE;
/*
04000 BASE	DOUSER
04010 	FCB UBASE
04020 *
04030 	FCC 'DPL'
04040 	FCB 3
04050 	FCB MFORE
04060 	FDB BASE-CFAOFF
04070 	FDB BIF+2
04080 	FDB DPC-CFAOFF
04090 	FDB DROFFS-CFAOFF
*/
extern definition_header_s hDPL;
/*
04100 DPL	DOUSER
04110 	FCB UDPL
04120 *
04130 	FCC 'FLD'
04140 	FCB 3
04150 	FCB MFORE
04160 	FDB DPL-CFAOFF
04170 	FDB BIF+2
04180 	FDB 0
04190 	FDB 0
*/
extern definition_header_s hFLD;
/*
04200 FLD	DOUSER
04210 	FCB UFLD
04220 *
04230 	FCC 'CSP'
04240 	FCB 3
04250 	FCB MFORE
04260 	FDB FLD-CFAOFF
04270 	FDB BIF+2
04280 	FDB 0
04290 	FDB CURR-CFAOFF
*/
extern definition_header_s hCSP;
/*
04300 CSP	DOUSER
04310 	FCB UCSP
04320 *
04330 	FCC 'R#'
04340 	FCB 2
04350 	FCB MFORE
04360 	FDB CSP-CFAOFF
04370 	FDB BIF+2
04380 	FDB 0
04390 	FDB RW-CFAOFF
*/
extern definition_header_s hRNUM;
/*
04400 RNUM	DOUSER
04410 	FCB URNUM
04420 *
04430 	FCC 'HLD'
04440 	FCB 3
04450 	FCB MFORE
04460 	FDB RNUM-CFAOFF
04470 	FDB BIF+2
04480 	FDB HEX-CFAOFF
04490 	FDB HOLD-CFAOFF
*/
extern definition_header_s hHLD;
/*
04500 HLD	DOUSER
04510 	FCB UHLD
04520 *
04530 	FCC 'FOREWARD'
04540 	FCB 8
04550 	FCB MFORE
04560 	FDB HLD-CFAOFF
04570 	FDB BIF+2
04580 	FDB 0
04590 	FDB 0
*/
extern definition_header_s hFORE;
/*
04600 FORE	DOUSER	not fig
04610 	FCB UFORE
04620 *
04630 	FCC 'CURRENT'
04640 	FCB 7
04650 	FCB MFORE
04660 	FDB FORE-CFAOFF
04670 	FDB BIF+2
04680 	FDB 0
04690 	FDB 0
*/
extern definition_header_s hCURR;
/*
04700 CURR	DOUSER	not fig
04710 	FCB UCURR
04720 *
04730 	FCC 'PREV'
04740 	FCB 4
04750 	FCB MFORE
04760 	FDB CURR-CFAOFF
04770 	FDB BIF+2
04780 	FDB 0
04790 	FDB 0
*/
extern definition_header_s hPREV;
/*
04800 PREV	DOUSER	moved
04810 	FCB UPREV
04820 *
04830 	FCC 'USE'
04840 	FCB 3
04850 	FCB MFORE
04860 	FDB PREV-CFAOFF
04870 	FDB BIF+2
04880 	FDB 0
04890 	FDB 0
*/
extern definition_header_s hUSE;
/*
04900 USE	DOUSER	moved
04910 	FCB UUSE
04920 *
04930 	FCC 'DROOT'
04940 	FCB 5
04950 	FCB MFORE
04960 	FDB USE-CFAOFF
04970 	FDB BIF+2
04980 	FDB 0
04990 	FDB 0
*/
extern definition_header_s hDROOT;
/*
05000 DROOT	DOUSER	not fig
05010 	FCB UDROOT
05020 *
*/


#endif /* !defined BIF2_A_H */
