/*
**  bif2b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/03.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF2B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif_eval.h"	/* For STORE() */
#include "bif2_a.h"	/* For TWO() */
#include "bif5b_a.h"	/* For ERROR() */
#include "bif2b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
05030 	FCC 'HERE'
05040 	FCB 4
05050 	FCB MFORE
05060 	FDB DROOT-CFAOFF
05070 	FDB BIF+2
05080 	FDB FOREMK-CFAOFF
05090 	FDB I-CFAOFF
*/
static character_t sHERE[] = "\x4" "HERE";
definition_header_s hHERE =	
{	{ (natural_t) sHERE },
	{ 0 },
	{ (natural_t) &hDROOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hFOREMK },
	{ (natural_t) &hI },
	{ (natural_t) HERE }
};
/*
05100 HERE	LDX <UP
05110 	LDD UDP,X
05120 	PSHU D
05122 HERERR	LDX <UP
05124 	CMPU UDP,X
05128 	BLS ALLERR
05130 	NEXT
05132 ALLERR	LDD #2
05134 	PSHU D
05136 	JMP ERROR
05140 *
** HERERR and ALLERR are converted to macros.
*/
void HERE(void)
{	* --SP = UP.task->dictionaryAllocationPointer;
	HERERR;
}


/*
05150 	FCC 'ALLOT'
05160 	FCB 5
05170 	FCB MFORE
05180 	FDB HERE-CFAOFF
05190 	FDB BIF+2
05200 	FDB AGAIN-CFAOFF
05210 	FDB 0
*/
static character_t sALLOT[] = "\x5" "ALLOT";
definition_header_s hALLOT =	
{	{ (natural_t) sALLOT },
	{ 0 },
	{ (natural_t) &hHERE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hAGAIN },
	{ 0 },
	{ (natural_t) ALLOT }
};
/*
05220 ALLOT	LDX <UP
05222 	LDD UDP,X
05223 	BMI ALLERR
05224 	ADDD ,U++
05226 	STD UDP,X
05228 	BRA HERERR
05230 *
*/
void ALLOT(void)
{	/* We don't have ROM in the high half of memory, 
	// so testing the high bit (sign) of DP would be wrong. 
	// Or would it? Trying to allocate negative, or more than 2 G?
	// That should be picked up in HERERR, anyway, 
	// but does it make sense to check separately here for real nonsense?
	*/
	UP.task->dictionaryAllocationPointer.bytep += ( * SP++ ).integer;
	HERERR;
}


/*
05238 	FCC ','
05240 	FCB 1
05250 	FCB MFORE
05260 	FDB ALLOT-CFAOFF
05270 	FDB BIF+2
05280 	FDB PORIG-CFAOFF
05290 	FDB SUB-CFAOFF
*/
static character_t sCOMMA[] = "\x1" ",";
definition_header_s hCOMMA =	
{	{ (natural_t) sCOMMA },
	{ 0 },
	{ (natural_t) &hALLOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hPORIG },
	{ (natural_t) &hSUB },
	{ (natural_t) COMMA }
	/* Can't call TWO as a C function unless I provide it separately from the FORTH function.
	// I guess I could go to the extra work? 
	// It might solve the problem of switching modes on the fly. 
	// But it would also impose alternate entry points, which is always an invitation to trouble.
	{ (natural_t) XCOL },
	{	{ (natural_t) &hHERE }, 
		{ (natural_t) &hTWO }, 
		{ (natural_t) &hALLOT }, 
		{ (natural_t) &hSTORE }
		// But then, what about HERERR?
		// -- thus, the other side of the switching modes on the fly issue.
	}
	*/
};
/*
05300 COMMA	PULU D allocate and store
05310 	PSHS Y
05320 	LDY <UP
05330 	LDX UDP,Y
05340 	STD ,X++
05350 COMSTO	STX UDP,Y
05360 	PULS Y
05375 	BRA HERERR
05380 *
*/
void COMMA(void)	/* Needs to be refactored, and needs to check first. */
{	cell_u * here = UP.task->dictionaryAllocationPointer.cellp;
	* here++ = * SP++;
	UP.task->dictionaryAllocationPointer.cellp = here;	/* COMSTO is actually HERE_UPDATE */
	/* Updating HERE is done out of order. Race condition. */
	HERERR; 
}


static character_t sDCOMMA[] = "\x2" "D,";
definition_header_s hDCOMMA =	
{	{ (natural_t) sDCOMMA },
	{ 0 },
	{ (natural_t) &hCOMMA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DCOMMA }
};
/*
05300 COMMA	PULU D allocate and store
05310 	PSHS Y
05320 	LDY <UP
05330 	LDX UDP,Y
05340 	STD ,X++
05350 COMSTO	STX UDP,Y
05360 	PULS Y
05375 	BRA HERERR
05380 *
*/
void DCOMMA(void)	/* Needs to be refactored, and needs to check first. */
{	dblnatural_t * here = UP.task->dictionaryAllocationPointer.doublep;
	dblnatural_t * stack = (dblnatural_t *) ( (char *) SP );
	* here++ = * stack++;
	SP = (cell_u *) ( (char *) stack );
	UP.task->dictionaryAllocationPointer.doublep = here;
	/* Updating HERE is done out of order. Race condition. */
	HERERR; 
}


/*
05390 	FCC 'C,'
05400 	FCB 2
05410 	FCB MFORE
05420 	FDB COMMA-CFAOFF
05430 	FDB BIF+2
05440 	FDB CSTO-CFAOFF
05450 	FDB CPERL-CFAOFF
*/
static character_t sCCOMMA[] = "\x2" "C,";
definition_header_s hCCOMMA = 
{	{ (natural_t) sCCOMMA },
	{ 0 },
	{ (natural_t) &hDCOMMA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCSTO },
	{ (natural_t) &hCPERL },
	{ (natural_t) CCOMMA }
};
/*
05460 CCOMMA	PULU D
05470 	PSHS Y
05480 	LDY <UP
05490 	LDX UDP,Y
05500 	STB ,X+
05510 	BRA COMSTO
05520 *
*/
void CCOMMA( void )	/* C, needs a FILL2BOUND and something to deal with length slop. Instead, STRING, perhaps? */
{
	byte_t * here = UP.task->dictionaryAllocationPointer.bytep;
	* here++ = (byte_t) SP[ 0 ].integer;
	UP.task->dictionaryAllocationPointer.bytep = here;	/* Seems meaningless to make this wrong code a macro. */
	++SP;
	HERERR; 
}


static character_t sOCOMMA[] = "\x4" "ODD,";
definition_header_s hOCOMMA = 
{	{ (natural_t) sOCOMMA },
	{ 0 },
	{ (natural_t) &hCCOMMA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) OCOMMA }
};
void OCOMMA( void )	/* Well, this is the FILL2BOUND. */
{
	byte_t * here = UP.task->dictionaryAllocationPointer.bytep;
	while ( ( ( (natural_t) here ) & ( sizeof (cell_u) - 1 ) ) != 0 )
		* here++ = (byte_t) 0;
	UP.task->dictionaryAllocationPointer.bytep = here;	/* Seems meaningless to make this wrong code a macro. */
	HERERR; 
}


/*
05530 	FCC 'SPACE'
05540 	FCB 5
05550 	FCB MFORE
05560 	FDB CCOMMA-CFAOFF
05570 	FDB BIF+2
05580 	FDB SPFEH-CFAOFF
05590 	FDB STATE-CFAOFF
*/
static character_t sSPACE[] = "\x5" "SPACE";
definition_header_s hSPACE = 
{	{ (natural_t) sSPACE },
	{ 0 },
	{ (natural_t) &hOCOMMA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSPFEH },
	{ (natural_t) &hSTATE },
	{ (natural_t) SPACE }
/*	{ (natural_t) XCOL },
	{	{ (natural_t) &hBL	},
		{ (natural_t) &hEMIT	},
		{ (natural_t) &hSEMIS	}
	}
*/
};
/*
05600 SPACE	LDB BL+3,PCR
05610 	LBRA EMIT+2
05620 *
*/
void SPACE( void )
{	( * --SP ) = hBL.parameterLink[ 0 ];
	EMIT();
}


/*
05630 	FCC '-DUP'
05640 	FCB 4
05650 	FCB MFORE
05660 	FDB SPACE-CFAOFF
05670 	FDB BIF+2
05680 	FDB MONE-CFAOFF
05690 	FDB DTRAIL-CFAOFF
*/
static character_t sDDUP[] = "\x4" "-DUP";
definition_header_s hDDUP = 
{	{ (natural_t) sDDUP },
	{ 0 },
	{ (natural_t) &hSPACE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hMONE },
	{ (natural_t) &hDTRAIL },
	{ (natural_t) DDUP }
};
/*
05700 DDUP	LDD ,U
05710 	BEQ *+4
05720 	PSHU D
05730 	NEXT
05740 *
*/
void DDUP( void )
{	if (  SP[ 0 ].integer )
	{	--SP;
		SP[ 0 ] = SP[ 1 ];
	}
}


/*
05750 	FCC '?CST'
05760 	FCB 4
05770 	FCB MFORE
05780 	FDB DDUP-CFAOFF
05790 	FDB BIF+2
05800 	FDB QCSP-CFAOFF
05810 	FDB QERR-CFAOFF
*/
static character_t sQCST[] = "\x4" "?CST";
definition_header_s hQCST = 
{	{ (natural_t) sQCST },
	{ 0 },
	{ (natural_t) &hDDUP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hQCSP },
	{ (natural_t) &hQERR },
	{ (natural_t) QCST }
};
/*
05820 QCST	LDX <UP
05830 	LDB USTATE+1,X
05840 	ANDB #SCOMP
05850 	CLRA
05860 	PSHU D
05870 	NEXT
05890 *
*/
void QCST( void )
{	( * --SP ).integer = UP.task->compilerState.integer & SCOMP;
}


/*
05900 	FCC 'IF'
05910 	FCB MIMM.OR.MCOMP.OR.2
05920 	FCB MFORE
05930 	FDB QCST-CFAOFF
05940 	FDB BIF+2
05950 	FDB DO-CFAOFF
05960 	FDB QUERY-CFAOFF
05965 * IF see fig-FORTH model
*/
static character_t sIF[] = "\x2" "IF";
definition_header_s hIF = 
{	{ (natural_t) sIF },
	{ MIMM | MCOMP },
	{ (natural_t) &hQCST },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDO },
	{ (natural_t) &hQUERY },
	{ (natural_t) XCOL },
/*
05970 IF	DOCOL
05980 	FDB COMP
05990 	FDB ZBR
06000 	FDB HERE adr
06010 	FDB ZERO
06020 	FDB COMMA
06030 	FDB LIT
06040 	FDB ('I)*256+'F
06060 	FDB SEMIS
06090 *
*/
	{	{ (natural_t) &hCOMP	},
		{ (natural_t) &hZBR	},
		{ (natural_t) &hHERE	},	/* adr */
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hLIT	},
		{ IF_FLAG	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
06100 	FCC 'ELSE'
06110 	FCB MIMM.OR.MCOMP.OR.4
06120 	FCB MFORE
06130 	FDB IF-CFAOFF
06140 	FDB BIF+2
06150 	FDB EDITOR-CFAOFF
06160 	FDB 0
*/
static character_t sELSE[] = "\x4" "ELSE";
definition_header_s hELSE = 
{	{ (natural_t) sELSE },
	{ MIMM | MCOMP },
	{ (natural_t) &hIF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEDITOR },
	{ 0 },
	{ (natural_t) XCOL },
/*
06170 ELSE	DOCOL
06172 	FDB DUP
06173 	FDB LIT
06175 	FDB ('I)*256+'F
06178 	FDB QPAIRS
06180 	FDB COMP
06190 	FDB BRANCH
06200 	FDB HERE adr
06205 	FDB ZERO
06210 	FDB COMMA
06220 	FDB ROT
06230 	FDB FILLIN IF adr
06250 	FDB SWAP for ENDIF
06260 	FDB SEMIS
06290 *
*/
	{	{ (natural_t) &hDUP	},
		{ (natural_t) &hLIT	},
		{ IF_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hBRANCH	},
		{ (natural_t) &hHERE	},	/* adr */
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hROT	},
		{ (natural_t) &hFILLIN	},	/* IF adr */
		{ (natural_t) &hSWAP	},	/* for ENDIF */
		{ (natural_t) &hSEMIS	}
	}
};
/*
06300 	FCC 'ENDIF'
06310 	FCB MIMM.OR.MCOMP.OR.5
06320 	FCB MFORE
06330 	FDB ELSE-CFAOFF
06340 	FDB BIF+2
06350 	FDB DROP-CFAOFF
06360 	FDB FIND-CFAOFF
*/
static character_t sENDIF[] = "\x5" "ENDIF";
definition_header_s hENDIF = 
{	{ (natural_t) sENDIF },
	{ MIMM | MCOMP },
	{ (natural_t) &hELSE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDROP },
	{ (natural_t) &hFIND },
	{ (natural_t) XCOL },
/*
06370 ENDIF	DOCOL
06380 	FDB QCOMP
06390 	FDB LIT
06400 	FDB ('I)*256+'F
06410 	FDB QPAIRS
06420 	FDB FILLIN
06470 	FDB SEMIS
06490 *
*/
	{	{ (natural_t) &hQCOMP	},
		{ (natural_t) &hLIT	},
		{ IF_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hFILLIN	},
		{ (natural_t) &hSEMIS	}
	}
};
