/*
**  bif3_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif3_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC 'LATEST'
01010 	FCB 6
01020 	FCB MFORE
01030 	FDB ENDIF-CFAOFF
01040 	FDB BIF+2
01050 	FDB 0
01060 	FDB 0
*/
static character_t sLATEST[] = "\x6" "LATEST";
definition_header_s hLATEST = 
{	{ (natural_t) sLATEST },
	{ 0 },
	{ (natural_t) &hENDIF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUCON },
	{	{ UCURR }	}	/* NFA */
};
/*
01070 LATEST	DOUCON 	not ROOT!
01080 	FCB UCURR NFA
01110 *
*/


/*
01115 * convert NFA to LFA,CFA,GFA,PFA	// Need LMFA and IMFA, LEFTFA and RIGHTFA
01120 	FCC 'LFA'
01130 	FCB 3
01140 	FCB MFORE
01150 	FDB LATEST-CFAOFF
01160 	FDB BIF+2
01170 	FDB 0
01180 	FDB 0
*/
static character_t sLFA[] = "\x3" "LFA";
definition_header_s hLFA = 
{	{ (natural_t) sLFA },
	{ 0 },
	{ (natural_t) &hLATEST },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) LFA }
};
/*
01190 LFA	LDB #LFAOFF
01200 	BRA CFA+2
01210 *
*/
void LFA( void )
{	ADDTOP( LFAOFF );
}


static character_t sIMFA[] = "\x4" "IMFA";
definition_header_s hIMFA = 
{	{ (natural_t) sIMFA },
	{ 0 },
	{ (natural_t) &hLFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) IMFA }
};
void IMFA( void )
{	ADDTOP( IMFAOFF );
}


static character_t sLMFA[] = "\x4" "LMFA";
definition_header_s hLMFA = 
{	{ (natural_t) sLMFA },
	{ 0 },
	{ (natural_t) &hIMFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) LMFA }
};
void LMFA( void )
{	ADDTOP( LMFAOFF );
}


/*
01220 	FCC 'CFA'
01230 	FCB 3
01240 	FCB MFORE
01250 	FDB LFA-CFAOFF
01260 	FDB BIF+2
01270 	FDB 0
01280 	FDB 0
*/
static character_t sCFA[] = "\x3" "CFA";
definition_header_s hCFA = 
{	{ (natural_t) sCFA },
	{ 0 },
	{ (natural_t) &hLMFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCELLSZ },
	{ 0 },
	{ (natural_t) CFA }
};
/*
01290 CFA	LDB #CFAOFF
01292 	SEX		// Sign EXtend. Yeah, it was a bad pun, and might be the reason God cursed the 6809.
01294 	ADDD ,U
01296 	STD ,U
01300 	NEXT
01310 *
*/
void CFA( void )
{	ADDTOP( CFAOFF );
}


/*
01320 	FCC 'GFA'
01330 	FCB 3
01340 	FCB MFORE
01350 	FDB CFA-CFAOFF
01360 	FDB BIF+2
01370 	FDB 0
01380 	FDB 0
*/
static character_t sGFA[] = "\x3" "GFA";
definition_header_s hGFA = 
{	{ (natural_t) sGFA },
	{ 0 },
	{ (natural_t) &hCFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) GFA }
};
/*
01390 GFA	LDB #GFAOFF
01400 	BRA CFA+2
01410 *
*/
void GFA( void )
{	ADDTOP( GFAOFF);
}


/*
01420 	FCC 'PFA'
01430 	FCB 3
01440 	FCB MFORE
01450 	FDB GFA-CFAOFF
01460 	FDB BIF+2
01470 	FDB PAD-CFAOFF
01480 	FDB PREV-CFAOFF
*/
static character_t sPFA[] = "\x3" "PFA";
definition_header_s hPFA = 
{	{ (natural_t) sPFA },
	{ 0 },
	{ (natural_t) &hGFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hPAD },
	{ (natural_t) &hPREV },
	{ (natural_t) PFA }
};
/*
01490 PFA	LDB #PFAOFF
01500 	BRA CFA+2
01510 *
*/
void PFA( void )
{	ADDTOP( PFAOFF );
}


/*
01515 * PFA to NFA
01520 	FCC 'NFA'
01530 	FCB 3
01540 	FCB MFORE
01550 	FDB PFA-CFAOFF
01560 	FDB BIF+2
01570 	FDB NCOMMA-CFAOFF
01580 	FDB NOT-CFAOFF
*/
static character_t sNFA[] = "\x3" "NFA";
definition_header_s hNFA = 
{	{ (natural_t) sNFA },
	{ 0 },
	{ (natural_t) &hPFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hNCOMMA },
	{ (natural_t) &hNOT },
	{ (natural_t) NFA }
};
/*
01590 NFA	LDB #-PFAOFF
01600 	BRA CFA+2
01610 *
*/
void NFA( void )
{	ADDTOP( -PFAOFF );
}


/*
01620 	FCC '!CSP'
01630 	FCB 4
01640 	FCB MFORE
01650 	FDB NFA-CFAOFF
01660 	FDB BIF+2
01670 	FDB 0
01680 	FDB HASH-CFAOFF
*/
static character_t sSTOCSP[] = "\x4" "!CSP";
definition_header_s hSTOCSP = 
{	{ (natural_t) sSTOCSP },
	{ 0 },
	{ (natural_t) &hNFA },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hHASH },
	{ (natural_t) STOCSP }
};
/*
01690 STOCSP	LDX <UP
01700 	STU UCSP,X
01710 	NEXT
01720 *
*/
void STOCSP( void )
{	UP.task->compilerStackMarker.cellp = SP;
}


#define	SET_BASE( base )	UP.task->numericBase.integer = ( base )

/*
01730 	FCC 'HEX'
01740 	FCB 3
01750 	FCB MFORE
01760 	FDB STOCSP-CFAOFF
01770 	FDB BIF+2
01780 	FDB 0
01790 	FDB 0
*/
static character_t sHEX[] = "\x3" "HEX";
definition_header_s hHEX = 
{	{ (natural_t) sHEX },
	{ 0 },
	{ (natural_t) &hSTOCSP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) HEX }
};
/*
01800 HEX	LDB #16
01810 	CLRA
01820 	LDX <UP
01830 	STD UBASE,X
01840 	NEXT
01850 *
*/
void HEX( void )
{	SET_BASE( 16 );
}


/*
01860 	FCC 'DECIMAL'
01870 	FCB 7
01880 	FCB MFORE
01890 	FDB HEX-CFAOFF
01900 	FDB BIF+2
01910 	FDB DAD-CFAOFF
01920 	FDB DEFS-CFAOFF
*/
static character_t sDEC[] = "\x7" "DECIMAL";
definition_header_s hDEC = 
{	{ (natural_t) sDEC },
	{ 0 },
	{ (natural_t) &hHEX },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDAD },
	{ (natural_t) &hDEFS },
	{ (natural_t) DEC }
};
/*
01930 DEC	LDB #10
01940 	BRA HEX+2
01950 *
*/
void DEC( void )
{	SET_BASE( 10 );
}


/*
01960 	FCC 'OCTAL'
01970 	FCB 5
01980 	FCB MFORE
01990 	FDB DEC-CFAOFF
02000 	FDB BIF+2
02010 	FDB 0
02020 	FDB OFFSET-CFAOFF
*/
static character_t sOCT[] = "\x5" "OCTAL";
definition_header_s hOCT = 
{	{ (natural_t) sOCT },
	{ 0 },
	{ (natural_t) &hDEC },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hOFFSET },
	{ (natural_t) OCT }
};
/*
02030 OCT	LDB #8
02040 	BRA HEX+2
02050 *
*/
void OCT( void )
{	SET_BASE( 8 );
}


/*
02060 	FCC 'FILL'
02070 	FCB 4
02080 	FCB MFORE
02090 	FDB OCT-CFAOFF
02100 	FDB BIF+2
02110 	FDB FENCE-CFAOFF
02120 	FDB FILLIN-CFAOFF
*/
static character_t sFILL[] = "\x4" "FILL";
definition_header_s hFILL = 
{	{ (natural_t) sFILL },
	{ 0 },
	{ (natural_t) &hOCT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hFENCE },
	{ (natural_t) &hFILLIN },
	{ (natural_t) FILL }
};
/*
02130 FILL	PSHS Y
02140 	PULU D,X,Y
02150 	STB ,Y+
02160 	LEAX -1,X
02170 	BNE *-4
02180 	PULS Y
02190 	NEXT
02200 *
*/
void FILL( void )
{	byte_t fillValue = (byte_t) SP[ 0 ].integer;	/* Need a byte fill and a character fill. */
	natural_t count = SP[ 1 ].integer;
	byte_t * target = SP[ 2 ].bytep;
	for ( ; count > 0; --count )
	{	* target = fillValue;
	}
}


/*
02210 	FCC 'ERASE'
02220 	FCB 5
02230 	FCB MFORE
02240 	FDB FILL-CFAOFF
02250 	FDB BIF+2
02260 	FDB 0
02270 	FDB 0
*/
static character_t sERASE[] = "\x5" "ERASE";
definition_header_s hERASE = 
{	{ (natural_t) sERASE },
	{ 0 },
	{ (natural_t) &hFILL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) ERASE }
};
/*
02280 ERASE	LDB #0
02290 	PSHU D
02300 	BRA FILL
02310 *
*/
void ERASE( void )
{	( * --SP ).integer = 0;
	FILL();
}


/*
02320 	FCC 'BLANKS'
02330 	FCB 6
02340 	FCB MFORE
02350 	FDB ERASE-CFAOFF
02360 	FDB BIF+2
02370 	FDB BL-CFAOFF
02380 	FDB 0
*/
static character_t sBLANKS[] = "\x6" "BLANKS";
definition_header_s hBLANKS = 
{	{ (natural_t) sBLANKS },
	{ 0 },
	{ (natural_t) &hERASE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBL },
	{ 0 },
	{ (natural_t) BLANKS }
};
/*
02390 BLANKS	LDB #$20 ascii SP
02400 	PSHU D
02410 	BRA FILL
02420 *
*/
void BLANKS( void )
{	( * --SP ) = hBL.parameterLink[ 0 ];	/* Should have used the manifest constant in the original BIF-6809. */
	FILL();
}


/*
02430 	FCC 'HOLD'
02440 	FCB 4
02450 	FCB MFORE
02460 	FDB BLANKS-CFAOFF
02470 	FDB BIF+2
02480 	FDB 0
02490 	FDB 0
*/
static character_t sHOLD[] = "\x4" "HOLD";
definition_header_s hHOLD = 
{	{ (natural_t) sHOLD },
	{ 0 },
	{ (natural_t) &hBLANKS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) HOLD }
};
/*
02500 HOLD	PULU D CH
02510 	PSHS Y
02520 	LDY <UP
02530 	LDX UHLD,Y
02540 	STB ,-X
02550 	STX UHLD,Y
02555 	PULS Y
02560 	NEXT
02570 *
*/
void HOLD( void )
{	character_t ch = (character_t) ( * SP++ ).integer;
	character_t * padPt = UP.task->padMarker.chString;
	* --padPt = ch;
	UP.task->padMarker.chString = padPt;
}


/*
02580 	FCC 'PAD'
02590 	FCB 3
02600 	FCB MFORE
02610 	FDB HOLD-CFAOFF
02620 	FDB BIF+2
02630 	FDB 0
02640 	FDB 0
*/
static character_t sPAD[] = "\x3" "PAD";
definition_header_s hPAD = 
{	{ (natural_t) sPAD },
	{ 0 },
	{ (natural_t) &hHOLD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUCON },
	{	{ UPAD }	}
};
/*
02650 PAD	DOUCON	moved!
02660 	FCB UPAD
02700 *
*/


/*
02710 	FCC 'S->D'
02720 	FCB 4
02730 	FCB MFORE
02740 	FDB PAD-CFAOFF
02750 	FDB BIF+2
02760 	FDB RPSTO-CFAOFF
02770 	FDB SIGN-CFAOFF
*/
static character_t sSTOD[] = "\x4" "S->D";
definition_header_s hSTOD = 
{	{ (natural_t) sSTOD },
	{ 0 },
	{ (natural_t) &hPAD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hRPSTO },
	{ (natural_t) &hSIGN },
	{ (natural_t) STOD }
};
/*
02780 STOD	LEAU -2,U
02790 	LDD 2,U
02795 	LBRA ZLESS+2
** Could have done it this way, too:
STOD	LDB ,U
	SEX	that unfortunate mnemonic, again
	TFR B,A
	SEX
	PSHU d
	NEXT
** about 3 bytes longer, maybe twice as fast?
02800 *
*/
void STOD( void )
{
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU byte order for doubles. */
	sdblnatural_t extended = ( * SP++ ).sinteger;	/* Notice the implicit converstion! */
	sdblnatural_t * stack = (sdblnatural_t *) ( (char *) SP );
	* --stack = extended;	/* Native CPU CELL order for doubles is FORTH order. */
	SP = (cell_u *) ( (char *) stack );
#	else /* defined LOW_C_CELL_FIRST */
	sdblnatural_t extended = SP[ 0 ].sinteger;	/* Notice the implicit converstion! */
	( * --SP ).sinteger = (snatural_t) ( extended >> BITSPERCELL );	/* FORTH order, not native! */
#	endif /* !defined LOW_C_CELL_FIRST */
#else /* defined MANUFACTURED_DOUBLE */
	if ( SP[ 0 ].sinteger < 0L )
	{	( * --SP ).sinteger = -1L;
	}
	else
	{	( * --SP ).sinteger = 0L;
	}
#endif /* !defined MANUFACTURED_DOUBLE */
}


static character_t sDTOS[] = "\x4" "D->S";
definition_header_s hDTOS = 
{	{ (natural_t) sDTOS },
	{ 0 },
	{ (natural_t) &hSTOD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DTOS }
};

void DTOS( void )
{
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU CELL order for doubles. */
	sdblnatural_t * stack = (sdblnatural_t *) ( (char *) SP );
	sdblnatural_t dword = * stack++;	/* Native CPU CELL order for doubles is FORTH order. */
	SP = (cell_u *) ( (char *) stack );
	( * --SP ).sinteger = (snatural_t) dword;
#	else /* defined LOW_C_CELL_FIRST */
	sdblnatural_t dword = ( (sdblnatural_t) SP[ 0 ].sinteger << BITSPERCELL ) | SP[ 1 ].integer;
	++SP;
	SP[ 0 ].integer = (natural_t) dword;
#	endif /* !defined LOW_C_CELL_FIRST */
#else /* defined MANUFACTURED_DOUBLE */
	++SP;	/* DROP most significant CELL */
#endif /* !defined MANUFACTURED_DOUBLE */
}


/*
02810 	FCC '+-'
02820 	FCB 2
02830 	FCB MFORE
02840 	FDB STOD-CFAOFF
02850 	FDB BIF+2
02860 	FDB ADDSTO-CFAOFF
02870 	FDB ADDBUF-CFAOFF
*/
static character_t sCHS[] = "\x2" "+-";
definition_header_s hCHS = 
{	{ (natural_t) sCHS },
	{ 0 },
	{ (natural_t) &hDTOS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hADDSTO },
	{ (natural_t) &hADDBUF },
	{ (natural_t) CHS }
};
/*
02880 CHS	LDD ,U++	// Not a bug. Top is a flag.
02890 	LBMI MINUS
02895 	NEXT
02900 *
*/
void CHS( void )
{	if ( ( * SP++ ).sinteger < 0 )
	{	MINUS();
	}
}


/*
02910 	FCC 'D+-'
02920 	FCB 3
02930 	FCB MFORE
02940 	FDB STOD-CFAOFF
02950 	FDB BIF+2
02960 	FDB 0
02970 	FDB 0
*/
static character_t sDCHS[] = "\x3" "D+-";
definition_header_s hDCHS = 
{	{ (natural_t) sDCHS },
	{ 0 },
	{ (natural_t) &hCHS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hDCOMMA },
	{ (natural_t) DCHS }
};
/*
02980 DCHS	LDD ,U++
02990 	LBMI DMINUS
02995 	NEXT
03000 *
*/
void DCHS( void )
{	if ( ( * SP++ ).sinteger < 0 )
	{	DMINUS();
	}
}


/*
03010 	FCC 'ABS'
03020 	FCB 3
03030 	FCB MFORE
03040 	FDB DCHS-CFAOFF
03050 	FDB BIF+2
03060 	FDB ABORT-CFAOFF
03070 	FDB ALLOT-CFAOFF
*/
static character_t sABS[] = "\x3" "ABS";
definition_header_s hABS = 
{	{ (natural_t) sABS },
	{ 0 },
	{ (natural_t) &hDCHS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hABORT },
	{ (natural_t) &hALLOT },
	{ (natural_t) ABS }
};
/*
03080 ABS	LDD ,U
03090 	LBMI MINUS
03095 	NEXT
03100 *
*/
void ABS( void )
{	if ( SP[ 0 ].sinteger < 0 )
	{	MINUS();
	}
}


/*
03110 	FCC 'DABS'
03120 	FCB 4
03130 	FCB MFORE
03140 	FDB ABS-CFAOFF
03150 	FDB BIF+2
03160 	FDB DSUB-CFAOFF
03170 	FDB DIGIT-CFAOFF
*/
static character_t sDABS[] = "\x4" "DABS";
definition_header_s hDABS = 
{	{ (natural_t) sDABS },
	{ 0 },
	{ (natural_t) &hABS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDSUB },
	{ (natural_t) &hDIGIT },
	{ (natural_t) DABS }
};
/*
03180 DABS	LDD ,U
03190 	LBMI DMINUS
03195 	NEXT
03200 *
*/
void DABS( void )
{
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU byte order for doubles. */
	sdblnatural_t * stack = (sdblnatural_t *) ( (char *) SP );
	if ( * stack < 0LL )	/* Native CPU CELL order for doubles. Except I'm not sure about the pointer conversion. */
	{	DMINUS();
	}
#	else /* defined LOW_C_CELL_FIRST */
	sdblnatural_t dword = ( (sdblnatural_t) SP[ 0 ].sinteger << BITSPERCELL ) | SP[ 1 ].integer;
	if ( dword < 0LL )	/* FORTH CELL order for doubles. */
	{	DMINUS();
	}
#	endif /* !defined LOW_C_CELL_FIRST */
#else /* defined MANUFACTURED_DOUBLE */
	if ( SP[ 0 ].sinteger < 0L )	/* FORTH CELL order for doubles. */
	{	DMINUS();
	}
#endif /* !defined MANUFACTURED_DOUBLE */
}


/*
03210 	FCC 'MIN'
03220 	FCB 3
03230 	FCB MFORE
03240 	FDB DABS-CFAOFF
03250 	FDB BIF+2
03260 	FDB MSMOD-CFAOFF
03270 	FDB MOVE-CFAOFF
*/
static character_t sMIN[] = "\x3" "MIN";
definition_header_s hMIN = 
{	{ (natural_t) sMIN },
	{ 0 },
	{ (natural_t) &hDABS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hMSMOD },
	{ (natural_t) &hMOVE },
	{ (natural_t) MIN }
};
/*
03280 MIN	PULU D
03284 	CMPD ,U
03288 	BGE *+4
03290 	STD ,U
03295 	NEXT
*/
void MIN( void )
{	snatural_t test = ( * ++SP ).sinteger;
	if ( test < SP[ 0 ].sinteger )
	{	SP[ 0 ].sinteger = test;
	}
}


/*
03300 *
03310 	FCC 'MAX'
03320 	FCB 3
03330 	FCB MFORE
03340 	FDB MIN-CFAOFF
03350 	FDB BIF+2
03360 	FDB 0
03370 	FDB 0
*/
static character_t sMAX[] = "\x3" "MAX";
definition_header_s hMAX = 
{	{ (natural_t) sMAX },
	{ 0 },
	{ (natural_t) &hMIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) MAX }
};
/*
03380 MAX	PULU D
03384 	CMPD ,U
03388 	BLE *+4
03390 	STD ,U
03395 	NEXT
03400 *
*/
void MAX( void )
{	snatural_t test = ( * ++SP ).sinteger;
	if ( test > SP[ 0 ].sinteger )
	{	SP[ 0 ].sinteger = test;
	}
}


/*
03410 	FCC '['
03412 	FCB MIMM.OR.1
03414 	FCB MFORE
03416 	FDB MAX-CFAOFF
03418 	FDB BIF+2
03420 	FDB XOR-CFAOFF
03422 	FDB 0
*/
static character_t sLBRAK[] = "\x1" "[";
definition_header_s hLBRAK = 
{	{ (natural_t) sLBRAK },
	{ MIMM },
	{ (natural_t) &hMAX },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) LBRAK }
};
/*
03430 LBRAK	LDB #.NOT.SCOMP
03435 	LDX <UP
03440 	ANDB USTATE+1,X
03445 	STB USTATE+1,X
03450 	NEXT
03500 *
*/
void LBRAK( void )
{	UP.task->compilerState.integer &= ~SCOMP;
}


/*
03510 	FCC ']'
03512 	FCB 1
03514 	FCB MFORE
03516 	FDB LBRAK-CFAOFF
03518 	FDB BIF+2
03520 	FDB 0
03522 	FDB 0
*/
static character_t sRBRAK[] = "\x1" "]";
definition_header_s hRBRAK = 
{	{ (natural_t) sRBRAK },
	{ 0 },
	{ (natural_t) &hLBRAK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) RBRAK }
};
/*
03530 RBRAK	LDB #SCOMP
03535 	LDX <UP
03540 	ORB USTATE+1,X
03545 	STB USTATE+1,X
03550 	NEXT
03555 *
*/
void RBRAK( void )
{	UP.task->compilerState.integer |= SCOMP;
}


/*
03560 	FCC 'IMMEDIATE'
03562 	FCB 9
03564 	FCB MFORE
03566 	FDB RBRAK-CFAOFF
03568 	FDB BIF+2
03570 	FDB 0
03572 	FDB 0
*/
static character_t sIMMED[] = "\x9" "IMMEDIATE";
definition_header_s hIMMED = 
{	{ (natural_t) sIMMED },
	{ 0 },
	{ (natural_t) &hRBRAK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIMFA },
	{ 0 },
	{ (natural_t) IMMED }
};
/*
03580 IMMED	LDB #MIMM
03585 	BRA SMUDGE+2
03600 *
*/
void IMMED( void )
{	toggleDefinitionState( MIMM );
}


/*
03610 	FCC 'SMUDGE'
03612 	FCB 6
03614 	FCB MFORE
03616 	FDB IMMED-CFAOFF
03618 	FDB BIF+2
03620 	FDB STOD-CFAOFF
03622 	FDB SPACE-CFAOFF
*/
static character_t sSMUDGE[] = "\x6" "SMUDGE";
definition_header_s hSMUDGE = 
{	{ (natural_t) sSMUDGE },
	{ 0 },
	{ (natural_t) &hIMMED },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSTOD },
	{ (natural_t) &hSPACE },
	{ (natural_t) SMUDGE }
};
/*
03630 SMUDGE	LDB #MHID
03635 	LDX <UP
03645 	EORB [UCURR,X]
03650 	STB [UCURR,X]
03655 	NEXT
03657 *
*/
void SMUDGE( void )
{	toggleDefinitionState( MHID );
}


/*
03660 	FCC 'COMPILE-ONLY'
03662 	FCB 12
03664 	FCB MFORE
03666 	FDB SMUDGE-CFAOFF
03668 	FDB BIF+2
03670 	FDB 0
03672 	FDB 0
*/
static character_t sCOMPO[] = "\xc" "COMPILE-ONLY";
definition_header_s hCOMPO = 
{	{ (natural_t) sCOMPO },
	{ 0 },
	{ (natural_t) &hSMUDGE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) COMPO }
};
/*
03680 COMPO	LDB #MCOMP
03685 	BRA SMUDGE+2
03800 *
*/
void COMPO( void )
{	toggleDefinitionState( MCOMP );
}


/*
03810 	FCC 'COUNT'
03812 	FCB 5
03814 	FCB MFORE
03816 	FDB COMPO-CFAOFF
03818 	FDB BIF+2
03820 	FDB 0
03822 	FDB 0
*/
static character_t sCOUNT[] = "\x5" "COUNT";
definition_header_s hCOUNT = 
{	{ (natural_t) sCOUNT },
	{ 0 },
	{ (natural_t) &hCOMPO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) COUNT }
};
/*
03830 COUNT	LDX ,U CT OF STR
03835 	LDB ,X+
03840 	STX ,U STRING
03845 	CLRA
03850 	PSHU D COUNT
03855 	NEXT
03900 *
*/
void COUNT( void )
{	character_t * string = SP[ 0 ].chString;
	natural_t count = * string++;	/* Could design this to be extensible through the count high bit. */
	SP[ 0 ].chString = string;
	( * --SP ).integer = count;
}


/*
03910 	FCC '-TRAILING'
03912 	FCB 9
03914 	FCB MFORE
03916 	FDB COUNT-CFAOFF
03918 	FDB BIF+2
03920 	FDB DIFIND-CFAOFF
03922 	FDB 0
*/
static character_t sDTRAIL[] = "\x9" "-TRAILING";
definition_header_s hDTRAIL = 
{	{ (natural_t) sDTRAIL },
	{ 0 },
	{ (natural_t) &hCOUNT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDIFIND },
	{ 0 },
	{ (natural_t) DTRAIL }
};
/*
03930 DTRAIL	LDD ,U
03935 	LDX 2,U
03940 	LEAX D,X END
03945 	LDA #$20 ascii SP
03950 DTRAL	CMPA ,-X	// Sort of buggy, relative to bad counts.
03955 	BNE DTRAD
03960 	CMPX 2,U
03965 	BHS DTRAL
03970 DTRAD TFR X,D
03975 	SUBD 2,U
03980 	ADDD #1
03985 	STD ,U
03990 	NEXT
04000 *
*/
void DTRAIL( void )
{	character_t * string = SP[ 1 ].chString;
	character_t * end = string + SP[ 0 ].integer;
	const character_t blank = (character_t) hBL.parameterLink[ 0 ].integer;
	while ( ( end > string ) && ( * ( end - 1 ) == blank ) )
	{	--end;
	} 
	SP[ 0 ].integer = end - string;
}


/*
// Leaving this here for now, to avoid messing with the symbol table.
04010 	FCC '(MACHINE)'
04012 	FCB MCOMP.OR.9
04014 	FCB MFORE
04016 	FDB DTRAIL-CFAOFF
04018 	FDB BIF+2
04020 	FDB XLINE-CFAOFF
04022 	FDB INUMB-CFAOFF
*/
static character_t sXMACH[] = "\x9" "(MACHINE)";
definition_header_s hXMACH = 
{	{ (natural_t) sXMACH },
	{ MCOMP | MHID },	/* Hide it, since it is useless for now. */
	{ (natural_t) &hDTRAIL },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hXLINE },
	{ (natural_t) &hINUMB },
	{ (natural_t) XMACH }
};
/*
04030 XMACH	TFR Y,X
04040 	PULS Y UN-NEST
04050 	JMP ,X IN LINE MACHINE CODE
04100 *
*/
void XMACH( void )
{	sysSIG.integer = ICODE_LIST_NOT_AVAILABLE_ERROR;
/*	i_codef callp = (i_codef) ( (void *) IP );
	SEMIS();
	( * callp )();	// * Nope. No way. * /
*/
}

