/*
**  bifu_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF/A, as mechanically as possible.
*/
#include "bif_eval.h"
#include "bif_io.h"


/* 00080 	INCLUDE BIFU/I:1 */
#include "bifu_i.h"

/*
00090 	ORG $1200	DEBIF: $3F00
00100 	INCLUDE BIF/M:1
*/
#include "bif_m.h"

/* The task record was allocated in bifdp/a. 
00110 	INCLUDE BIFDP/A:1
*/
#include "bif_vm.h"
/*
00110 	INCLUDE BIFST/A:1
*/
#include "bifst_a.h"
/* No direct page to set up.
00120 	SETDP VDP COLD loads DP
*/

/* Have to bring some of the other header files in, too:
*/
#include "bif2b_a.h"	/* for HERERR() */
#include "bif5b_a.h"	/* for ERROR() */
#include "bif7_a.h"
#include "bif7b_a.h"

/*
01000 *
01001 	FCC '@' name
01002 	FCB 1 name length, usage (NFA)
01003 	FCB MFORE type/allocation MODES
01004 	FDB WARM-CFAOFF previous link in allocation
01005 	FDB BIF+2 owning vocabulary
01006 	FDB EQ-CFAOFF left link in tree
01007 	FDB AND-CFAOFF right link in tree
*/
static character_t sFETCH[] = "\x1" "@";
definition_header_s hFETCH =	
{	{ (natural_t) sFETCH },
	{ 0 },
	{ (natural_t) &LASTinVM },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEQ },
	{ (natural_t) &hAND },
	{ (natural_t) FETCH }
};
/*
01010 FETCH	LDD [,U] from [tos] to stack
01011 	STD ,U
01012 	NEXT
01013 *
*/
/*
@       ( adr --- n )
FETCH   Replace address on stack with the word at the address.
*/
void FETCH(void)
{	SP[ 0 ] = * ( SP[ 0 ].cellp );
}


static character_t sDFETCH[] = "\x2" "D@";
definition_header_s hDFETCH =	
{	{ (natural_t) sDFETCH },
	{ 0 },
	{ (natural_t) &hFETCH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DFETCH }
};
/*
D@       ( adr --- d )
DFETCH   Replace address on stack with the double word at the address.
*/
void DFETCH(void)
{	dblnatural_t * source = ( * SP++ ).doublep;
	dblnatural_t * stack = (dblnatural_t *) ( (char *) SP );
	* --stack = * source;
	SP = (cell_u *) ( (char *) stack );
}


/*
01014 	FCC '!'
01015 	FCB 1
01016 	FCB MFORE
01017 	FDB FETCH-CFAOFF
01030 	FDB BIF+2
01040 	FDB NUBLK-CFAOFF
01050 	FDB STOCSP-CFAOFF
*/
static character_t sSTORE[] = "\x1" "!";
definition_header_s hSTORE =	
{	{ (natural_t) sSTORE },
	{ 0 },
	{ (natural_t) &hDFETCH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hNUBLK },
	{ (natural_t) &hSTOCSP },
	{ (natural_t) STORE }
};
/*
01060 STORE	LDD 2,U from stack to [top]
01070 	STD [,U]
01080 	LEAU 4,U
01090 	NEXT
01095 *
*/
/*
!       ( n adr --- )
STORE   Store second word on stack at address on top of stack.
*/
void STORE(void)
{	cell_u * target = SP[ 0 ].cellp;
	* target = SP[ 1 ];
	SP += 2;
}


static character_t sDSTORE[] = "\x2" "D!";
definition_header_s hDSTORE =	
{	{ (natural_t) sDSTORE },
	{ 0 },
	{ (natural_t) &hSTORE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DSTORE }
};
/*
D!       ( d adr --- )
DSTORE   Store double word at second on stack at address on top of stack.
*/
void DSTORE(void)
{	dblnatural_t * target = ( * SP++ ).doublep;
	dblnatural_t * stack = (dblnatural_t *) ( (char *) SP );
	* target = * stack++;
	SP = (cell_u *) ( (char *) stack );
}


/*
02140 	FCC 'I'
02150 	FCB 1
02160 	FCB MFORE
02170 	FDB XDO-CFAOFF
02180 	FDB BIF+2
02190 	FDB HLD-CFAOFF
02200 	FDB IDDOT-CFAOFF
*/
static character_t sI[] = "\x1" "I";
definition_header_s hI =	
{	{ (natural_t) sI },
	{ 0 },
	{ (natural_t) &hDSTORE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hHLD },
	{ (natural_t) &hIDDOT },
	{ (natural_t) I }
};
/*
02210 I	LDD ,S
02220 	PSHU D
02222 	NEXT
02224 *
*/
/*
I       ( --- index )           ( limit index *** limit index )
        Copy the loop index from the return stack.  Synonym for R.
*/
void I(void)
{	* --SP = RP[ 0 ];
}


/*
02226 	FCC 'J'
02228 	FCB 1
02230 	FCB MFORE
02232 	FDB I-CFAOFF
02234 	FDB BIF+2
02236 	FDB IPCOM-CFAOFF
02238 	FDB 0
*/
static character_t sJ[] = "\x1" "J";
definition_header_s hJ =	
{	{ (natural_t) sJ },
	{ 0 },
	{ (natural_t) &hI },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIPCOM },
	{ 0 },
	{ (natural_t) J }
};
/*
02240 J	LDD 4,S
02242 	PSHU D
02244 	NEXT
02246 *
*/
/*
J       ( --- index2 )  ( index2 limit1 index1 *** index2 limit1 index1 )
        Copy the outer loop index from the return stack.  As with (DO)
        and I, J may be useful outside looping contexts.
        Note that J only works in the same definition as I, not in called words.
*/
void J(void)
{	* --SP = RP[ 2 ];
}


/*
02250 	FCC 'DIGIT'
02260 	FCB 5
02270 	FCB MFORE
02280 	FDB J-CFAOFF
02290 	FDB BIF+2
02300 	FDB DEC-CFAOFF
02310 	FDB DLITER-CFAOFF
*/
static character_t sDIGIT[] = "\x5" "DIGIT";
definition_header_s hDIGIT =	
{	{ (natural_t) sDIGIT },
	{ 0 },
	{ (natural_t) &hJ },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDEC },
	{ (natural_t) &hDLITER },
	{ (natural_t) DIGIT }
};
/*
02320 DIGIT	LDB 3,U
02330 	CMPB #'9
02340 	BLS DIGITX+4
02350 	CMPB #'A
02360 	BLO DIGITN
02370 	CMPB #'Z
02380 	BLS DIGITX+2
02390 	CMPB #'a
02400 	BLO DIGITN
02410 	CMPB #'z
02420 	BHI DIGITN
02430 DIGITX	SUBB #'a-'Z-1
02440 	SUBB #'A-'9-1
02450 	SUBB #'0
02460 	CMPB 1,U
02470 	BHS DIGITN
02480 	CLRA
02490 	STD 2,U
02500 	LDD #-1
02510 DIGITL	STD ,U
02520 	NEXT
02530 DIGITN	LEAU 2,U
02540 	LDD #0
02550 	BRA DIGITL
02560 *
*/
/*
DIGIT   ( c base --- ff )
        ( c base --- n tf )
        Translate C in base, yielding a translation valid flag.  If the
        translation is not valid in the specified base, only the false
        flag is returned.
*/
void DIGIT(void)	/* A != a -- a follows Z, up to base 62. Taking chortcuts, not supporting standards. */
{	natural_t base = SP[ 0 ].integer;
	natural_t digit = SP[ 1 ].integer;
	++SP;	/* Follow the 6809 code. Assume/preset false so we can bail early. */
	SP[ 0 ].sinteger = FALSE;
	if ( digit > '9' )
	{	if ( digit < 'A' )
			return;
		if ( digit > 'Z' )
		{	if ( ( digit < 'a' ) || ( digit > 'z' ) )
				return;
			digit -= 'a' - 'Z' - 1;	/* Subtract the gap. */
		}
		digit -= 'A' - '9' - 1;	/* Subtract the gap. */
	}
	digit -= '0';	/* Final adjustment, digit < '0' wraps to very high value. */
	if ( digit >= base )	/* Woops. Equal to base not valid, either. JMR20110226 */
		return;
	SP[ 0 ].integer = digit;
	( * --SP ).sinteger = TRUE;
	return;
}


/*
02570 	FCC '(FIND)'
02580 	FCB 6
02590 	FCB MFORE
02600 	FDB DIGIT-CFAOFF
02610 	FDB BIF+2
02620 	FDB IABORT-CFAOFF
02630 	FDB XMACH-CFAOFF
*/
static character_t sPFIND[] = "\x6" "(FIND)";
definition_header_s hPFIND =	
{	{ (natural_t) sPFIND },
	{ 0 },
	{ (natural_t) &hDIGIT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hIABORT },
	{ (natural_t) &hXMACH },
	{ (natural_t) PFIND }
};
/*
02640 * search vocabulary adr2 for (adr1)
02650 PFIND	LDD ,U valid?
02660 	BEQ PFINDX
02670 PFINDL	DOCOL
02680 	FDB PREF
02690 	FDB XMACH
02700 	LEAU 2,U
02710 	LDX [,U] NULL link?
02720 	BEQ PFINDN
02730 	LDB ,X
02740 	ANDB #MHID smudged?
02750 	BEQ PFINDY
02760 	LEAX RTOFF,X deeper
02770 	STX ,U
02780 	BRA PFINDL
02790 PFINDY	LDX #-1
02800 PFINDN	LDD ,U
02810 	STX ,U
02820 PFINDX	STD 2,U
02830 	NEXT
02990 *
*/
/*
(FIND)  ( name vocptr --- locptr f )
PFIND   Search vocabulary for a symbol called name.  Name is a pointer
        to a NUL terminated string of characters without count, vocptr
        is a pointer to a pointer to a definition (the length byte of a
        symbol table entry).  Locptr is also a pointer to a pointer to a
        definition, such that, if the flag is false, a symbol with the
        name searched for may be inserted in proper order at that point.
        Vocptr and locptr may point to either the right or left entry of
        the order-parent entry in the symbol table, or to pointer to the
        root of a vocabulary.  HIDDEN (smudged) definitions are
        lexically less than their name strings.  Searches only the local
        vocabulary, from the order-parent node passed.  Uses (REFIND).

		vocptr is a pointer to the parameter field of a vocabulary 
		header.
*/
void PFIND(void)
{	cell_u * base = SP[ 0 ].cellp;
	while ( base != (cell_u *) 0 )	/* Firewall. */
	{	PREF();
		++SP;	/* Ignore flag, check link. */
		base = SP[ 0 ].cellp;
		cell_u link = * base;
		snatural_t flag = FALSE;	/* Want to be careful not to depend on NULL being numerically 0. */
		if ( link.definitionp != (definition_header_s *) 0 )
		{	if ( ( ( ( * link.definitionp ).interpMode ).integer & MHID ) != 0 )	/* Smudged (hidden), go deeper. */
			{	SP[ 0 ].cellp = base = (cell_u *) link.bytep + RTOFF;	/* Smudged definitions are lexically less. */
				continue;	/* Trying to follow the 6809 code, for now. */
			}
			else
			{	flag = TRUE;	/* Exists. */
			}
		}
		SP[ 0 ].sinteger = flag;
		break;
	}
	SP[ 1 ].cellp = base;	/* if it came in NULL, pass it back NULL. */
}


/*
03000 	FCC 'ENCLOSE'
03010 	FCB 7
03020 	FCB MFORE
03030 	FDB PFIND-CFAOFF
03040 	FDB BIF+2
03050 	FDB EMTBUF-CFAOFF
03060 	FDB 0
*/
static character_t sENCLOS[] = "\x7" "ENCLOSE";
definition_header_s hENCLOS =	
{	{ (natural_t) sENCLOS },
	{ 0 },
	{ (natural_t) &hPFIND },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEMTBUF },
	{ 0 },
	{ (natural_t) ENCLOS }
};
/*
03070 * adr1 c --- adr2 len
03080 ENCLOS	LDX 2,U
03100 ENCLLD	LDB ,X+ delimiter
03110 	BEQ ENCL0
03120 	CMPB 1,U
03130 	BEQ ENCLLD
03133 ENCL0	LEAX -1,X
03140 	STX 2,U
03150 ENCLLW	LDB ,X+ scan word
03160 	BEQ ENCLCA
03170 	CMPB 1,U
03180 	BNE ENCLLW
03190 ENCLCA	TFR X,D length
03195 	SUBD #1
03200 	SUBD 2,U
03220 	STD ,U
03230 	NEXT
03240 *
*/
/*
ENCLOSE ( buffer c --- s length )
ENCLOS  Scan buffer for a symbol delimited by c or ASCII NUL; return the
        length of the symbol scanned and the address of its first
        character.  A length 0 and a pointer to a NUL means no symbol
        was scanned before NUL terminator was reached.  (Buffer is the
        address of the buffer array to scan.)
*/
void ENCLOS(void)
{	character_t * buffer = SP[ 1 ].chString;
	character_t delimiter = (character_t) SP[ 0 ].integer;
	character_t ch;
	while ( ( ( ch = * buffer++ ) != 0 ) && ( ch == delimiter ) )
	{	}
	SP[ 1 ].chString = --buffer;
	while ( ( ( ch = * buffer++ ) != 0 ) && ( ch != delimiter ) )
	{	}
	--buffer;
	SP[ 0 ].integer = buffer - SP[ 1 ].chString;
}


/* Out of order instead of putting this in bif_eval.h :
03410 LITERS	LDX <UP
03412 	LDB USTATE+1,X
03414 	ANDB #SCOMP
03416 	PULS D no CC
03418 	BNE *+4 compiling?
03420 	NEXT no
03422 	PSHS Y
03424 	LDY UDP,X
03426 	EXG D,PC return
03430 *
** Most of this is stuff that C would pass off to the optimizer.
** LITERS is converted to a macro and moved to where LITER can see it.
*/
#define LITERS	\
{	if ( ( ( UP.task->compilerState.integer ) & SCOMP ) == 0 )	\
	{	return;	\
	}	\
	/* And then what would be useful?		\
	** Splitting the local variable and its	use is generally bad practice in macros, anyway.	\
	** Eventually, check before allocating, in common code. \
	** That would make sense as a macro.	\
	*/	\
}

/*
03250 	FCC 'LITERAL'
03260 	FCB MIMM.OR.7
03270 	FCB MFORE
03280 	FDB ENCLOS-CFAOFF
03290 	FDB BIF+2
03300 	FDB LIT-CFAOFF
03310 	FDB LOAD-CFAOFF
*/
static character_t sLITER[] = "\x7" "LITERAL";
definition_header_s hLITER =	
{	{ (natural_t) sLITER },
	{ MIMM },
	{ (natural_t) &hENCLOS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLIT },
	{ (natural_t) &hLOAD },
	{ (natural_t) LITER }
};
/*
03320 * compile a literal
03330 LITER	BSR LITERS
03340 	LDD #LIT
03350 LITERB	STD ,Y++
03360 	PULU D
03370 	STD ,Y++
03380 	STY UDP,X
03390 	PULS Y
03400 	JMP HERERR
03405 *
*/
/*
LITERAL ( n --- )                                               P
LITER   ( n --- n ) if interpreting.
        Compile n as a literal, if compiling.
*/
void LITER(void)
{	LITERS;	/* This is a race condition. Also, want to use the same code as comma. */
	{	cell_u * allocation = UP.task->dictionaryAllocationPointer.cellp;
		( * allocation++ ).definitionp = &hLIT;
		( * allocation++ ) = * SP++;
		UP.task->dictionaryAllocationPointer.cellp = allocation;
	}
	HERERR;
}


/*
03410 LITERS	LDX <UP
03412 	LDB USTATE+1,X
03414 	ANDB #SCOMP
03416 	PULS D no CC
03418 	BNE *+4 compiling?
03420 	NEXT no
03422 	PSHS Y
03424 	LDY UDP,X
03426 	EXG D,PC return
03430 *
** Most of this is stuff that C would pass off to the optimizer.
** LITERS is converted to a macro and moved to where LITER can see it.
*/


/*
03435 	FCC 'DLITERAL'
03440 	FCB MIMM.OR.8
03450 	FCB MFORE
03460 	FDB LITER-CFAOFF
03470 	FDB BIF+2
03480 	FDB DLIT-CFAOFF
03490 	FDB DMINUS-CFAOFF
*/
static character_t sDLITER[] = "\x8" "DLITERAL";
definition_header_s hDLITER =	
{	{ (natural_t) sDLITER },
	{ MIMM },
	{ (natural_t) &hLITER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDLIT },
	{ (natural_t) &hDMINUS },
	{ (natural_t) DLITER }
};
/*
03500 * compile a 32 bit constant
03510 DLITER	BSR LITERS
03540 	LDD #DLIT
03550 	STD ,Y++
03560 	PULU D
03570 	BRA LITERB
03630 *
*/
/*
DLITERAL        ( d --- )                                       P
DLITER          ( d --- d ) if interpreting.
        Compile d as a double literal, if compiling.
*/
void DLITER(void)
{	LITERS;
	{	cell_u * allocation = UP.task->dictionaryAllocationPointer.cellp;
		dblnatural_t * dallocation;
		dblnatural_t * stack = (dblnatural_t *) ( (char *) SP );
		( * allocation++ ).definitionp = &hDLIT;
		dallocation = (dblnatural_t *) ( (char *) allocation );
		* dallocation++ = * stack++;	/* This is closer to optimized, anyway. */
		SP = (cell_u *) ( (char *) stack );
		/* ( * allocation++ ) = * SP++;
		// ( * allocation++ ) = * SP++;
		*/
		UP.task->dictionaryAllocationPointer.cellp = (cell_u *) ( ( char *) dallocation );
	}
	HERERR;
}


/* Including these all through bifu_i.h, depending on the inclusion guards to prevent loops.
08210 	INCLUDE BIFB/A:1
08220 	INCLUDE BIF1/A:1
08230 	INCLUDE BIF1B/A:1
08240 	INCLUDE BIF2/A:1
08250 	INCLUDE BIF2B/A:1
08260 	INCLUDE BIF3/A:1
08270 	INCLUDE BIF3B/A:1
08280 	INCLUDE BIF4/A:1
08285 	INCLUDE BIF4B/A:1
08290 	INCLUDE BIF5/A:1
08295 	INCLUDE BIF5B/A:1
08300 	INCLUDE BIF6/A:1
08310 	INCLUDE BIF6B/A:1
08320 	INCLUDE BIF7/A:1
08330 	INCLUDE BIF7B/A:1
09000 	END
*/
