#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobAdvancedSetting1Page: public CPropertyPageImpl<CJobAdvancedSetting1Page>,
	public CWinDataExchange<CJobAdvancedSetting1Page>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_ADVANCED_SETTING1 };

	BEGIN_DDX_MAP(CJobAdvancedSetting1Page)
		DDX_CONTROL_HANDLE(IDC_EDIT_NOTIFY_COMMAND_PATH,		m_editNotifyCommandPath)
		DDX_CONTROL_HANDLE(IDC_EDIT_NOTIFY_COMMAND_ARG,			m_editNotifyCommandArg)
		DDX_CONTROL_HANDLE(IDC_BUTTON_CHANGE_NOTIFY_COMMAND,	m_buttonChangeNotifyCommand)
		DDX_CONTROL_HANDLE(IDC_EDIT_REPLY_FILE_NAME,			m_editReplyFileName)
		DDX_CONTROL_HANDLE(IDC_STATIC_REPLY_FILE_SIZE,			m_staticReplyFileSize)
		DDX_CONTROL_HANDLE(IDC_STATIC_BYTE_TRANSFERRED,			m_staticByteTransferred)
		DDX_CONTROL_HANDLE(IDC_BUTTON_CHANGE_REPLY_FILE_NAME,	m_buttonChangeReplyFileName)
		DDX_CONTROL_HANDLE(IDC_RADIO_PROXY_AUTH,				m_radioProxyAuth)
		DDX_CONTROL_HANDLE(IDC_RADIO_SERVER_AUTH,				m_radioServerAuth)
		DDX_CONTROL_HANDLE(IDC_COMBO_AUTH_SCHEME,				m_comboAuthScheme)
		DDX_CONTROL_HANDLE(IDC_EDIT_AUTH_USER_NAME,				m_editAuthUserName)
		DDX_CONTROL_HANDLE(IDC_EDIT_AUTH_PASSWORD,				m_editAuthPassword)
		DDX_CONTROL_HANDLE(IDC_BUTTON_SET_CREDENTIALS,			m_buttonSetCredentials)
		DDX_CONTROL_HANDLE(IDC_BUTTON_REMOVE_CREDENTIALS,		m_buttonRemoveCredentials)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobAdvancedSetting1Page)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_TIMER(OnTimer)
		COMMAND_HANDLER_EX(IDC_BUTTON_CHANGE_NOTIFY_COMMAND,	BN_CLICKED,		OnChangeNotifyCommandButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_CHANGE_REPLY_FILE_NAME,	BN_CLICKED,		OnChangeReplyFileNameButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_SET_CREDENTIALS,			BN_CLICKED,		OnSetCredentialsButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_REMOVE_CREDENTIALS,		BN_CLICKED,		OnRemoveCredentialsButtonDown)
		COMMAND_HANDLER_EX(IDC_RADIO_PROXY_AUTH,				BN_CLICKED,		OnAuthRadioButtonChecked)
		COMMAND_HANDLER_EX(IDC_RADIO_SERVER_AUTH,				BN_CLICKED,		OnAuthRadioButtonChecked)
		COMMAND_HANDLER_EX(IDC_COMBO_AUTH_SCHEME,				CBN_SELCHANGE,	OnSelChangeAuthScheme)
		COMMAND_HANDLER_EX(IDC_EDIT_AUTH_USER_NAME,				EN_CHANGE,		OnEnChangeEditAuth)
		COMMAND_HANDLER_EX(IDC_EDIT_AUTH_PASSWORD,				EN_CHANGE,		OnEnChangeEditAuth)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobAdvancedSetting1Page>)
	END_MSG_MAP()

	static const DWORD REFRESH_TIMER_ID	= 128;	
	static const DWORD REFRESH_INTERVAL	= 1 * 1000;

	CJobAdvancedSetting1Page(void);
	~CJobAdvancedSetting1Page(void);


	__checkReturn bool IsBITS15Supported(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);


private:
	CEdit		m_editNotifyCommandPath;
	CEdit		m_editNotifyCommandArg;
	CButton		m_buttonChangeNotifyCommand;
	CEdit		m_editReplyFileName;
	CStatic		m_staticReplyFileSize;
	CStatic		m_staticByteTransferred;
	CButton		m_buttonChangeReplyFileName;
	CButton		m_radioProxyAuth;
	CButton		m_radioServerAuth;
	CComboBox	m_comboAuthScheme;
	CEdit		m_editAuthUserName;
	CEdit		m_editAuthPassword;
	CButton		m_buttonSetCredentials;
	CButton		m_buttonRemoveCredentials;

	CComPtr<IBackgroundCopyManager>		m_spBITSManager;
	CComQIPtr<IBackgroundCopyJob2>		m_spJob2;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnDestroy(void);
	LRESULT OnTimer(__in UINT_PTR nIDEvent);
	LRESULT OnChangeNotifyCommandButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnChangeReplyFileNameButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnSetCredentialsButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnRemoveCredentialsButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnAuthRadioButtonChecked(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnSelChangeAuthScheme(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeEditAuth(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitPropertyPageControls(void);
	bool InitAuthSchemeComboBox(void);
	bool InitAuthEditControls(void);

	bool RefreshUI(void);
	bool RefreshNotifyCommandInfo(void);
	bool RefreshReplyFileInfo(void);
	bool UpdateAuthRelatedControls(void);

	bool UncheckAuthSchemeRadioButton(void);
	bool ClearAuthInfoEdit(void);
	
	__checkReturn BG_AUTH_SCHEME GetAuthSchemeFromComboBox(void);
	bool SetAuthSchemeToComboBox(__in BG_AUTH_SCHEME authScheme);
	__checkReturn BG_AUTH_TARGET GetAuthTargetFromRadioButton(void);
	bool SetAuthTargetToRadioButton(__in BG_AUTH_TARGET authTarget);
	CString GetReplyFileNameFromControl(void);
	CString GetNotifyCommandPathFromControl(void);
	CString GetNotifyCommandArgFromControl(void);

	CString GetAuthTargetString(__in BG_AUTH_TARGET authTarget);
	CString GetAuthSchemeString(__in BG_AUTH_SCHEME authScheme);
};
