#include "StdAfx.h"
#include "JobAdvancedSetting4Page.h"
#include "WTLCtrlUtil.h"
#include "BITSUtil.h"
#include "MiscUtil.h"


CJobAdvancedSetting4Page::CJobAdvancedSetting4Page(void):
m_bModified(false)
{
	NULL;
}


CJobAdvancedSetting4Page::~CJobAdvancedSetting4Page(void)
{
	NULL;
}


LRESULT CJobAdvancedSetting4Page::OnInitDialog( __in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/ )
{
	ATLASSERT(m_spJob);

	ATLVERIFY(DoDataExchange(FALSE));

	ATLVERIFY(InitTokenInformationControls());
	ATLVERIFY(RefreshUI());

	return TRUE;
}


int CJobAdvancedSetting4Page::OnApply(void)
{
	if (FALSE == m_bModified) {
		return 1;
	}

	m_bModified = false;

	if (false == IsBITS40Supported()) {
		return 1;
	}

	if (false == ModifyHelperTokenFlags()) {
		return 0;
	}

	ATLVERIFY(RefreshUI());

	return 1;
}


LRESULT CJobAdvancedSetting4Page::OnSetHelperTokenButtonDown(__in UINT /*uNotifyCode*/,
															 __in int /*nID*/,
															 __in CWindow /*wndCtl*/)
{
	DoDataExchange(TRUE);

	if (0 == ::IsUserAnAdmin()) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NEED_ADMIN_PRIVILEGE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	if (false == IsBITS40Supported()) {
		ATLASSERT(false);
		return 0;
	}
	ATLASSERT(m_spTokenOptions);

	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_SET_HELPER_TOKEN, IDR_MAINFRAME,
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::SetJobHelperToken(m_spTokenOptions);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_SET_HELPER_TOKEN_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	ATLVERIFY(RefreshTokenInformation());

	return 0;
}


LRESULT CJobAdvancedSetting4Page::OnClearHelperTokenButtonDown(__in UINT /*uNotifyCode*/,
															   __in int /*nID*/,
															   __in CWindow /*wndCtl*/)
{
	DoDataExchange(TRUE);

	if (false == IsBITS40Supported()) {
		ATLASSERT(false);
		return 0;
	}
	ATLASSERT(m_spTokenOptions);

	if (0 == ::IsUserAnAdmin()) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NEED_ADMIN_PRIVILEGE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, IDS_QUESTION_CLEAR_HELPER_TOKEN, IDR_MAINFRAME,
		MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		return 0;
	}

	HRESULT hr = BITSUtil::ClearJobHelperToken(m_spTokenOptions);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_CLEAR_HELPER_TOKEN_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	ATLVERIFY(RefreshTokenInformation());

	return 0;
}


void CJobAdvancedSetting4Page::OnModifyTokenFlags(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	SetModified(TRUE);
	m_bModified = true;

	return;
}


bool CJobAdvancedSetting4Page::InitTokenInformationControls(void)
{
	if (false == IsBITS40Supported() || 0 == ::IsUserAnAdmin()) {
		m_checkTokenLocalFile.EnableWindow(FALSE);
		m_checkTokenNetwork.EnableWindow(FALSE);
		m_buttonSetHelperToken.EnableWindow(FALSE);
		m_buttonClearHelperToken.EnableWindow(FALSE);
	}
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editTokenSid, IDS_NOT_APPLICABLE));

	return true;
}


bool CJobAdvancedSetting4Page::ModifyHelperTokenFlags(void)
{
	if (false == IsBITS40Supported()) {
		return false;
	}
	ATLASSERT(m_spTokenOptions);

	DWORD dwFlags = GetHelperTokenFlagsFromControls();
	HRESULT hr = BITSUtil::SetJobHelperTokenFlags(m_spTokenOptions, dwFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_EDIT_FAILED_WITH_CODE, hr, strErrorDescription);

		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return false;
	}

	return true;
}


DWORD CJobAdvancedSetting4Page::GetHelperTokenFlagsFromControls(void)
{
	DWORD dwFlags = 0;
	if (BST_CHECKED == m_checkTokenLocalFile.GetState()) {
		dwFlags |= BG_TOKEN_LOCAL_FILE;
	}
	if (BST_CHECKED == m_checkTokenNetwork.GetState()) {
		dwFlags |= BG_TOKEN_NETWORK;
	}

	return dwFlags;
}


bool CJobAdvancedSetting4Page::RefreshUI(void)
{
	return RefreshTokenInformation();
}


bool CJobAdvancedSetting4Page::RefreshTokenInformation(void)
{
	if (false == IsBITS40Supported()) {
		return true;
	}
	ATLASSERT(m_spTokenOptions);

	ATLVERIFY(RefreshTokenFlags());
	ATLVERIFY(RefreshTokenSid());

	return true;
}


bool CJobAdvancedSetting4Page::RefreshTokenFlags(void)
{
	if (false == IsBITS40Supported()) {
		return true;
	}
	ATLASSERT(m_spTokenOptions);

	DWORD dwFlags = 0;
	HRESULT hr = BITSUtil::GetJobHelperTokenFlags(m_spTokenOptions, &dwFlags);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	if (BG_TOKEN_LOCAL_FILE & dwFlags) {
		m_checkTokenLocalFile.SetCheck(BST_CHECKED);
	} else {
		m_checkTokenLocalFile.SetCheck(BST_UNCHECKED);
	}
	if (BG_TOKEN_NETWORK & dwFlags) {
		m_checkTokenNetwork.SetCheck(BST_CHECKED);
	} else {
		m_checkTokenNetwork.SetCheck(BST_UNCHECKED);
	}

	return true;
}


bool CJobAdvancedSetting4Page::RefreshTokenSid(void)
{
	if (false == IsBITS40Supported()) {
		return true;
	}
	ATLASSERT(m_spTokenOptions);

	CString strTokenSid;
	HRESULT hr = BITSUtil::GetJobHelperTokenSid(m_spTokenOptions, &strTokenSid);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}
	if (true == strTokenSid.IsEmpty()) {
		BOOL bResult = strTokenSid.LoadString(IDS_JOB_NO_HELPER_TOKEN);
		ATLVERIFY(bResult);
		WTLCtrlUtil::UpdateCommonControlText(m_editTokenSid, strTokenSid);

		m_buttonClearHelperToken.EnableWindow(FALSE);
	} else {
		CString strTmp;
		strTmp.Format(L"%s (%s)", MiscUtil::GetAccountNameFromSid(strTokenSid), strTokenSid);
		WTLCtrlUtil::UpdateCommonControlText(m_editTokenSid, strTmp);

		m_buttonClearHelperToken.EnableWindow(TRUE);
	}

	return true;
}


__checkReturn bool CJobAdvancedSetting4Page::IsBITS40Supported(void)
{
	if (!m_spTokenOptions) {
		return false;
	}

	return true;
}


void CJobAdvancedSetting4Page::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobAdvancedSetting4Page::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob) {
		ATLASSERT(false);
		m_spJob.Release();
	}

	m_spJob				= spJob;
	m_spTokenOptions	= spJob;
}