#include "StdAfx.h"
#include "JobMaximumDownloadTimeSettingDlg.h"
#include "MiscUtil.h"
#include "BITSUtil.h"
#include "WTLCtrlUtil.h"


CJobMaximumDownloadTimeSettingDlg::CJobMaximumDownloadTimeSettingDlg(void)
{
	NULL;
}


CJobMaximumDownloadTimeSettingDlg::~CJobMaximumDownloadTimeSettingDlg(void)
{
	NULL;
}


LRESULT CJobMaximumDownloadTimeSettingDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLASSERT(m_spJob4);

	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());
	ATLVERIFY(CenterWindow(GetParent()));

	return TRUE;
}


LRESULT CJobMaximumDownloadTimeSettingDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	BOOL bSuccess = FALSE;
	UINT ulMaxmumDownloadTime = GetDlgItemInt(IDC_EDIT_MAXIMUM_DOWNLOAD_TIME, &bSuccess, FALSE);
	if (FALSE == bSuccess) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_MAXIMUM_DOWNLOAD_TIME_VALUE, IDR_MAINFRAME, MB_ICONINFORMATION | MB_OK);

		return 0;
	}

	HRESULT hr = BITSUtil::SetJobMaximumDownloadTime(m_spJob4, ulMaxmumDownloadTime);
	if (FAILED(hr)) {
		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		CString strMessage;
		strMessage.Format(IDS_ERR_JOB_MAXIMUM_DOWNLOAD_TIME_CHANGE_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	EndDialog(nID);

	return 0;
}


LRESULT CJobMaximumDownloadTimeSettingDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	EndDialog(nID);

	return 0;
}


LRESULT CJobMaximumDownloadTimeSettingDlg::OnEnChangeMaximumDownloadTime(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CString strMaximumDownloadTime;
	m_editMaximumDownloadTime.GetWindowText(strMaximumDownloadTime);

	if (true == strMaximumDownloadTime.IsEmpty()) {
		m_buttonOK.EnableWindow(FALSE);
	} else {
		m_buttonOK.EnableWindow(TRUE);
	}

	return 0;
}


bool CJobMaximumDownloadTimeSettingDlg::InitDialogControls(void)
{
	ULONG ulMaximumDownloadTime = 0;
	HRESULT hr = BITSUtil::GetJobMaximumDownloadTime(m_spJob4, &ulMaximumDownloadTime);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	CString strMaximumDownloadTime;
	strMaximumDownloadTime.Format(L"%u", ulMaximumDownloadTime);
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editMaximumDownloadTime, strMaximumDownloadTime));

	ATLVERIFY(MiscUtil::SetUINTMaxTextLimit(&m_editMaximumDownloadTime));

	return true;

}


void CJobMaximumDownloadTimeSettingDlg::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobMaximumDownloadTimeSettingDlg::SetJobIF(__in const CComPtr<IBackgroundCopyJob4>& spJob4)
{
	ATLASSERT(spJob4);

	if (m_spJob4) {
		ATLASSERT(false);
		m_spJob4.Release();
	}

	m_spJob4 = spJob4;

	return;
}