#pragma once
#include "JobGeneralPropertyPage.h"
#include "JobStatusPropertyPage.h"
#include "JobProxySettingPage.h"
#include "JobErrorDetailsPage.h"
#include "JobAdvancedSetting1Page.h"
#include "JobAdvancedSetting2Page.h"
#include "JobAdvancedSetting3Page.h"
#include "JobAdvancedSetting4Page.h"
#include "JobFileDetailsPage.h"


class CJobPropertySheet: public CPropertySheetImpl<CJobPropertySheet>
{
public:
	BEGIN_MSG_MAP(CJobPropertySheet)
		CHAIN_MSG_MAP(CPropertySheetImpl<CJobPropertySheet>)
	END_MSG_MAP()

	CJobPropertySheet(__in ATL::_U_STRINGorID title = static_cast<LPCWSTR>(NULL), UINT uStartPage = 0,
		HWND hWndParent = NULL);

	static int CALLBACK PropSheetCallback(__in HWND hWnd, __in UINT uMsg, __in LPARAM lParam);

	void AddPages(void);
	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);
	void SetJobEditMode(__in JOB_EDIT_MODE jobEditMode);

private:
	CJobGeneralPropertyPage m_jobGeneralPage;
	CJobStatusPropertyPage	m_jobStatusPage;
	CJobProxySettingPage	m_jobProxySettingPage;
	CJobErrorDetailsPage	m_jobErrorDetailsPage;
	CJobFileDetailsPage		m_jobFileDetailsPage;
	CJobAdvancedSetting1Page m_jobAdvancedSetting1Page;
	CJobAdvancedSetting2Page m_jobAdvancedSetting2Page;
	CJobAdvancedSetting3Page m_jobAdvancedSetting3Page;
	CJobAdvancedSetting4Page m_jobAdvancedSetting4Page;
};
