#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobProxySettingPage: public CPropertyPageImpl<CJobProxySettingPage>,
	public CWinDataExchange<CJobProxySettingPage>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_PROXY_SETTING };

	BEGIN_DDX_MAP(CJobProxySettingPage)
		DDX_CONTROL_HANDLE(IDC_COMBO_PROXY_USAGE,		m_comboProxySetting)
		DDX_CONTROL_HANDLE(IDC_EDIT_PROXY_URL,			m_editProxyUrl)
		DDX_TEXT(IDC_EDIT_PROXY_URL,					m_strProxyUrl)
		DDX_CONTROL_HANDLE(IDC_EDIT_PROXY_BYPASS_LIST,	m_editProxyBypassList)
		DDX_TEXT(IDC_EDIT_PROXY_BYPASS_LIST,			m_strProxyBypassList)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobProxySettingPage)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_HANDLER_EX(IDC_COMBO_PROXY_USAGE,	CBN_SELCHANGE,	OnSelChangeProxyUsage)
		COMMAND_HANDLER_EX(IDC_EDIT_PROXY_URL,			EN_CHANGE,	OnEnChangeProxyUrl)
		COMMAND_HANDLER_EX(IDC_EDIT_PROXY_BYPASS_LIST,	EN_CHANGE,	OnEnChangeProxyBypassList)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobProxySettingPage>)
	END_MSG_MAP()

	CJobProxySettingPage(void);
	~CJobProxySettingPage(void);

	int OnApply(void);
	BOOL OnKillActive(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);


private:
	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;

	CComboBox	m_comboProxySetting;
	CEdit		m_editProxyUrl;
	CString		m_strProxyUrl;
	CEdit		m_editProxyBypassList;
	CString		m_strProxyBypassList;

	bool		m_bModified;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnSelChangeProxyUsage(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeProxyUrl(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnEnChangeProxyBypassList(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitPropertyPageControls(void);
	bool InitProxySettingComboBox(void);

	__checkReturn BG_JOB_PROXY_USAGE GetProxySettingComboBox(void);
	bool SetProxySettingComboBox(__in BG_JOB_PROXY_USAGE jobProxyUsage);

	bool Refresh(__in BG_JOB_PROXY_USAGE jobProxyUsage, __in LPCWSTR lpszProxyList, __in LPCWSTR lpszProxyBypassList);
	bool RefreshByJobObject(void);

	bool CheckInputAndShowErrorMessage(void);
};
