#include "stdafx.h"
#include "WTLCtrlUtil.h"

__checkReturn int WTLCtrlUtil::AddStringAndSetData(__in CComboBox& comboBox, __in LPCWSTR lpszItemText,
												   __in DWORD_PTR dwItemData)
{
	if (NULL == lpszItemText) {
		ATLASSERT(false);
		return CB_ERR;
	}

	int nIndex = comboBox.AddString(lpszItemText);
	if (CB_ERR == nIndex) {
		ATLASSERT(false);
		return CB_ERR;
	}
	int nResult = comboBox.SetItemData(nIndex, dwItemData);
	if (CB_ERR == nResult) {
		ATLASSERT(false);
		return CB_ERR;
	}

	return nIndex;
}

__checkReturn int WTLCtrlUtil::AddStringAndSetData(__in CComboBox& comboBox, __in UINT nID, __in DWORD_PTR dwItemData)
{
	CString strItemText;

	if (0 == strItemText.LoadString(nID)) {
		ATLASSERT(false);
		return CB_ERR;
	}

	return AddStringAndSetData(comboBox, static_cast<LPCWSTR>(strItemText), dwItemData);
}


bool WTLCtrlUtil::UpdateCommonControlText(__in CWindow control, __in LPCWSTR lpszText)
{
	if (NULL == lpszText) {
		ATLASSERT(false);
		return false;
	}

	CString strOldText;
	control.GetWindowText(strOldText);

	if (0 != strOldText.Compare(lpszText)) {
		control.SetWindowText(lpszText);
	}

	return true;
}


bool WTLCtrlUtil::UpdateCommonControlText(__in CWindow control, __in UINT nID)
{
	CString strNewText;
	if (0 == strNewText.LoadString(nID)) {
		ATLASSERT(false);
		return false;
	}

	CString strOldText;
	control.GetWindowText(strOldText);

	if (0 != strOldText.Compare(strNewText)) {
		control.SetWindowText(strNewText);
	}

	return true;
}