#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobAdvancedSetting4Page: public CPropertyPageImpl<CJobAdvancedSetting4Page>,
	public CWinDataExchange<CJobAdvancedSetting4Page>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_ADVANCED_SETTING4 };

	BEGIN_DDX_MAP(CJobAdvancedSetting4Page)
		DDX_CONTROL_HANDLE(IDC_EDIT_TOKEN_SID,				m_editTokenSid)
		DDX_CONTROL_HANDLE(IDC_BUTTON_SET_HELPER_TOKEN,		m_buttonSetHelperToken)
		DDX_CONTROL_HANDLE(IDC_BUTTON_CLEAR_HELPER_TOKEN,	m_buttonClearHelperToken)
		DDX_CONTROL_HANDLE(IDC_CHECK_TOKEN_LOCAL_FILE,		m_checkTokenLocalFile)
		DDX_CONTROL_HANDLE(IDC_CHECK_TOKEN_NETWORK,			m_checkTokenNetwork)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobAdvancedSetting4Page)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_HANDLER_EX(IDC_BUTTON_SET_HELPER_TOKEN,		BN_CLICKED,		OnSetHelperTokenButtonDown)
		COMMAND_HANDLER_EX(IDC_BUTTON_CLEAR_HELPER_TOKEN,	BN_CLICKED,		OnClearHelperTokenButtonDown)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_CHECK_TOKEN_LOCAL_FILE, IDC_CHECK_TOKEN_NETWORK, BN_CLICKED, OnModifyTokenFlags)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobAdvancedSetting4Page>)
	END_MSG_MAP()

	CJobAdvancedSetting4Page(void);
	~CJobAdvancedSetting4Page(void);

	int OnApply(void);

	__checkReturn bool IsBITS40Supported(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

private:
	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComPtr<IBackgroundCopyJob>		m_spJob;
	CComPtr<IBitsTokenOptions>		m_spTokenOptions;
	bool							m_bModified;
	
	CEdit		m_editTokenSid;
	CButton		m_buttonSetHelperToken;
	CButton		m_buttonClearHelperToken;
	CButton		m_checkTokenLocalFile;
	CButton		m_checkTokenNetwork;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnSetHelperTokenButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	LRESULT OnClearHelperTokenButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	void OnModifyTokenFlags(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	
	bool InitPropertyPageControls(void);
	bool InitTokenInformationControls(void);

	bool RefreshUI(void);
	bool RefreshTokenInformation(void);
	bool RefreshTokenFlags(void);
	bool RefreshTokenSid(void);

	bool ModifyHelperTokenFlags(void);

	DWORD GetHelperTokenFlagsFromControls(void);
};
