#pragma once	
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobAdvancedSetting2Page: public CPropertyPageImpl<CJobAdvancedSetting2Page>,
	public CWinDataExchange<CJobAdvancedSetting2Page>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_ADVANCED_SETTING2 };

	BEGIN_DDX_MAP(CJobAdvancedSetting2Page)
		DDX_CONTROL_HANDLE(IDC_CHECK_ACL_COPY_FILE_OWNER,				m_checkACLCopyFileOwner)
		DDX_CONTROL_HANDLE(IDC_CHECK_ACL_COPY_FILE_GROUP,				m_checkACLCopyFileGroup)
		DDX_CONTROL_HANDLE(IDC_CHECK_ACL_COPY_FILE_DACL,				m_checkACLCopyFileDACL)
		DDX_CONTROL_HANDLE(IDC_CHECK_ACL_COPY_FILE_SACL,				m_checkACLCopyFileSACL)
		DDX_CONTROL_HANDLE(IDC_CHECK_SSL_ENABLE_CRL_CHECK,				m_checkSSLEnableCRLCheck)
		DDX_CONTROL_HANDLE(IDC_CHECK_SSL_IGNORE_CERT_CN_INVALID,		m_checkSSLIgnoreCertCNInvalid)
		DDX_CONTROL_HANDLE(IDC_CHECK_SSL_IGNORE_CERT_DATE_INVALID,		m_checkSSLIgnoreCertDateInvalid)
		DDX_CONTROL_HANDLE(IDC_CHECK_SSL_IGNORE_UNKNOWN_CA,				m_checkSSLIgnoreUnknownCA)
		DDX_CONTROL_HANDLE(IDC_CHECK_SSL_IGNORE_CERT_WRONG_USAGE,		m_checkSSLIgnoreCertWrongUsage)
		DDX_CONTROL_HANDLE(IDC_CHECK_ENABLE_PEERCACHING_CLIENT,			m_checkEnabelPeerCachingClient)
		DDX_CONTROL_HANDLE(IDC_CHECK_ENABLE_PEERCACHING_SERVER,			m_checkEnabelPeerCachingServer)
		DDX_CONTROL_HANDLE(IDC_COMBO_HTTP_REDIRECT_POLICY,				m_comboHttpRedirectPolicy)
		DDX_CONTROL_HANDLE(IDC_CHECK_REDIRECT_POLICY_ALLOW_HTTPS_TO_HTTP, m_checkRedirectPolicyAllowHttpsToHttp)
		DDX_CONTROL_HANDLE(IDC_STATIC_INTEGRITY_LEVEL,					m_staticIntegrityLevel)
		DDX_CONTROL_HANDLE(IDC_STATIC_ELEVATION_STATE,					m_staticElevationState)
		DDX_CONTROL_HANDLE(IDC_STATIC_MAXIMUM_DOWNLOAD_TIME,			m_staticMaximumDownloadTime)
		DDX_CONTROL_HANDLE(IDC_BUTTON_CHANGE_MAXIMUM_DOWNLOAD_TIME,		m_buttonChangeMaximumDownloadTime)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobAdvancedSetting2Page)
		MSG_WM_INITDIALOG(OnInitDialog)
		COMMAND_HANDLER_EX(IDC_COMBO_HTTP_REDIRECT_POLICY,					CBN_SELCHANGE,	OnModify)
		COMMAND_HANDLER_EX(IDC_CHECK_REDIRECT_POLICY_ALLOW_HTTPS_TO_HTTP,	BN_CLICKED,		OnModify)
		COMMAND_HANDLER_EX(IDC_BUTTON_CHANGE_MAXIMUM_DOWNLOAD_TIME,			BN_CLICKED,		OnChangeMaximumDownloadTimeButtonDown)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_CHECK_ACL_COPY_FILE_OWNER,		IDC_CHECK_ACL_COPY_FILE_SACL,			BN_CLICKED, OnModify)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_CHECK_SSL_ENABLE_CRL_CHECK,		IDC_CHECK_SSL_IGNORE_CERT_WRONG_USAGE,	BN_CLICKED, OnModify)
		COMMAND_RANGE_CODE_HANDLER_EX(IDC_CHECK_ENABLE_PEERCACHING_CLIENT,	IDC_CHECK_ENABLE_PEERCACHING_SERVER,	BN_CLICKED, OnModify)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobAdvancedSetting2Page>)
	END_MSG_MAP()

	CJobAdvancedSetting2Page(void);
	~CJobAdvancedSetting2Page(void);

	int OnApply(void);

	__checkReturn bool IsBITS20Supported(void);
	__checkReturn bool IsBITS25Supported(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

private:
	CButton	m_checkACLCopyFileOwner;
	CButton m_checkACLCopyFileGroup;
	CButton m_checkACLCopyFileDACL;
	CButton m_checkACLCopyFileSACL;
	CButton m_checkSSLEnableCRLCheck;
	CButton m_checkSSLIgnoreCertCNInvalid;
	CButton m_checkSSLIgnoreCertDateInvalid;
	CButton m_checkSSLIgnoreUnknownCA;
	CButton m_checkSSLIgnoreCertWrongUsage;
	CButton	m_checkEnabelPeerCachingClient;
	CButton	m_checkEnabelPeerCachingServer;
	CComboBox m_comboHttpRedirectPolicy;
	CButton m_checkRedirectPolicyAllowHttpsToHttp;
	CStatic	m_staticIntegrityLevel;
	CStatic m_staticElevationState;
	CStatic m_staticMaximumDownloadTime;
	CButton	m_buttonChangeMaximumDownloadTime;

	CComPtr<IBackgroundCopyManager>				m_spBITSManager;
	CComQIPtr<IBackgroundCopyJob3>				m_spJob3;
	CComQIPtr<IBackgroundCopyJob4>				m_spJob4;
	CComQIPtr<IBackgroundCopyJobHttpOptions>	m_spHttpOptions;

	bool m_bModified;
	BG_JOB_TYPE m_jobType;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnChangeMaximumDownloadTimeButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	void OnModify(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

	bool InitPropertyPageControls(void);
	bool InitPropertyPageControlsForBITS20(void);
	bool InitPropertyPageControlsForBITS25(void);
	bool InitHttpRedirectPolicyComboBox(void);

	bool EnableAllHttpOptionControls(BOOL bEnable);
	bool EnableAllPeerControls(BOOL bEnable);

	bool RefreshUI(void);
	bool RefreshFileACLInfo(void);
	bool RefreshHttpsOption(void);
	bool RefreshHttpRedirectPolicyInfo(void);
	bool RefreshPeerInfo(void);
	bool RefreshSecurityState(void);
	bool RefreshOtherTimeoutInfo(void);

	bool ModifyFileACLFlags(void);
	bool ModifyHttpOptions(void);
	bool ModifyPeerCachingFlags(void);

	__checkReturn DWORD GetHttpRedirectPolicyFromComboBox(void);
	bool SetHttpRedirectPolicyToComboBox(__in DWORD dwHttpRedirectPolicy);

	__checkReturn DWORD GetFileACLFlagsFromControls(void);
	__checkReturn DWORD GetHttpOptionFlagsFromControls(void);
	__checkReturn DWORD GetPeerCachingFlagsFromControls(void);
};
