#include "StdAfx.h"
#include "JobFileDetailsPage.h"
#include "BITSUtil.h"
#include "WTLCtrlUtil.h"
#include "MiscUtil.h"


CJobFileDetailsPage::CJobFileDetailsPage(void)
{
	NULL;
}


CJobFileDetailsPage::~CJobFileDetailsPage(void)
{
	NULL;
}


LRESULT CJobFileDetailsPage::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitPropertyPageControls());
	ATLVERIFY(ClearAllTextControls());
	ATLVERIFY(RefreshUI());

	return 0;
}


LRESULT CJobFileDetailsPage::OnDestroy(void)
{
	ATLVERIFY(UninitRemoteFileNameComboBox());

	return 0;
}


LRESULT CJobFileDetailsPage::OnSetValidationStateButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
															__in CWindow /*wndCtl*/)
{
	BOOL bValidated = FALSE;
	if (false == GetJobFileValidationState(&bValidated)) {
		ATLASSERT(false);
		return 0;
	}

	UINT uStringId = IDS_QUESTION_UNSET_VALIDATION_STATE;
	if (FALSE == bValidated) {
		uStringId = IDS_QUESTION_SET_VALIDATION_STATE;
	}

	CString strMessage;
	if (FALSE == strMessage.LoadString(uStringId)) {
		ATLASSERT(false);
		return 0;
	}

	INT_PTR nAnswer = MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONQUESTION | MB_YESNO);
	if (IDNO == nAnswer) {
		ATLASSERT(false);
		return 0;
	}

	CComPtr<IBackgroundCopyFile> spFile;
	if (false == GetSelectedJobFile(reinterpret_cast<CComPtr<IBackgroundCopyFile>*>(&spFile))) {
		ATLASSERT(false);

		MiscUtil::ShowMessageBox(m_hWnd, IDS_ERR_JOB_EDIT_FAILED, IDR_MAINFRAME, MB_ICONERROR | MB_OK);
		return 0;
	}

	CComQIPtr<IBackgroundCopyFile3> spFile3 = spFile;
	ATLASSERT(spFile3);

	HRESULT hr = BITSUtil::SetJobFileValidationState(spFile3, bValidated? FALSE: TRUE);
	if (FAILED(hr)) {
		ATLASSERT(false);

		CString strErrorDescription;
		ATLVERIFY(SUCCEEDED(BITSUtil::GetBITSErrorDescription(m_spBITSManager, hr, &strErrorDescription)));

		strMessage.Format(IDS_ERR_JOB_CHANGE_VALIDATION_STATE_FAILED_WITH_CODE, hr, strErrorDescription);
		MiscUtil::ShowMessageBox(m_hWnd, strMessage, NULL, MB_ICONERROR | MB_OK);

		return 0;
	}

	ATLVERIFY(RefreshUI());

	return 0;
}


void CJobFileDetailsPage::OnRemoteFileNameComboBoxDropDown(__in UINT /*uNotifyCode*/, __in int /*nID*/,
														   __in CWindow /*wndCtl*/)
{
	ATLVERIFY(ResetRemoteFileNameComboBox());

	return;
}


void CJobFileDetailsPage::OnRemoteFileNameComboBoxSelChange(__in UINT /*uNotifyCode*/, __in int /*nID*/,
															__in CWindow /*wndCtl*/)
{
	ATLVERIFY(RefreshFileInfo());

	return;
}


bool CJobFileDetailsPage::InitPropertyPageControls(void)
{
	ATLVERIFY(InitRemoteFileNameComboBox());
	ATLVERIFY(InitFileRangeList());

	return true;
}


bool CJobFileDetailsPage::InitFileRangeList(void)
{
	CString strColumnName;
	if (0 == strColumnName.LoadString(IDS_COLUMN_FILE_OFFSET)) {
		ATLASSERT(false);
		return false;
	}
	int nResult = m_listFileRange.InsertColumn(FILE_OFFSET_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		FILE_OFFSET_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	if (0 == strColumnName.LoadString(IDS_COLUMN_FILE_SIZE)) {
		ATLASSERT(false);
		return false;
	}
	nResult = m_listFileRange.InsertColumn(FILE_SIZE_COLUMN_INDEX, strColumnName, LVCFMT_LEFT,
		FILE_SIZE_COLUMN_WIDTH);
	if (-1 == nResult) {
		ATLASSERT(false);
		return false;
	}

	m_listFileRange.SetExtendedListViewStyle(m_listFileRange.GetExtendedListViewStyle() |
		LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);

	return true;
}


bool CJobFileDetailsPage::InitRemoteFileNameComboBox(void)
{
	if (!m_spJob2) {
		ATLASSERT(false);

		return false;
	}

	CComPtr<IEnumBackgroundCopyFiles> spEnumFiles;
	HRESULT hr = m_spJob2->EnumFiles(&spEnumFiles);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	ULONG ulFileCount = 0;
	hr = spEnumFiles->GetCount(&ulFileCount);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (0 == ulFileCount) {
		return true;
	}

	while (true) {
		CComPtr<IBackgroundCopyFile> spFiles;
		ULONG ulFetched = 0;
		hr = spEnumFiles->Next(1, &spFiles, &ulFetched);
		if (FAILED(hr) || S_FALSE == hr) {
			ATLASSERT(SUCCEEDED(hr));
			break;
		}

		CString strRemoteFileName;
		hr = BITSUtil::GetJobRemotelFileName(spFiles, &strRemoteFileName);
		if (FAILED(hr)) {
			ATLASSERT(false);
			continue;
		}
		int nIndex = WTLCtrlUtil::AddStringAndSetData(m_comboRemoteFileName, strRemoteFileName, 
			reinterpret_cast<DWORD_PTR>(spFiles.Detach()));
		if (CB_ERR == nIndex) {
			ATLASSERT(false);
			continue;
		}
	}

	m_comboRemoteFileName.SetCurSel(0);

	return true;
}


bool CJobFileDetailsPage::UninitRemoteFileNameComboBox(void)
{
	for (int nIndex = 0; nIndex < m_comboRemoteFileName.GetCount(); nIndex++) {
		CComPtr<IBackgroundCopyFile> spFile;
		spFile.Attach(reinterpret_cast<IBackgroundCopyFile*>(m_comboRemoteFileName.GetItemData(nIndex)));
		spFile.Release();
	}

	m_comboRemoteFileName.ResetContent();
	return true;
}


__checkReturn bool CJobFileDetailsPage::IsBITS20Supported(void)
{
	if (!m_spJob3) {
		return false;
	}

	return true;
}


bool CJobFileDetailsPage::RefreshUI(void)
{
	ATLVERIFY(RefreshFileInfo());
	ATLVERIFY(RefreshFileRangeInfo());

	return true;
}


bool CJobFileDetailsPage::RefreshFileInfo(void)
{
	CComPtr<IBackgroundCopyFile> spFile;
	if (false == GetSelectedJobFile(reinterpret_cast<CComPtr<IBackgroundCopyFile>*>(&spFile))) {
		ATLVERIFY(ClearAllTextControls());
		return true;
	}

	bool bResult = InternalRefreshFileInfo(spFile);

	return bResult;
}


bool CJobFileDetailsPage::RefreshFileRangeInfo(void)
{
	m_listFileRange.DeleteAllItems();

	CComPtr<IBackgroundCopyFile> spFile;
	if (false == GetSelectedJobFile(reinterpret_cast<CComPtr<IBackgroundCopyFile>*>(&spFile))) {
		return true;
	}
	CComQIPtr<IBackgroundCopyFile2> spFile2 = spFile;
	if (!spFile2) {
		return true;
	}

	DWORD dwRangeCount = 0;
	BG_FILE_RANGE* pFileRange = NULL;
	HRESULT hr = BITSUtil::GetJobFileRange(spFile2, &dwRangeCount, &pFileRange);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	if (0 == dwRangeCount) {
		if (NULL != pFileRange) {
			::CoTaskMemFree(pFileRange);
			pFileRange = NULL;
		}
		return true;
	}

	CString strEOF = MiscUtil::LoadEOFString();

	for (DWORD dwIndex = 0; dwIndex < dwRangeCount; dwIndex++) {
		CString strOffset;
		strOffset.Format(L"%I64u", pFileRange[dwIndex].InitialOffset);
		CString strSize;
		if (BG_LENGTH_TO_EOF == pFileRange[dwIndex].Length) {
			strSize = strEOF;
		} else {
			strSize.Format(L"%I64u", pFileRange[dwIndex].Length);
		}
		int nItemIndex = m_listFileRange.GetItemCount();
		int nNewItemIndex = m_listFileRange.InsertItem(nItemIndex, strOffset);
		ATLASSERT(-1 != nNewItemIndex);

		ATLVERIFY(m_listFileRange.SetItemText(nNewItemIndex, FILE_SIZE_COLUMN_INDEX, strSize));
	}
	if (NULL != pFileRange) {
		::CoTaskMemFree(pFileRange);
		pFileRange = NULL;
	}

	return true;
}


bool CJobFileDetailsPage::InternalRefreshFileInfo(__in const CComPtr<IBackgroundCopyFile>& spFile)
{
	if (!spFile) {
		ATLASSERT(false);
		return false;
	}

	CString strLocalFileName;
	HRESULT hr = BITSUtil::GetJobLocalFileName(spFile, &strLocalFileName);
	if (SUCCEEDED(hr)) {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editLocalFileName, strLocalFileName));
	} else {
		ATLASSERT(false);
		return false;
	}

	BG_FILE_PROGRESS progress = {0};
	hr = BITSUtil::GetJobFileProgress(spFile, &progress);
	if (SUCCEEDED(hr)) {
		if (BG_SIZE_UNKNOWN == progress.BytesTotal) {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticFileSize, L"0"));
		} else {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticFileSize, MiscUtil::FormatNumber(progress.BytesTotal)));
		}

		if (BG_SIZE_UNKNOWN == progress.BytesTransferred) {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred, L"0"));
		} else {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred, MiscUtil::FormatNumber(progress.BytesTransferred)));
		}

		if (TRUE == progress.Completed) {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsCompleted, IDS_JOB_FILE_STATE_COMPLETED));
		} else {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsCompleted, IDS_JOB_FILE_STATE_NOT_COMPLETED));
		}
	} else {
		ATLASSERT(false);
		return false;
	}

	CComQIPtr<IBackgroundCopyFile3> spFile3 = spFile;
	if (spFile3) {
		ATLVERIFY(InternalRefreshFileInfo3(spFile3));
		m_buttonSetValidationState.EnableWindow(TRUE);
	} else {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editTempFileName,			IDS_NOT_APPLICABLE));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticValidationState,		IDS_NOT_APPLICABLE));
		m_buttonSetValidationState.EnableWindow(FALSE);
	}

	CComQIPtr<IBackgroundCopyFile4> spFile4 = spFile;
	if (spFile4) {
		ATLVERIFY(InternalRefreshFileInfo4(spFile4));
	} else {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromOrigin,	IDS_NOT_APPLICABLE));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromPeers,	IDS_NOT_APPLICABLE));
	}

	return true;
}


bool CJobFileDetailsPage::InternalRefreshFileInfo3(__in const CComPtr<IBackgroundCopyFile3>& spFile3)
{
	ATLASSERT(spFile3);

	CString strTemporaryName;
	HRESULT hr = BITSUtil::GetJobFileTemporaryName(spFile3, &strTemporaryName);
	if (SUCCEEDED(hr)) {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editTempFileName, strTemporaryName));
	} else {
		ATLASSERT(false);
		return false;
	}

	BOOL bValidated = FALSE;
	hr = BITSUtil::GetJobFileValidationState(spFile3, &bValidated);
	if (SUCCEEDED(hr)) {
		if (TRUE == bValidated) {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticValidationState, IDS_JOB_FILE_STATE_VALIDATED));
		} else {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticValidationState, IDS_JOB_FILE_STATE_NOT_VALIDATED));
		}
	} else {
		ATLASSERT(false);
		return false;
	}

	BOOL bIsDownloadedPeer = FALSE;
	hr = BITSUtil::IsJobFileDownloadedFromPeer(spFile3, &bIsDownloadedPeer);
	if (SUCCEEDED(hr)) {
		if (TRUE == bIsDownloadedPeer) {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsDonwnloadedFromPeer, IDS_MSG_YES));
		} else {
			ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsDonwnloadedFromPeer, IDS_MSG_NO));
		}
	} else {
		ATLASSERT(false);
		return false;
	}

	return true;
}


bool CJobFileDetailsPage::InternalRefreshFileInfo4(__in const CComPtr<IBackgroundCopyFile4>& spFile4)
{
	ATLASSERT(spFile4);

	UINT64 uFromOrigin	= 0;
	UINT64 uFromPeers	= 0;

	HRESULT hr = BITSUtil::GetJobPeerDownloadStats(spFile4, &uFromOrigin, &uFromPeers);
	if (SUCCEEDED(hr)) {
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromOrigin,	MiscUtil::FormatNumber(uFromOrigin)));
		ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromPeers,	MiscUtil::FormatNumber(uFromPeers)));
	} else {
		ATLASSERT(false);
		return false;
	}

	return true;
}


bool CJobFileDetailsPage::ResetRemoteFileNameComboBox(void)
{
	ATLVERIFY(UninitRemoteFileNameComboBox());
	ATLVERIFY(InitRemoteFileNameComboBox());

	return true;
}


bool CJobFileDetailsPage::ClearAllTextControls(void)
{
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editLocalFileName,			IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editTempFileName,			IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticFileSize,			IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferred,		IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsCompleted,			IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticValidationState,		IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromOrigin,		IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticByteTransferredFromPeers,		IDS_NOT_APPLICABLE));
	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_staticIsDonwnloadedFromPeer,			IDS_NOT_APPLICABLE));

	m_buttonSetValidationState.EnableWindow(FALSE);

	return true;
}


bool CJobFileDetailsPage::GetSelectedJobFile(__out CComPtr<IBackgroundCopyFile>* pspFile)
{
	if (NULL == pspFile) {
		ATLASSERT(false);
		return false;
	}

	int nCurSel = m_comboRemoteFileName.GetCurSel();
	if (CB_ERR == nCurSel) {
		return false;
	}

	CComPtr<IBackgroundCopyFile> spFile;
	*pspFile = reinterpret_cast<IBackgroundCopyFile*>(m_comboRemoteFileName.GetItemData(nCurSel));
	if (!(*pspFile)) {
		ATLASSERT(false);
		return false;
	}

	return true;
}


bool CJobFileDetailsPage::GetJobFileValidationState(__out BOOL* pbValidated)
{
	if (NULL == pbValidated) {
		ATLASSERT(false);
		return false;
	}

	CComPtr<IBackgroundCopyFile> spFile;
	if (false == GetSelectedJobFile(reinterpret_cast<CComPtr<IBackgroundCopyFile>*>(&spFile))) {
		return false;
	}

	CComQIPtr<IBackgroundCopyFile3> spFile3 = spFile;
	if (!spFile3) {
		ATLASSERT(false);
		return false;
	}

	HRESULT hr = BITSUtil::GetJobFileValidationState(spFile3, pbValidated);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return false;
	}

	return true;
}


void CJobFileDetailsPage::SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager)
{
	ATLASSERT(spBITSManager);
	if (m_spBITSManager) {
		ATLASSERT(false);
		m_spBITSManager.Release();
	}

	m_spBITSManager = spBITSManager;

	return;
}


void CJobFileDetailsPage::SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob)
{
	ATLASSERT(spJob);
	if (m_spJob2) {
		ATLASSERT(false);
		m_spJob2.Release();
	}
	m_spJob2 = spJob;

	if (m_spJob3) {
		ATLASSERT(false);
		m_spJob3.Release();
	}
	m_spJob3 = spJob;

	if (m_spJob4) {
		ATLASSERT(false);
		m_spJob4.Release();
	}
	m_spJob4 = spJob;

	return;
}

