#include "StdAfx.h"
#include "StringDef.h"
#include "JobEditNotifyCommandDlg.h"
#include "MiscUtil.h"
#include "WTLCtrlUtil.h"


CJobEditNotifyCommandDlg::CJobEditNotifyCommandDlg(void)
{
	NULL;
}


CJobEditNotifyCommandDlg::~CJobEditNotifyCommandDlg(void)
{
	NULL;
}


LRESULT CJobEditNotifyCommandDlg::OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/)
{
	ATLVERIFY(CenterWindow(GetParent()));
	ATLVERIFY(DoDataExchange(FALSE));
	ATLVERIFY(InitDialogControls());

	return TRUE;
}


LRESULT CJobEditNotifyCommandDlg::OnOK(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	if (false == CheckNotifyCommandPath()) {
		return 0;
	}

	ATLVERIFY(RefreshNotifyCommandVariables());

	EndDialog(nID);

	return 0;
}


LRESULT CJobEditNotifyCommandDlg::OnCancel(__in UINT /*uNotifyCode*/, __in int nID, __in CWindow /*wndCtl*/)
{
	EndDialog(nID);

	return 0;
}


LRESULT CJobEditNotifyCommandDlg::OnBrowseButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/)
{
	CFileDialog dlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, REPLY_FILE_EXTENSION_FILTER);
	INT_PTR nAnswer = dlg.DoModal(m_hWnd);
	if (IDCANCEL == nAnswer) {
		return 0;
	}
	m_strNotifyCommandPath = dlg.m_ofn.lpstrFile;

	ATLVERIFY(WTLCtrlUtil::UpdateCommonControlText(m_editNotifyCommandPath, m_strNotifyCommandPath));
	m_editNotifyCommandPath.SetFocus();

	return 0;
}


bool CJobEditNotifyCommandDlg::InitDialogControls(void)
{
	m_editNotifyCommandPath.SetWindowText(m_strNotifyCommandPath);
	m_editNotifyCommandArg.SetWindowText(m_strNotifyCommandArg);

	return true;
}


bool CJobEditNotifyCommandDlg::RefreshNotifyCommandVariables(void)
{
	m_editNotifyCommandPath.GetWindowText(m_strNotifyCommandPath);
	m_editNotifyCommandArg.GetWindowText(m_strNotifyCommandArg);

	return true;
}


__checkReturn bool CJobEditNotifyCommandDlg::CheckNotifyCommandPath(void)
{
	ATLVERIFY(RefreshNotifyCommandVariables());

	if (true == m_strNotifyCommandPath.IsEmpty() && true == m_strNotifyCommandArg.IsEmpty()) {
		return true;
	}

	BOOL bIsRelative	= ::PathIsRelative(m_strNotifyCommandPath);
	BOOL bIsDirectory	= ::PathIsDirectory(m_strNotifyCommandPath);
	BOOL bIsRoot		= ::PathIsRoot(m_strNotifyCommandPath);
	if (TRUE == bIsRelative || TRUE == bIsDirectory || TRUE == bIsRoot) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_INVALID_NOTIFY_COMMAND_PATH, IDR_MAINFRAME, MB_OK | MB_ICONINFORMATION);
		m_editNotifyCommandPath.SetFocus();
		return false;
	}

	BOOL bExist	= ::PathFileExists(m_strNotifyCommandPath);
	if (FALSE == bExist) {
		MiscUtil::ShowMessageBox(m_hWnd, IDS_MSG_NOTIFY_COMMAND_PATH_NOT_FOUND, IDR_MAINFRAME, MB_OK | MB_ICONINFORMATION);
		m_editNotifyCommandPath.SetFocus();
		return false;
	}

	return true;
}


__checkReturn CString CJobEditNotifyCommandDlg::GetNotifyCommandPath(void)
{
	return m_strNotifyCommandPath;
}


bool CJobEditNotifyCommandDlg::SetNotifyCommandPath(__in LPCWSTR lpszNotifyCommandPath)
{
	if (NULL == lpszNotifyCommandPath) {
		ATLASSERT(false);
		return false;
	}

	m_strNotifyCommandPath = lpszNotifyCommandPath;

	return true;
}


__checkReturn CString CJobEditNotifyCommandDlg::GetNotifyCommandArg(void)
{
	return m_strNotifyCommandArg;
}


bool CJobEditNotifyCommandDlg::SetNotifyCommandArg(__in LPCWSTR lpszNotifyCommandArg)
{
	if (NULL == lpszNotifyCommandArg) {
		ATLASSERT(false);
		return false;
	}

	m_strNotifyCommandArg = lpszNotifyCommandArg;

	return true;
}

