#pragma once
#include "resource.h"
#include "JobPropertySheetDef.h"


class CJobFileDetailsPage: public CPropertyPageImpl<CJobFileDetailsPage>,
	public CWinDataExchange<CJobFileDetailsPage>
{
public:
	enum { IDD = IDD_PROPPAGE_JOB_FILE_DETAILS };

	BEGIN_DDX_MAP(CJobFileDetailsPage)
		DDX_CONTROL_HANDLE(IDC_COMBO_REMOTE_FILE_NAME,			m_comboRemoteFileName)
		DDX_CONTROL_HANDLE(IDC_EDIT_LOCAL_FILE_NAME,			m_editLocalFileName)
		DDX_CONTROL_HANDLE(IDC_EDIT_TEMP_FILE_NAME,				m_editTempFileName)
		DDX_CONTROL_HANDLE(IDC_STATIC_FILE_SIZE,				m_staticFileSize)
		DDX_CONTROL_HANDLE(IDC_STATIC_BYTE_TRANSFERRED,			m_staticByteTransferred)
		DDX_CONTROL_HANDLE(IDC_STATIC_IS_COMPLETED,				m_staticIsCompleted)
		DDX_CONTROL_HANDLE(IDC_STATIC_VALIDATION_STATE,			m_staticValidationState)
		DDX_CONTROL_HANDLE(IDC_STATIC_IS_DOWNLOADED_FROM_PEER,	m_staticIsDonwnloadedFromPeer)
		DDX_CONTROL_HANDLE(IDC_STATIC_BYTE_FROM_ORIGIN,			m_staticByteTransferredFromOrigin)
		DDX_CONTROL_HANDLE(IDC_STATIC_BYTE_FROM_PEERS,			m_staticByteTransferredFromPeers)
		DDX_CONTROL_HANDLE(IDC_BUTTON_SET_VALIDATION_STATE,		m_buttonSetValidationState)
		DDX_CONTROL_HANDLE(IDC_LIST_FILE_RANGE,					m_listFileRange)
	END_DDX_MAP()

	BEGIN_MSG_MAP(CJobFileDetailsPage)
		MSG_WM_INITDIALOG(OnInitDialog)
		MSG_WM_DESTROY(OnDestroy)
		COMMAND_HANDLER_EX(IDC_BUTTON_SET_VALIDATION_STATE,	BN_CLICKED,		OnSetValidationStateButtonDown)
		COMMAND_HANDLER_EX(IDC_COMBO_REMOTE_FILE_NAME,	CBN_SELCHANGE,		OnRemoteFileNameComboBoxSelChange)
		COMMAND_HANDLER_EX(IDC_COMBO_REMOTE_FILE_NAME,	CBN_SELENDCANCEL,	OnRemoteFileNameComboBoxSelChange)
		COMMAND_HANDLER_EX(IDC_COMBO_REMOTE_FILE_NAME,	CBN_DROPDOWN,		OnRemoteFileNameComboBoxDropDown)
		CHAIN_MSG_MAP(CPropertyPageImpl<CJobFileDetailsPage>)
	END_MSG_MAP()

	CJobFileDetailsPage(void);
	~CJobFileDetailsPage(void);

	void SetBITSManagerIF(__in const CComPtr<IBackgroundCopyManager>& spBITSManager);
	void SetJobIF(__in const CComPtr<IBackgroundCopyJob>& spJob);

	__checkReturn bool IsBITS20Supported(void);

private:
	CComPtr<IBackgroundCopyManager>	m_spBITSManager;
	CComQIPtr<IBackgroundCopyJob2>	m_spJob2;
	CComQIPtr<IBackgroundCopyJob3>	m_spJob3;
	CComQIPtr<IBackgroundCopyJob4>	m_spJob4;

	CComboBox		m_comboRemoteFileName;
	CEdit			m_editLocalFileName;
	CEdit			m_editTempFileName;
	CStatic			m_staticFileSize;
	CStatic			m_staticByteTransferred;
	CStatic			m_staticIsCompleted;
	CStatic			m_staticValidationState;
	CStatic			m_staticIsDonwnloadedFromPeer;
	CStatic			m_staticByteTransferredFromOrigin;
	CStatic			m_staticByteTransferredFromPeers;

	CButton			m_buttonSetValidationState;
	CListViewCtrl	m_listFileRange;

	static const DWORD FILE_OFFSET_COLUMN_INDEX		= 0;
	static const DWORD FILE_OFFSET_COLUMN_WIDTH		= 220;
	static const DWORD FILE_SIZE_COLUMN_INDEX		= 1;
	static const DWORD FILE_SIZE_COLUMN_WIDTH		= 220;

	LRESULT OnInitDialog(__in CWindow /*wndFocus*/, __in LPARAM /*lInitParam*/);
	LRESULT OnDestroy(void);
	LRESULT OnSetValidationStateButtonDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	void OnRemoteFileNameComboBoxSelChange(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);
	void OnRemoteFileNameComboBoxDropDown(__in UINT /*uNotifyCode*/, __in int /*nID*/, __in CWindow /*wndCtl*/);

private:
	bool InitPropertyPageControls(void);
	bool InitFileRangeList(void);
	bool InitRemoteFileNameComboBox(void);
	bool UninitRemoteFileNameComboBox(void);

	bool RefreshUI(void);
	bool RefreshFileInfo(void);
	bool RefreshFileRangeInfo(void);

	bool InternalRefreshFileInfo(__in const CComPtr<IBackgroundCopyFile>& spFile);
	bool InternalRefreshFileInfo3(__in const CComPtr<IBackgroundCopyFile3>& spFile3);
	bool InternalRefreshFileInfo4(__in const CComPtr<IBackgroundCopyFile4>& spFile4);

	bool ResetRemoteFileNameComboBox(void);
	bool ClearAllTextControls(void);

	bool GetJobFileValidationState(__out BOOL* pbValidated);

	bool GetSelectedJobFile(__out CComPtr<IBackgroundCopyFile>* pspFile);
};
